/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.pojo.impl;

import io.konig.core.KonigException;
import io.konig.core.pojo.impl.LiteralPropertyHandler;
import io.konig.core.pojo.impl.PropertyInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class StringValueHandler
extends LiteralPropertyHandler {
    public StringValueHandler(Method setter) {
        super(setter);
    }

    @Override
    protected Object javaValue(Literal literal) {
        return literal.stringValue();
    }

    @Override
    public void handleValue(PropertyInfo propertyInfo) throws KonigException {
        Value value = propertyInfo.getObject();
        if (value instanceof URI) {
            String javaValue = value.stringValue();
            Object container = propertyInfo.getContainer();
            try {
                this.setter.invoke(container, javaValue);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new KonigException("Failed to set value", e);
            }
        } else {
            super.handleValue(propertyInfo);
        }
    }
}

