/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.project;

import io.konig.core.project.ProjectFile;
import io.konig.core.project.ProjectFileException;
import io.konig.core.project.ProjectFolder;
import java.io.File;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class Project {
    private URI id;
    private File baseDir;
    private String baseDirPath;

    public static URI createId(String groupId, String artifactId, String version) {
        StringBuilder builder = new StringBuilder();
        builder.append("urn:maven:");
        builder.append(groupId);
        builder.append('.');
        builder.append(artifactId);
        builder.append('-');
        builder.append(version);
        return new URIImpl(builder.toString());
    }

    public Project(URI id, File baseDir) {
        this.id = id;
        this.baseDir = baseDir;
        this.baseDirPath = baseDir.getAbsolutePath() + File.separator;
    }

    public URI getId() {
        return this.id;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public ProjectFile createProjectFile(String path) throws ProjectFileException {
        File file = this.baseDir == null ? null : new File(this.baseDir, path);
        return new ProjectFile(this, path, file);
    }

    public ProjectFolder createFolder(File localDir) throws ProjectFileException {
        String localPath = localDir.getAbsolutePath();
        if (!localPath.startsWith(this.baseDirPath)) {
            throw new ProjectFileException("Given file is not contained within the parent project: " + localPath);
        }
        return new ProjectFolder(this, localDir);
    }

    public ProjectFile createProjectFile(File localFile) throws ProjectFileException {
        String localPath = localFile.getAbsolutePath();
        if (!localPath.startsWith(this.baseDirPath)) {
            throw new ProjectFileException("Given file is not contained within the parent project: " + localPath);
        }
        String relativePath = localPath.substring(this.baseDirPath.length());
        return new ProjectFile(this, relativePath, localFile);
    }
}

