/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.project;

import io.konig.core.KonigException;
import io.konig.core.Vertex;
import io.konig.core.pojo.PojoCreator;
import io.konig.core.project.Project;
import io.konig.core.project.ProjectFile;
import io.konig.core.project.ProjectManager;
import io.konig.core.vocab.Konig;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectFileCreator
implements PojoCreator<ProjectFile> {
    private static final Logger logger = LoggerFactory.getLogger(ProjectFileCreator.class);

    @Override
    public ProjectFile create(Vertex v) {
        Value path = v.getValue(Konig.relativePath);
        if (path == null) {
            throw new KonigException("ProjectFile is missing the `relativePath` property");
        }
        URI projectId = v.getURI(Konig.baseProject);
        if (projectId == null) {
            throw new KonigException("ProjectFile(relativePath: '" + path + "') is missing the `baseProject` property");
        }
        Project project = ProjectManager.instance().getProjectById(projectId);
        if (project == null) {
            logger.warn("Cannot create ProjectFile " + path.toString() + " because the Project <" + projectId + "> is not found.");
            return null;
        }
        return project.createProjectFile(path.stringValue());
    }
}

