/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.reasoners;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.core.vocab.Konig;
import io.konig.core.vocab.OwlVocab;
import io.konig.formula.PathExpression;
import io.konig.formula.PrimaryExpression;
import io.konig.formula.QuantifiedExpression;
import io.konig.shacl.PredicatePath;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.PropertyPath;
import io.konig.shacl.RelationshipDegree;
import io.konig.shacl.SequencePath;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipDegreeReasoner {
    private static final Logger LOG = LoggerFactory.getLogger(RelationshipDegreeReasoner.class);

    public void computeRelationshipDegree(Graph graph, ShapeManager shapeManager, Boolean overwriteExisting) {
        Worker worker = new Worker(graph, shapeManager, overwriteExisting);
        worker.run();
    }

    private static class Worker {
        private Graph graph;
        private ShapeManager shapeManager;
        private Boolean overwriteExisting;
        private Map<URI, PropertyInfo> propertyInfo = new HashMap<URI, PropertyInfo>();

        public Worker(Graph graph, ShapeManager shapeManager, Boolean overwriteExisting) {
            this.graph = graph;
            this.shapeManager = shapeManager;
            this.overwriteExisting = overwriteExisting;
        }

        private void run() {
            this.collectPropertyInfo();
            this.computeRelationshipDegrees();
        }

        private void collectPropertyInfo() {
            this.collectRdfProperties();
            this.collectPropertyConstraints();
        }

        private void collectPropertyConstraints() {
            for (Shape shape : this.shapeManager.listShapes()) {
                this.collectPropertyConstraintsFromShape(shape);
            }
        }

        private void collectPropertyConstraintsFromShape(Shape shape) {
            for (PropertyConstraint p : shape.getProperty()) {
                SequencePath sequence;
                PropertyPath last;
                PropertyPath path;
                URI predicate = p.getPredicate();
                PropertyInfo info = null;
                if (predicate != null) {
                    info = this.producePropertyInfo(predicate);
                    info.addPropertyConstraint(p);
                }
                if (!((path = p.getPath()) instanceof SequencePath) || !((last = (sequence = (SequencePath)path).getLast()) instanceof PredicatePath)) continue;
                URI pathPredicate = ((PredicatePath)last).getPredicate();
                PropertyInfo pathInfo = this.producePropertyInfo(pathPredicate);
                this.assertAlias(info, pathInfo);
            }
        }

        private void assertAlias(PropertyInfo a, PropertyInfo b) {
            if (a != null && b != null) {
                Set<PropertyInfo> aAlias = a.getAlias();
                Set<PropertyInfo> bAlias = b.getAlias();
                if (aAlias == null && bAlias == null) {
                    HashSet<PropertyInfo> set = new HashSet<PropertyInfo>();
                    set.add(a);
                    set.add(b);
                    a.setAlias(set);
                    b.setAlias(set);
                } else if (aAlias != null && bAlias == null) {
                    aAlias.add(b);
                    b.setAlias(aAlias);
                } else if (aAlias == null && bAlias != null) {
                    bAlias.add(a);
                    a.setAlias(bAlias);
                } else if (aAlias != bAlias) {
                    Set<PropertyInfo> union = aAlias;
                    union.addAll(bAlias);
                    for (PropertyInfo info : union) {
                        info.setAlias(union);
                    }
                }
            }
        }

        private PropertyInfo producePropertyInfo(URI predicate) {
            PropertyInfo info = this.propertyInfo.get(predicate);
            if (info == null) {
                info = this.createPropertyInfo(predicate);
            }
            return info;
        }

        private void collectRdfProperties() {
            List<Vertex> propertyList = this.graph.v((Resource)RDF.PROPERTY).union(new Value[]{OWL.OBJECTPROPERTY, OWL.DATATYPEPROPERTY}).isIRI().in(RDF.TYPE).toVertexList();
            for (Vertex property : propertyList) {
                URI predicate = (URI)property.getId();
                this.createPropertyInfo(predicate);
            }
        }

        private PropertyInfo createPropertyInfo(URI predicate) {
            Set<Edge> inverseSet;
            Vertex inverse;
            Vertex property = this.graph.getVertex((Resource)predicate);
            if (property == null) {
                property = this.graph.vertex((Resource)predicate);
                this.graph.edge((Resource)predicate, RDF.TYPE, (Value)RDF.PROPERTY);
            }
            if ((inverse = property.getVertex(OWL.INVERSEOF)) == null && !(inverseSet = property.inProperty(OWL.INVERSEOF)).isEmpty()) {
                inverse = this.graph.getVertex(inverseSet.iterator().next().getSubject());
            }
            PropertyInfo info = new PropertyInfo(property, inverse);
            this.propertyInfo.put(predicate, info);
            return info;
        }

        private void computeRelationshipDegrees() {
            for (PropertyInfo info : this.propertyInfo.values()) {
                this.computeRelationshipDegree(info);
                this.propertyInfo.put(info.getPropertyId(), info);
                for (Shape shape : this.shapeManager.listShapes()) {
                    PropertyConstraint pc = shape.getPropertyConstraint(info.getPropertyId());
                    if (pc == null || pc.getRelationshipDegree() != null && !this.overwriteExisting.booleanValue()) continue;
                    pc.setRelationshipDegree(info.getRelationshipDegree());
                    shape.updatePropertyConstraint(pc);
                    this.shapeManager.addShape(shape);
                }
            }
        }

        private void computeRelationshipDegree(PropertyInfo info) {
            if (info.getRelationshipDegree() == null) {
                Integer left = 0;
                Integer right = 0;
                Vertex inverseProperty = info.getInverse();
                URI inverseRelationshipDegree = null;
                URI q = null;
                if (inverseProperty != null) {
                    inverseRelationshipDegree = inverseProperty.getURI(Konig.relationshipDegree);
                    q = (URI)inverseProperty.getId();
                }
                if (inverseRelationshipDegree != null) {
                    if (Konig.OneToOne.equals((Object)inverseRelationshipDegree)) {
                        info.setRelationshipDegree(RelationshipDegree.OneToOne);
                    } else if (Konig.OneToMany.equals((Object)inverseRelationshipDegree)) {
                        info.setRelationshipDegree(RelationshipDegree.ManyToOne);
                    } else if (Konig.ManyToOne.equals((Object)inverseRelationshipDegree)) {
                        info.setRelationshipDegree(RelationshipDegree.OneToMany);
                    } else if (Konig.ManyToMany.equals((Object)inverseRelationshipDegree)) {
                        info.setRelationshipDegree(RelationshipDegree.ManyToMany);
                    }
                    return;
                }
                if (q != null) {
                    left = this.getMax(this.getOwlMaxCardinality(q), this.getShMaxCardinality(q));
                }
                right = this.getMax(this.getOwlMaxCardinality(info.getPropertyId()), this.getShMaxCardinality(info.getPropertyId()));
                if (left == 1 && right == 1) {
                    info.setRelationshipDegree(RelationshipDegree.OneToOne);
                } else if (left == 1 && right != 1) {
                    info.setRelationshipDegree(RelationshipDegree.OneToMany);
                } else if (left != 1 && right == 1) {
                    info.setRelationshipDegree(RelationshipDegree.ManyToOne);
                } else if (left != 1 && right != 1) {
                    info.setRelationshipDegree(RelationshipDegree.ManyToMany);
                }
            }
        }

        private Integer getOwlMaxCardinality(URI p) {
            int max = 0;
            OwlReasoner owlReasoner = new OwlReasoner(this.graph);
            if (owlReasoner.isTypeOf((Resource)p, (Resource)OWL.FUNCTIONALPROPERTY)) {
                return 1;
            }
            Set<URI> uriSet = owlReasoner.inverseOf(p);
            URI q = null;
            if (uriSet != null && uriSet.iterator().hasNext()) {
                q = uriSet.iterator().next();
            }
            List<Value> maxCardinalityList = this.graph.v((Resource)p).in(OWL.ONPROPERTY).out(OWL.MAXCARDINALITY).toValueList();
            List<Value> maxQualifiedCardinalityList = this.graph.v((Resource)p).in(OWL.ONPROPERTY).out(OwlVocab.maxQualifiedCardinality).toValueList();
            max = this.getMax(this.getMax(maxCardinalityList), this.getMax(maxQualifiedCardinalityList));
            return max;
        }

        private Integer getShMaxCardinality(URI p) {
            int max = 0;
            for (Shape shape : this.shapeManager.listShapes()) {
                if (shape.getProperty() == null) continue;
                for (PropertyConstraint q : shape.getProperty()) {
                    PropertyPath path = q.getPath();
                    if (!(path instanceof PredicatePath) && !(path instanceof SequencePath) || q.getFormula() == null) continue;
                    QuantifiedExpression quantifiedExpression = q.getFormula();
                    PrimaryExpression primaryExpression = quantifiedExpression.asPrimaryExpression();
                    String propertyPath = null;
                    if (primaryExpression instanceof PathExpression) {
                        PathExpression pathExp = (PathExpression)primaryExpression;
                        propertyPath = pathExp.simpleText();
                    }
                    String propPathToCompare = p.getLocalName();
                    if (propertyPath == null || !propertyPath.endsWith(propPathToCompare) || q.getMaxCount() == null) continue;
                    max = this.getMax(max, q.getMaxCount());
                }
            }
            return max;
        }

        private Integer getMax(List<Value> valueList) {
            Integer max = 0;
            Integer intValue = 0;
            try {
                if (valueList != null) {
                    for (Value v : valueList) {
                        intValue = Integer.parseInt(v.stringValue());
                        if (intValue <= max) continue;
                        max = intValue;
                    }
                }
            }
            catch (NumberFormatException e) {
                LOG.error("Error while getting maxCardinality value:" + intValue, (Throwable)e);
            }
            return max;
        }

        private Integer getMax(Integer count1, Integer count2) {
            Integer max = null;
            if (count1 != null && count2 != null) {
                max = count1 > count2 ? count1 : count2;
            } else if (count1 != null) {
                max = count1;
            } else if (count2 != null) {
                max = count2;
            }
            return max;
        }
    }

    private static class PropertyInfo {
        private Vertex property;
        private Vertex inverse;
        private RelationshipDegree relationshipDegree;
        private Set<PropertyInfo> alias;
        private Set<PropertyConstraint> propertyConstraints = new HashSet<PropertyConstraint>();

        public PropertyInfo(Vertex property, Vertex inverse) {
            this.property = property;
            this.inverse = inverse;
        }

        public Vertex getProperty() {
            return this.property;
        }

        public Vertex getInverse() {
            return this.inverse;
        }

        public Set<PropertyConstraint> getPropertyConstraints() {
            return this.propertyConstraints;
        }

        public URI getPropertyId() {
            return (URI)this.property.getId();
        }

        public RelationshipDegree getRelationshipDegree() {
            return this.relationshipDegree;
        }

        public void setRelationshipDegree(RelationshipDegree relationshipDegree) {
            this.relationshipDegree = relationshipDegree;
        }

        public void addPropertyConstraint(PropertyConstraint p) {
            this.propertyConstraints.add(p);
        }

        public Set<PropertyInfo> getAlias() {
            return this.alias;
        }

        public void setAlias(Set<PropertyInfo> set) {
            this.alias = set;
        }
    }
}

