/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.Graph;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.core.showl.OverlayTransformService;
import io.konig.core.showl.ShowlAlternativePathsExpression;
import io.konig.core.showl.ShowlAndExpression;
import io.konig.core.showl.ShowlArrayExpression;
import io.konig.core.showl.ShowlBasicStructExpression;
import io.konig.core.showl.ShowlChannel;
import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlDelegationExpression;
import io.konig.core.showl.ShowlDerivedPropertyList;
import io.konig.core.showl.ShowlDirectPropertyExpression;
import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlEffectiveNodeShape;
import io.konig.core.showl.ShowlEnumIndividualReference;
import io.konig.core.showl.ShowlEnumNodeExpression;
import io.konig.core.showl.ShowlEnumPropertyExpression;
import io.konig.core.showl.ShowlEnumStructExpression;
import io.konig.core.showl.ShowlEqualStatement;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlFilterExpression;
import io.konig.core.showl.ShowlFunctionExpression;
import io.konig.core.showl.ShowlInwardPropertyShape;
import io.konig.core.showl.ShowlIriReferenceExpression;
import io.konig.core.showl.ShowlListExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlNodeShapeService;
import io.konig.core.showl.ShowlOverlayExpression;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlPropertyExpression;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlPropertyShapeGroup;
import io.konig.core.showl.ShowlSchemaService;
import io.konig.core.showl.ShowlSourceNodeFactory;
import io.konig.core.showl.ShowlStatement;
import io.konig.core.showl.ShowlStructExpression;
import io.konig.core.showl.ShowlSystimeExpression;
import io.konig.core.showl.ShowlTeleportExpression;
import io.konig.core.showl.ShowlTransformService;
import io.konig.core.showl.ShowlUniqueKey;
import io.konig.core.showl.ShowlUniqueKeyCollection;
import io.konig.core.showl.ShowlUtil;
import io.konig.core.showl.SynsetNode;
import io.konig.core.showl.SynsetProperty;
import io.konig.core.showl.UniqueKeyElement;
import io.konig.core.showl.UniqueKeyFactory;
import io.konig.core.showl.UniqueKeySelector;
import io.konig.core.util.IriTemplate;
import io.konig.core.vocab.Konig;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.XMLSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicTransformService
implements ShowlTransformService {
    private static final Logger logger = LoggerFactory.getLogger(BasicTransformService.class);
    private ShowlSourceNodeFactory sourceNodeFactory;
    private ShowlSchemaService schemaService;
    private ShowlNodeShapeService nodeService;

    public BasicTransformService(ShowlSchemaService schemaService, ShowlNodeShapeService nodeService, ShowlSourceNodeFactory sourceNodeFactory) {
        this.schemaService = schemaService;
        this.nodeService = nodeService;
        this.sourceNodeFactory = sourceNodeFactory;
    }

    protected OwlReasoner owlReasoner() {
        return this.schemaService.getOwlReasoner();
    }

    public static Logger getLogger() {
        return logger;
    }

    public ShowlSourceNodeFactory getSourceNodeFactory() {
        return this.sourceNodeFactory;
    }

    public ShowlSchemaService getSchemaService() {
        return this.schemaService;
    }

    public void setSourceNodeFactory(ShowlSourceNodeFactory sourceNodeFactory) {
        this.sourceNodeFactory = sourceNodeFactory;
    }

    public ShowlNodeShapeService getNodeService() {
        return this.nodeService;
    }

    protected Set<ShowlPropertyShapeGroup> basicComputeTransform(ShowlNodeShape targetNode) throws ShowlProcessingException {
        Set<ShowlNodeShape> candidates = this.sourceNodeFactory.candidateSourceNodes(targetNode);
        State state = this.createState(targetNode, this.propertyPool(targetNode), candidates, this.nodeService);
        state.memory.add(targetNode);
        if (state.propertyPool.isEmpty()) {
            throw new ShowlProcessingException("No properties found in target node " + targetNode.getPath());
        }
        if (state.candidateSet.isEmpty()) {
            logger.warn("Failed to transform {}.  No candidate source shapes were found.", (Object)targetNode.getPath());
        } else {
            ShowlNodeShape sourceShape;
            while (!state.done() && (sourceShape = this.nextSource(state)) != null && this.addChannel(state, sourceShape, targetNode)) {
                this.computeMapping(sourceShape, state);
                this.mapEnumProperties(state);
                this.removeWellDefinedNodes(state);
                this.addCandidateSource(state);
            }
        }
        this.handleModifiedProperty(state);
        this.handleTargetFormulas(state);
        this.handleTeleportFormulas(state);
        this.setTargetProperties(state.targetNode);
        return state.propertyPool;
    }

    protected State createState(ShowlNodeShape targetNode, Set<ShowlPropertyShapeGroup> propertyPool, Set<ShowlNodeShape> candidates, ShowlNodeShapeService nodeService) {
        return new State(targetNode, propertyPool, candidates, nodeService, this.enumMap());
    }

    protected Map<ShowlPropertyShape, ShowlNodeShape> enumMap() {
        return new HashMap<ShowlPropertyShape, ShowlNodeShape>();
    }

    private void setTargetProperties(ShowlNodeShape targetNode) {
        for (ShowlChannel channel : targetNode.getChannels()) {
            ShowlNodeShape sourceNode = channel.getSourceNode();
            this.setTargetProperties(sourceNode, sourceNode.getTargetNode().effectiveNode());
        }
    }

    private void setTargetProperties(ShowlNodeShape sourceNode, ShowlEffectiveNodeShape targetNode) {
        this.setTargetProperties(sourceNode.getProperties(), targetNode);
        for (ShowlDerivedPropertyList list : sourceNode.getDerivedProperties()) {
            this.setTargetProperties(list, targetNode);
        }
    }

    private void setTargetProperties(Collection<? extends ShowlPropertyShape> sourceProperties, ShowlEffectiveNodeShape targetNode) {
        for (ShowlPropertyShape showlPropertyShape : sourceProperties) {
            ShowlPropertyShapeGroup targetGroup = targetNode.findPropertyByPredicate(showlPropertyShape.getPredicate());
            if (targetGroup == null) continue;
            this.setTargetProperty(showlPropertyShape, targetGroup);
            for (ShowlPropertyShape q : showlPropertyShape.synonyms()) {
                this.setTargetProperty(q, targetGroup);
            }
        }
    }

    private void setTargetProperty(ShowlPropertyShape p, ShowlPropertyShapeGroup targetGroup) {
        p.setTargetProperty(targetGroup);
        if (p.getValueShape() != null && targetGroup.getValueShape() != null) {
            this.setTargetProperties(p.getValueShape(), targetGroup.getValueShape());
        }
    }

    @Override
    public Set<ShowlPropertyShapeGroup> computeTransform(ShowlNodeShape targetNode) throws ShowlProcessingException {
        Set<ShowlNodeShape> candidates = this.sourceNodeFactory.candidateSourceNodes(targetNode);
        if (candidates.size() > 1) {
            OverlayTransformService overlayTransform = new OverlayTransformService(this.schemaService, this.nodeService, this.sourceNodeFactory, candidates);
            return overlayTransform.computeTransform(targetNode);
        }
        return this.basicComputeTransform(targetNode);
    }

    private void handleTeleportFormulas(State state) {
        Iterator<ShowlPropertyShapeGroup> sequence = state.propertyPool.iterator();
        while (sequence.hasNext()) {
            ShowlTeleportExpression teleport;
            ShowlPropertyShapeGroup group = sequence.next();
            ShowlDirectPropertyShape direct = group.direct();
            if (direct == null || (teleport = this.teleport(group)) == null) continue;
            ShowlExpression delegate = teleport.getDelegate();
            ShowlNodeShape focusNode = teleport.getFocusNode();
            HashSet<ShowlPropertyShape> set = new HashSet<ShowlPropertyShape>();
            delegate.addProperties(set);
            int count = 0;
            block1: for (ShowlPropertyShape p : set) {
                if (p.getSelectedExpression() != null) {
                    ++count;
                    continue;
                }
                for (ShowlChannel channel : state.targetNode.getChannels()) {
                    ShowlNodeShape sourceNode = channel.getSourceNode();
                    ShowlExpression e = this.findMatch(sourceNode, p);
                    if (e == null) continue;
                    p.setSelectedExpression(e);
                    ++count;
                    continue block1;
                }
            }
            if (count != set.size()) continue;
            direct.setSelectedExpression(delegate.transform());
            sequence.remove();
        }
    }

    private ShowlTeleportExpression teleport(ShowlPropertyShapeGroup group) {
        for (ShowlPropertyShape p : group) {
            ShowlExpression formula = p.getFormula();
            if (!(formula instanceof ShowlTeleportExpression)) continue;
            return (ShowlTeleportExpression)formula;
        }
        return null;
    }

    private void handleTargetFormulas(State state) {
        if (!state.propertyPool.isEmpty()) {
            Iterator<ShowlPropertyShapeGroup> sequence = state.propertyPool.iterator();
            while (sequence.hasNext()) {
                ShowlExpression formula;
                ShowlPropertyShapeGroup group = sequence.next();
                ShowlDirectPropertyShape direct = group.direct();
                if (direct == null || (formula = direct.getFormula()) == null) continue;
                HashSet<ShowlPropertyShape> set = new HashSet<ShowlPropertyShape>();
                formula.addProperties(set);
                int count = 0;
                for (ShowlPropertyShape p : set) {
                    ShowlDirectPropertyShape pDirect;
                    ShowlExpression e = p.getSelectedExpression();
                    if (e == null && !p.isDirect() && (pDirect = p.getDeclaringShape().getProperty(p.getPredicate())) != null && (e = pDirect.getSelectedExpression()) != null) {
                        p.setSelectedExpression(e);
                    }
                    if (e == null) continue;
                    ++count;
                }
                if (count != set.size()) continue;
                ShowlExpression e = formula.transform();
                direct.setSelectedExpression(e);
                sequence.remove();
            }
        }
    }

    private void mapEnumProperties(State state) {
        for (ShowlPropertyShapeGroup group : state.propertyPool) {
            ShowlExpression sourceKeyExpression;
            ShowlDirectPropertyShape uniqueKey;
            ShowlNodeShape enumTargetNode;
            ShowlDirectPropertyShape direct = group.direct();
            if (direct == null || direct.getSelectedExpression() != null || (enumTargetNode = ShowlUtil.containingEnumNode(direct, this.schemaService.getOwlReasoner())) == null || (uniqueKey = this.uniqueKey(enumTargetNode)) == null || (sourceKeyExpression = uniqueKey.getSelectedExpression()) == null) continue;
            ShowlNodeShape enumSourceNode = state.enumNode(enumTargetNode);
            ShowlEnumNodeExpression enumNodeExpression = new ShowlEnumNodeExpression(enumSourceNode);
            enumTargetNode.getAccessor().setSelectedExpression(enumNodeExpression);
            ShowlDirectPropertyShape sourceKey = enumSourceNode.getProperty(uniqueKey.getPredicate());
            if (sourceKey == null) {
                throw new ShowlProcessingException("Unique key '" + uniqueKey.getPredicate().getLocalName() + "' not found in for " + enumTargetNode.getPath());
            }
            this.computeEnumMapping(state, enumSourceNode, enumTargetNode);
            ShowlEqualStatement statement = new ShowlEqualStatement(this.expression(sourceKey), sourceKeyExpression);
            ShowlChannel channel = new ShowlChannel(enumSourceNode, statement);
            state.targetNode.addChannel(channel);
            enumNodeExpression.setChannel(channel);
            enumNodeExpression.setJoinStatement(statement);
        }
    }

    private void computeEnumMapping(State state, ShowlNodeShape enumSourceNode, ShowlNodeShape enumTargetNode) {
        for (ShowlPropertyShape showlPropertyShape : enumTargetNode.getProperties()) {
            ShowlDirectPropertyShape sourceProperty = enumSourceNode.getProperty(showlPropertyShape.getPredicate());
            if (sourceProperty == null) continue;
            if (showlPropertyShape.getValueShape() != null) {
                if (sourceProperty.getValueShape() == null) continue;
                if (showlPropertyShape.getSelectedExpression() == null) {
                    this.fail("EnumNodeExpression not found for {0}", showlPropertyShape.getPath());
                }
                this.computeEnumMapping(state, sourceProperty.getValueShape(), showlPropertyShape.getValueShape());
                continue;
            }
            if (showlPropertyShape.getSelectedExpression() == null && logger.isTraceEnabled()) {
                logger.trace("Replacing expression for {} with enum property expression", (Object)showlPropertyShape.getPath());
            }
            showlPropertyShape.setSelectedExpression(new ShowlEnumPropertyExpression(sourceProperty));
        }
    }

    private ShowlDirectPropertyShape uniqueKey(ShowlNodeShape enumNode) {
        for (ShowlDirectPropertyShape p : enumNode.getProperties()) {
            if (p.getSelectedExpression() == null || !ShowlUtil.isUniqueKey(p, this.schemaService.getOwlReasoner())) continue;
            return p;
        }
        return null;
    }

    private void removeWellDefinedNodes(State state) {
        Iterator<ShowlPropertyShapeGroup> sequence = state.propertyPool.iterator();
        while (sequence.hasNext()) {
            ShowlDirectPropertyShape direct;
            ShowlPropertyShapeGroup group = sequence.next();
            if (group.getValueShape() == null || (direct = group.direct()) == null || direct.getValueShape() == null || !ShowlUtil.isWellDefined(direct.getValueShape())) continue;
            if (logger.isTraceEnabled()) {
                logger.trace("Nested record is well-defined: {}", (Object)direct.getPath());
            }
            sequence.remove();
        }
    }

    private void addCandidateSource(State state) throws ShowlProcessingException {
        Set<ShowlPropertyShapeGroup> propertyPool = state.propertyPool;
        if (!propertyPool.isEmpty() && state.candidateSet.isEmpty()) {
            Iterator<ShowlPropertyShapeGroup> sequence = propertyPool.iterator();
            while (sequence.hasNext()) {
                ShowlPropertyShapeGroup targetGroup = sequence.next();
                ShowlDirectPropertyShape targetDirect = targetGroup.direct();
                if (targetDirect == null) {
                    throw new ShowlProcessingException("Direct property missing for " + targetGroup.pathString() + ", perhaps because derived properties are not yet supported.");
                }
                if (targetDirect.getSelectedExpression() != null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("addCandidateSource: Removing property from pool because it was mapped out of sequence: {}", (Object)targetDirect.getPath());
                    }
                    sequence.remove();
                    continue;
                }
                ShowlEffectiveNodeShape parentNode = targetGroup.getDeclaringShape();
                ShowlClass targetClass = parentNode.getTargetClass();
                if (state.memory.contains(targetGroup)) continue;
                state.memory.add(targetGroup);
                if (this.isEnumClass(targetClass)) {
                    if (!this.acceptEnumClass(targetGroup)) continue;
                    ShowlNodeShape enumNode = state.enumNode(parentNode.canonicalNode());
                    enumNode.setTargetNode(((ShowlPropertyShape)targetGroup.iterator().next()).getDeclaringShape());
                    state.candidateSet.add(enumNode);
                    return;
                }
                ShowlNodeShape targetNodeShape = parentNode.directNode();
                if (state.memory.contains(targetNodeShape)) continue;
                state.memory.add(targetNodeShape);
                Set<ShowlNodeShape> candidates = this.sourceNodeFactory.candidateSourceNodes(targetNodeShape);
                if (candidates.isEmpty()) continue;
                state.candidateSet.addAll(candidates);
                if (logger.isTraceEnabled()) {
                    logger.trace("addCandidateSource: For {}, adding candidates...", (Object)targetGroup.pathString());
                    for (ShowlNodeShape c : candidates) {
                        logger.trace("    " + c.getPath());
                    }
                }
                return;
            }
        }
    }

    protected boolean acceptEnumClass(ShowlPropertyShapeGroup targetGroup) {
        return true;
    }

    private boolean isEnumClass(ShowlClass targetClass) {
        return targetClass == null ? false : this.schemaService.getOwlReasoner().isEnumerationClass((Resource)targetClass.getId());
    }

    private boolean addChannel(State state, ShowlNodeShape sourceShape, ShowlNodeShape targetRoot) {
        if (targetRoot.getChannels().isEmpty()) {
            targetRoot.addChannel(new ShowlChannel(sourceShape, null));
            if (logger.isTraceEnabled()) {
                logger.trace("addChannel({})", (Object)sourceShape.getPath());
            }
            return true;
        }
        if (this.isEnumClass(sourceShape.getOwlClass())) {
            ShowlNodeShape targetNode;
            ShowlPropertyShape targetAccessor;
            ShowlChannel priorChannel = targetRoot.findChannelFor(sourceShape);
            ShowlStatement join = null;
            if (this.requiresEnumJoin(priorChannel) && (join = this.enumJoinStatement(state, sourceShape)) == null) {
                return false;
            }
            if (priorChannel != null) {
                if (join != null) {
                    ShowlStatement priorStatement = priorChannel.getJoinStatement();
                    if (priorStatement == null) {
                        priorChannel.setJoinStatement(join);
                    } else {
                        HashSet<ShowlPropertyShape> set = new HashSet<ShowlPropertyShape>();
                        priorStatement.addDeclaredProperties(sourceShape, set);
                        if (set.isEmpty()) {
                            if (priorStatement instanceof ShowlOverlayExpression) {
                                ShowlOverlayExpression overlay = (ShowlOverlayExpression)priorStatement;
                                overlay.add(join);
                            } else {
                                ShowlOverlayExpression overlay = new ShowlOverlayExpression();
                                overlay.add(priorStatement);
                                overlay.add(join);
                                priorChannel.setJoinStatement(overlay);
                            }
                        }
                    }
                }
                return true;
            }
            ShowlChannel channel = new ShowlChannel(sourceShape, join);
            if (sourceShape.getTargetNode() != null && (targetAccessor = (targetNode = sourceShape.getTargetNode()).getAccessor()) != null && targetAccessor.getSelectedExpression() == null) {
                ShowlNodeShape enode = state.enumNode(targetNode);
                ShowlEnumNodeExpression accessorExpression = new ShowlEnumNodeExpression(enode, channel);
                targetAccessor.setSelectedExpression(accessorExpression);
            }
            targetRoot.addChannel(channel);
            if (logger.isTraceEnabled()) {
                String joinString = join == null ? "null" : join.toString();
                logger.trace("addChannel({}, {})", (Object)sourceShape.getPath(), (Object)joinString);
            }
            return true;
        }
        if (this.channelExists(sourceShape, targetRoot)) {
            return true;
        }
        ShowlNodeShape targetNode = sourceShape.getTargetNode();
        ShowlPropertyShape targetAccessor = targetNode.getAccessor();
        if (targetAccessor == null) {
            if (this.joinById(sourceShape)) {
                return true;
            }
        } else {
            ShowlPropertyShape targetId = targetAccessor.getDeclaringShape().findOut(Konig.id);
            URI targetAccessorPredicate = targetAccessor.getPredicate();
            if (targetId != null && targetId.getSelectedExpression() != null) {
                ShowlExpression leftJoinExpression = targetId.getSelectedExpression();
                Set<URI> inverseSet = this.schemaService.getOwlReasoner().inverseOf(targetAccessorPredicate);
                for (URI inverseProperty : inverseSet) {
                    ShowlPropertyShape sourceJoinProperty = sourceShape.findOut(inverseProperty);
                    if (sourceJoinProperty == null) continue;
                    ShowlEqualStatement join = new ShowlEqualStatement(leftJoinExpression, ShowlUtil.propertyExpression(sourceJoinProperty));
                    targetRoot.addChannel(new ShowlChannel(sourceShape, join));
                    return true;
                }
                for (ShowlInwardPropertyShape inwardProperty : sourceShape.getInwardProperties()) {
                    URI inwardPredicate = inwardProperty.getPredicate();
                    ShowlPropertyShape inwardDirect = inwardProperty.getSynonym();
                    if (!(inwardDirect instanceof ShowlDirectPropertyShape) || !targetAccessorPredicate.equals((Object)inwardPredicate)) continue;
                    ShowlEqualStatement join = new ShowlEqualStatement(leftJoinExpression, ShowlUtil.propertyExpression(inwardDirect));
                    targetRoot.addChannel(new ShowlChannel(sourceShape, join));
                    return true;
                }
            }
        }
        if (this.joinByUniqueKey(sourceShape)) {
            return true;
        }
        if (logger.isWarnEnabled()) {
            logger.warn("Failed to create channel for {} in transform of {}", (Object)sourceShape.getPath(), (Object)sourceShape.getTargetNode().getPath());
        }
        return false;
    }

    private boolean requiresEnumJoin(ShowlChannel priorChannel) {
        if (priorChannel == null) {
            return true;
        }
        ShowlStatement priorStatement = priorChannel.getJoinStatement();
        if (priorStatement == null) {
            return true;
        }
        ShowlNodeShape sourceShape = priorChannel.getSourceNode();
        HashSet<ShowlPropertyShape> set = new HashSet<ShowlPropertyShape>();
        priorStatement.addDeclaredProperties(sourceShape, set);
        return set.isEmpty();
    }

    private boolean joinByUniqueKey(ShowlNodeShape sourceNode) {
        ShowlNodeShape targetNode = sourceNode.getTargetNode();
        UniqueKeyFactory factory = new UniqueKeyFactory(this.schemaService.getOwlReasoner());
        ShowlUniqueKeyCollection keyCollection = this.keyCollection(factory, sourceNode);
        UniqueKeySelector selector = new UniqueKeySelector(this.schemaService.getOwlReasoner());
        for (ShowlChannel channel : targetNode.getChannels()) {
            ShowlNodeShape otherSourceNode = channel.getSourceNode();
            ShowlUniqueKeyCollection otherKeyCollection = this.keyCollection(factory, otherSourceNode);
            ArrayList<ShowlUniqueKeyCollection> list = new ArrayList<ShowlUniqueKeyCollection>();
            list.add(keyCollection);
            list.add(otherKeyCollection);
            Map<ShowlNodeShape, ShowlUniqueKey> map = selector.selectBestKey(list);
            if (map.isEmpty()) continue;
            ShowlUniqueKey key = map.get(sourceNode);
            ShowlUniqueKey otherKey = map.get(otherSourceNode);
            ShowlStatement join = this.joinStatement(key, otherKey);
            ShowlNodeShape targetRoot = targetNode.getRoot();
            targetRoot.addChannel(new ShowlChannel(sourceNode, join));
            return true;
        }
        return false;
    }

    private ShowlStatement joinStatement(ShowlUniqueKey leftKey, ShowlUniqueKey rightKey) {
        List<UniqueKeyElement> leftList = leftKey.flatten();
        List<UniqueKeyElement> rightList = rightKey.flatten();
        if (leftList.size() == 1) {
            return this.equalStatement(leftList.get(0), rightList.get(0));
        }
        ArrayList<ShowlExpression> operands = new ArrayList<ShowlExpression>();
        for (int i = 0; i < leftList.size(); ++i) {
            operands.add(this.equalStatement(leftList.get(i), rightList.get(i)));
        }
        return new ShowlAndExpression(operands);
    }

    private ShowlEqualStatement equalStatement(UniqueKeyElement leftElement, UniqueKeyElement rightElement) {
        return new ShowlEqualStatement(this.expression(leftElement.getPropertyShape()), this.expression(rightElement.getPropertyShape()));
    }

    private ShowlUniqueKeyCollection keyCollection(UniqueKeyFactory factory, ShowlNodeShape sourceNode) {
        ShowlUniqueKeyCollection key = sourceNode.getUniqueKeyCollection();
        if (key == null) {
            key = factory.createKeyCollection(sourceNode);
            sourceNode.setUniqueKeyCollection(key);
        }
        return key;
    }

    private boolean channelExists(ShowlNodeShape sourceShape, ShowlNodeShape targetRoot) {
        for (ShowlChannel channel : targetRoot.getChannels()) {
            if (channel.getSourceNode() != sourceShape) continue;
            return true;
        }
        return false;
    }

    private boolean joinById(ShowlNodeShape sourceShape) throws ShowlProcessingException {
        ShowlPropertyShape leftId = sourceShape.findOut(Konig.id);
        if (leftId != null) {
            ShowlExpression leftExpression = this.expression(leftId);
            ShowlNodeShape targetRoot = sourceShape.getTargetNode().getRoot();
            for (ShowlChannel leftChannel : targetRoot.getChannels()) {
                ShowlNodeShape leftSource = leftChannel.getSourceNode();
                ShowlPropertyShape rightId = leftSource.findOut(Konig.id);
                if (rightId == null) continue;
                ShowlExpression rightExpression = this.expression(rightId);
                ShowlEqualStatement equals = new ShowlEqualStatement(leftExpression, rightExpression);
                ShowlChannel channel = new ShowlChannel(sourceShape, equals);
                targetRoot.addChannel(channel);
                if (logger.isTraceEnabled()) {
                    logger.trace("joinById: addChannel({}, {})", (Object)sourceShape.getPath(), (Object)equals.toString());
                }
                return true;
            }
        }
        return false;
    }

    private ShowlExpression expression(ShowlPropertyShape p) throws ShowlProcessingException {
        if (p instanceof ShowlDirectPropertyShape) {
            return new ShowlDirectPropertyExpression((ShowlDirectPropertyShape)p);
        }
        if (p.getFormula() != null) {
            return p.getFormula();
        }
        throw new ShowlProcessingException("Failed to get expression for " + p.getPath());
    }

    protected ShowlStatement enumJoinStatement(State state, ShowlNodeShape sourceShape) throws ShowlProcessingException {
        ShowlExpression formula;
        ShowlNodeShape root = sourceShape.getTargetNode().getRoot();
        ShowlEffectiveNodeShape enumNode = sourceShape.effectiveNode();
        ShowlDirectPropertyShape enumId = sourceShape.getProperty(Konig.id);
        OwlReasoner reasoner = this.schemaService.getOwlReasoner();
        ShowlNodeShape targetNode = sourceShape.getTargetNode();
        ShowlPropertyShape targetAccessor = targetNode.getAccessor();
        if (targetAccessor.getSelectedExpression() instanceof ShowlDirectPropertyExpression) {
            return new ShowlEqualStatement(new ShowlDirectPropertyExpression(enumId), targetAccessor.getSelectedExpression());
        }
        if (targetAccessor.getFormula() instanceof ShowlEnumIndividualReference || targetAccessor.getFormula() instanceof ShowlIriReferenceExpression) {
            return new ShowlEqualStatement(new ShowlDirectPropertyExpression(enumId), targetAccessor.getFormula());
        }
        for (ShowlChannel channel : root.getChannels()) {
            PropertyConstraint constraint;
            ShowlDirectPropertyShape channelJoinAccessorDirect;
            ShowlNodeShape channelSourceNode = channel.getSourceNode();
            ShowlPropertyShapeGroup channelJoinAccessor = this.findPeer(channelSourceNode, targetNode);
            if (channelJoinAccessor == null) continue;
            ShowlStatement result = this.enumFilter(targetNode, sourceShape, channelJoinAccessor);
            if (result != null) {
                return result;
            }
            ShowlEffectiveNodeShape channelJoinNode = channelJoinAccessor.getValueShape();
            if (channelJoinNode == null && (channelJoinAccessorDirect = channelJoinAccessor.synonymDirect()) != null && ((constraint = channelJoinAccessorDirect.getPropertyConstraint()).getNodeKind() == NodeKind.IRI || XMLSchema.STRING.equals((Object)constraint.getDatatype())) && constraint.getShape() == null) {
                ShowlEnumPropertyExpression left = new ShowlEnumPropertyExpression(enumId.direct());
                ShowlPropertyExpression right = ShowlUtil.propertyExpression(channelJoinAccessorDirect);
                return new ShowlEqualStatement(left, right);
            }
            if (channelJoinNode == null) continue;
            for (ShowlPropertyShapeGroup enumProperty : enumNode.getProperties()) {
                URI predicate = enumProperty.getPredicate();
                ShowlPropertyShapeGroup channelPropertyGroup = channelJoinNode.findPropertyByPredicate(predicate);
                if (channelPropertyGroup == null) continue;
                ShowlDirectPropertyShape targetProperty = targetNode.getProperty(predicate);
                if (!reasoner.isInverseFunctionalProperty(predicate) && !channelPropertyGroup.isUniqueKey() && (targetProperty == null || !targetProperty.isUniqueKey())) continue;
                ShowlPropertyShape channelProperty = channelPropertyGroup.direct();
                if (channelProperty == null) {
                    for (ShowlPropertyShape p : channelPropertyGroup) {
                        ShowlPropertyShape synonym = p.getSynonym();
                        if (synonym instanceof ShowlDirectPropertyShape) {
                            channelProperty = synonym;
                            continue;
                        }
                        if (!ShowlUtil.isWellDefined(p)) continue;
                        channelProperty = p;
                        break;
                    }
                }
                if (channelProperty == null) continue;
                ShowlEnumPropertyExpression left = new ShowlEnumPropertyExpression(enumProperty.direct());
                ShowlPropertyExpression right = ShowlUtil.propertyExpression(channelProperty);
                return new ShowlEqualStatement(left, right);
            }
        }
        ShowlPropertyShape targetProperty = targetNode.getAccessor();
        if (targetProperty != null && (formula = targetProperty.getFormula()) != null) {
            ShowlEnumPropertyExpression left = new ShowlEnumPropertyExpression(enumId.direct());
            ShowlExpression right = formula;
            return new ShowlEqualStatement(left, right);
        }
        return null;
    }

    private ShowlStatement enumFilter(ShowlNodeShape targetNode, ShowlNodeShape sourceShape, ShowlPropertyShapeGroup channelJoinAccessor) {
        if (this.hasFilter(channelJoinAccessor)) {
            ShowlPropertyShape multiValuedProperty = this.findMultiValuedProperty(targetNode.getAccessor());
            if (multiValuedProperty != null) {
                ShowlExpression e = multiValuedProperty.getSelectedExpression();
                if (e == null) {
                    e = new ShowlArrayExpression();
                    multiValuedProperty.setSelectedExpression(e);
                }
                if (e instanceof ShowlArrayExpression) {
                    this.fail("Array of enum not supported yet", new Object[0]);
                }
            }
            throw new ShowlProcessingException("Failed to create enum filter for " + targetNode.getPath());
        }
        return null;
    }

    private ShowlPropertyShape findMultiValuedProperty(ShowlPropertyShape p) {
        while (p != null) {
            Integer maxCount;
            PropertyConstraint constraint = p.getPropertyConstraint();
            if (constraint != null && ((maxCount = constraint.getMaxCount()) == null || maxCount > 1)) {
                return p;
            }
            p = p.getDeclaringShape().getAccessor();
        }
        return null;
    }

    private boolean hasFilter(ShowlPropertyShapeGroup channelJoinAccessor) {
        for (ShowlPropertyShape p : channelJoinAccessor) {
            if (p.getHasValue().isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected ShowlPropertyShapeGroup findPeer(ShowlNodeShape sourceNode, ShowlNodeShape targetNode) {
        List<URI> relativePath = ShowlUtil.relativePath(targetNode, sourceNode.getTargetNode());
        if (relativePath == null || relativePath.isEmpty()) {
            return null;
        }
        return sourceNode.effectiveNode().findPropertyByPredicatePath(relativePath);
    }

    private void computeMapping(ShowlNodeShape source, State state) {
        ShowlEffectiveNodeShape sourceNode = source.effectiveNode();
        ShowlEffectiveNodeShape targetNode = source.getTargetNode().effectiveNode();
        boolean isEnum = this.schemaService.getOwlReasoner().isEnumerationClass((Resource)sourceNode.getTargetClass().getId());
        Set<ShowlPropertyShapeGroup> propertyPool = state.propertyPool;
        Iterator<ShowlPropertyShapeGroup> sequence = propertyPool.iterator();
        while (sequence.hasNext()) {
            ShowlPropertyShapeGroup targetProperty = sequence.next();
            if (this.mapModified(state, targetProperty)) {
                sequence.remove();
                continue;
            }
            List<ShowlPropertyShapeGroup> path = targetProperty.relativePath(targetNode);
            ShowlPropertyShapeGroup sourceProperty = sourceNode.findPropertyByPath(path);
            if (sourceProperty == null) {
                sourceProperty = this.findPropertyWithSynset(source, path);
            }
            if (!this.createMapping(state, isEnum, source, sourceProperty, targetProperty)) continue;
            sequence.remove();
            this.setAccessorExpression(targetProperty);
        }
    }

    private ShowlPropertyShapeGroup findPropertyWithSynset(ShowlNodeShape source, List<ShowlPropertyShapeGroup> path) {
        ShowlPropertyShape q;
        List<URI> uriPath = this.uriPath(path);
        SynsetNode synset = source.synsetNode();
        SynsetProperty p = synset.findPropertyByPath(uriPath);
        if (p != null && (q = p.select()) != null) {
            return q.asGroup();
        }
        return null;
    }

    private List<URI> uriPath(List<ShowlPropertyShapeGroup> path) {
        ArrayList<URI> result = new ArrayList<URI>();
        for (ShowlPropertyShapeGroup group : path) {
            result.add(group.getPredicate());
        }
        return result;
    }

    private boolean mapModified(State state, ShowlPropertyShapeGroup targetProperty) {
        if (targetProperty.getPredicate().equals((Object)Konig.modified)) {
            state.setTargetModified(targetProperty);
            return true;
        }
        return false;
    }

    private void setAccessorExpression(ShowlPropertyShapeGroup targetProperty) {
        ShowlDirectPropertyShape targetDirect;
        ShowlDirectPropertyShape direct;
        ShowlEffectiveNodeShape node;
        ShowlPropertyShapeGroup group;
        if (targetProperty.getPredicate().equals((Object)Konig.id)) {
            ShowlPropertyShape accessor;
            ShowlDirectPropertyShape direct2 = targetProperty.direct();
            if (direct2 != null && direct2.getSelectedExpression() != null && (accessor = direct2.getDeclaringShape().getAccessor()) != null && accessor.getSelectedExpression() == null) {
                accessor.setSelectedExpression(direct2.getSelectedExpression());
                if (logger.isTraceEnabled()) {
                    logger.trace("setAccessorExpression: {} = {}", (Object)accessor.getPath(), (Object)direct2.getSelectedExpression().displayValue());
                }
            }
        } else if (targetProperty.getValueShape() != null && (group = (node = targetProperty.getValueShape()).findPropertyByPredicate(Konig.id)) != null && (direct = group.direct()) != null && direct.getSelectedExpression() == null && (targetDirect = targetProperty.direct()) != null && targetDirect.getSelectedExpression() != null) {
            ShowlExpression s = targetDirect.getSelectedExpression();
            if (s instanceof ShowlEnumNodeExpression && direct.getPredicate().equals((Object)Konig.id)) {
                ShowlNodeShape enumNode = ((ShowlEnumNodeExpression)s).getEnumNode();
                ShowlDirectPropertyShape enumId = enumNode.getProperty(Konig.id);
                s = new ShowlEnumPropertyExpression(enumId);
            }
            direct.setSelectedExpression(s);
            if (logger.isTraceEnabled()) {
                logger.trace("setAccessorExpression: {} = {}", (Object)direct.getPath(), (Object)targetDirect.getSelectedExpression().displayValue());
            }
        }
    }

    private boolean createMapping(State state, boolean isEnum, ShowlNodeShape sourceNode, ShowlPropertyShapeGroup sourceProperty, ShowlPropertyShapeGroup targetProperty) {
        ShowlDirectPropertyShape targetDirect = targetProperty.synonymDirect();
        if (targetDirect != null) {
            if (targetDirect.getSelectedExpression() != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("createMapping: Mapping already established, {} = {}", (Object)targetDirect.getPath(), (Object)targetDirect.getSelectedExpression().displayValue());
                }
                return true;
            }
            if (sourceProperty == null) {
                return this.createMappingFromFormula(sourceNode, targetDirect);
            }
            if (this.alternativePathsMapping(state, isEnum, sourceProperty, targetProperty)) {
                return true;
            }
            ShowlDirectPropertyShape sourceDirect = sourceProperty.synonymDirect();
            boolean bl = isEnum = isEnum ? isEnum : this.schemaService.getOwlReasoner().isEnumerationClass((Resource)targetDirect.getDeclaringShape().getOwlClass().getId());
            if (isEnum) {
                ShowlExpression enumAccessorExpression;
                ShowlPropertyShape enumAccessor;
                if (Konig.id.equals((Object)sourceDirect.getPredicate()) && (enumAccessor = targetDirect.getDeclaringShape().getAccessor()) != null && (enumAccessorExpression = enumAccessor.getSelectedExpression()) != null && !(enumAccessorExpression instanceof ShowlEnumNodeExpression)) {
                    this.fail("enum accessor is null for target property {0}", targetDirect.getPath());
                }
                targetDirect.setSelectedExpression(new ShowlEnumPropertyExpression(sourceDirect));
                ShowlPropertyShape accessor = targetDirect.getDeclaringShape().getAccessor();
                if (accessor != null && !(accessor.getSelectedExpression() instanceof ShowlEnumNodeExpression)) {
                    ShowlNodeShape enumNode = state.enumNode(targetDirect.getDeclaringShape());
                    ShowlChannel channel = this.produceChannel(state, enumNode);
                    accessor.setSelectedExpression(new ShowlEnumNodeExpression(enumNode, channel));
                }
                return true;
            }
            if (sourceDirect != null && targetDirect.isEnumIndividual(this.schemaService.getOwlReasoner()) && targetDirect.getValueShape() != null) {
                ShowlDirectPropertyShape sourceIdProperty;
                ShowlNodeShape enumNode = state.enumNode(targetDirect.getValueShape());
                enumNode.setTargetNode(targetDirect.getValueShape());
                enumNode.setTargetProperty(targetDirect);
                ShowlEnumNodeExpression enumNodeExpr = new ShowlEnumNodeExpression(enumNode);
                targetDirect.setSelectedExpression(enumNodeExpr);
                ShowlDirectPropertyShape enumId = enumNode.getProperty(Konig.id);
                ShowlDirectPropertyShape sourceId = sourceDirect;
                if (sourceDirect.getValueShape() != null && (sourceIdProperty = sourceDirect.getValueShape().getProperty(Konig.id)) != null) {
                    sourceId = sourceIdProperty;
                }
                ShowlEqualStatement joinStatement = new ShowlEqualStatement(ShowlUtil.propertyExpression(enumId), ShowlUtil.propertyExpression(sourceId));
                ShowlChannel channel = new ShowlChannel(enumNode, joinStatement);
                enumNodeExpr.setChannel(channel);
                enumNodeExpr.setJoinStatement(joinStatement);
                targetDirect.getRootNode().addChannel(channel);
                return true;
            }
            if (sourceDirect != null) {
                targetDirect.setSelectedExpression(new ShowlDirectPropertyExpression(sourceDirect));
                return true;
            }
            for (ShowlPropertyShape sourcePropertyElement : sourceProperty) {
                ShowlExpression formula = sourcePropertyElement.getFormula();
                if (!ShowlUtil.isWellDefined(formula)) continue;
                targetDirect.setSelectedExpression(formula);
                return true;
            }
            if (this.useClassIriTemplate(sourceProperty, targetDirect)) {
                return true;
            }
            if (this.useHasValue(sourceProperty, targetDirect)) {
                return true;
            }
            if (logger.isTraceEnabled() && sourceProperty.getValueShape() == null) {
                logger.trace("createMapping: Failed to create mapping: {}...{}", (Object)sourceProperty, (Object)targetProperty);
            }
        }
        return false;
    }

    private ShowlChannel produceChannel(State state, ShowlNodeShape enumNode) {
        ShowlNodeShape targetRoot = enumNode.getTargetNode().getRoot();
        this.addChannel(state, enumNode, targetRoot);
        return targetRoot.findChannelFor(enumNode);
    }

    private boolean createMappingFromFormula(ShowlNodeShape sourceNode, ShowlDirectPropertyShape targetDirect) {
        ShowlExpression e = targetDirect.getFormula();
        if (e != null) {
            HashSet<ShowlPropertyShape> set = new HashSet<ShowlPropertyShape>();
            e.addProperties(set);
            int count = 0;
            for (ShowlPropertyShape p : set) {
                if (p.getSelectedExpression() == null && !this.createMapping(sourceNode, p)) continue;
                ++count;
            }
            if (count == set.size()) {
                targetDirect.setSelectedExpression(e.transform());
                return true;
            }
        }
        return false;
    }

    private boolean createMapping(ShowlNodeShape sourceNode, ShowlPropertyShape targetProperty) {
        Set<ShowlPropertyShape> synonyms = targetProperty.synonyms();
        for (ShowlPropertyShape s : synonyms) {
            ShowlExpression match = this.findMatch(sourceNode, s);
            if (match == null) continue;
            targetProperty.setSelectedExpression(match);
            return true;
        }
        return false;
    }

    private ShowlExpression findMatch(ShowlNodeShape sourceNode, ShowlPropertyShape targetProperty) {
        List<ShowlPropertyShape> path = targetProperty.propertyPath();
        ShowlPropertyShape joinProperty = sourceNode.getTargetProperty();
        ShowlNodeShape joinNode = joinProperty == null ? sourceNode.getTargetNode() : joinProperty.getDeclaringShape();
        for (int i = 0; i < path.size(); ++i) {
            ShowlDirectPropertyShape direct;
            ShowlPropertyShape pathElement = path.get(i);
            ShowlPropertyShapeGroup group = null;
            if (pathElement.getDeclaringShape() != joinNode) continue;
            ShowlEffectiveNodeShape node = sourceNode.effectiveNode();
            for (int j = i; j < path.size(); ++j) {
                if (node == null) {
                    return null;
                }
                URI predicate = path.get(j).getPredicate();
                group = node.findPropertyByPredicate(predicate);
                if (group == null) {
                    return null;
                }
                node = group.getValueShape();
            }
            if (group == null || (direct = group.direct()) == null) continue;
            return new ShowlDirectPropertyExpression(direct);
        }
        return null;
    }

    private boolean arrayMapping(State state, ShowlPropertyShapeGroup sourcePropertyGroup, ShowlPropertyShapeGroup targetPropertyGroup) {
        Integer maxCount;
        ShowlDirectPropertyShape targetDirect = targetPropertyGroup.direct();
        PropertyConstraint constraint = targetDirect.getPropertyConstraint();
        if (constraint != null && ((maxCount = constraint.getMaxCount()) == null || maxCount > 1)) {
            ShowlArrayExpression array = new ShowlArrayExpression();
            this.addMembers(state, array, targetDirect, sourcePropertyGroup);
            targetDirect.setSelectedExpression(array);
            return true;
        }
        return false;
    }

    private void addMembers(State state, ShowlListExpression array, ShowlDirectPropertyShape targetDirect, ShowlPropertyShapeGroup sourcePropertyGroup) {
        if (targetDirect.getValueShape() != null) {
            int memberIndex = 0;
            for (ShowlPropertyShape sourceProperty : sourcePropertyGroup) {
                if (logger.isTraceEnabled()) {
                    logger.trace("addMembers: Building {}[{}]", (Object)sourcePropertyGroup.pathString(), (Object)memberIndex++);
                }
                ShowlBasicStructExpression struct = new ShowlBasicStructExpression(targetDirect);
                this.addStructProperties(state, struct, targetDirect, sourceProperty);
                array.addMember(struct);
            }
        } else {
            throw new ShowlProcessingException("Array of IRI reference or datatype value not supported yet: " + targetDirect.getPath());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void addStructProperties(State state, ShowlStructExpression struct, ShowlDirectPropertyShape targetDirect, ShowlPropertyShape sourceProperty) {
        block14: {
            SynsetProperty synSourceProp = sourceProperty.asSynsetProperty();
            SynsetNode sourceSynValue = synSourceProp.getValueNode();
            if (sourceSynValue == null) break block14;
            for (ShowlDirectPropertyShape targetField : targetDirect.getValueShape().getProperties()) {
                ShowlNodeShape targetValueNode;
                void var12_12;
                block13: {
                    SynsetProperty s;
                    URI predicate;
                    block16: {
                        String msg;
                        Set<ShowlExpression> valueSet;
                        block18: {
                            ShowlPropertyShape sourceField;
                            block17: {
                                ShowlDirectPropertyShape sourceDirectField;
                                block15: {
                                    predicate = targetField.getPredicate();
                                    s = sourceSynValue.findPropertyByPredicate(predicate);
                                    if (s == null) continue;
                                    sourceDirectField = s.direct();
                                    Object var12_13 = null;
                                    if (sourceDirectField == null) break block15;
                                    ShowlDirectPropertyShape showlDirectPropertyShape = sourceDirectField;
                                    struct.put(predicate, new ShowlDirectPropertyExpression(sourceDirectField));
                                    break block13;
                                }
                                if (s.size() != 1) break block16;
                                sourceField = (ShowlPropertyShape)s.get(0);
                                sourceDirectField = sourceField.direct();
                                valueSet = sourceField.getHasValue();
                                if (!valueSet.isEmpty()) break block17;
                                ShowlNodeShape sourceChildNode = sourceField.getValueShape();
                                ShowlNodeShape targetChildNode = targetField.getValueShape();
                                if (sourceChildNode != null && targetChildNode != null) {
                                    ShowlBasicStructExpression childStruct = new ShowlBasicStructExpression(targetField);
                                    targetField.setSelectedExpression(ShowlDelegationExpression.getInstance());
                                    struct.put(predicate, childStruct);
                                    this.addStructProperties(state, childStruct, targetField, sourceField);
                                    continue;
                                }
                                break block13;
                            }
                            if (valueSet.size() != 1) break block18;
                            ShowlExpression value = valueSet.iterator().next();
                            if (value instanceof ShowlFilterExpression) {
                                value = ((ShowlFilterExpression)value).getValue();
                                struct.put(predicate, value);
                            }
                            ShowlPropertyShape showlPropertyShape = sourceField;
                            if (value instanceof ShowlFunctionExpression) {
                                if (targetField.getValueShape() == null) {
                                    struct.put(predicate, value);
                                    break block13;
                                } else {
                                    this.fail("Function returning a struct not supported yet at {0}", sourceProperty.getPath());
                                }
                                break block13;
                            } else if (value instanceof ShowlEnumIndividualReference) {
                                if (targetField.getValueShape() != null) {
                                    ShowlNodeShape enumNode = state.enumNode(targetField.getValueShape());
                                    enumNode.setTargetProperty(targetField);
                                    ShowlEnumStructExpression enumStruct = new ShowlEnumStructExpression(targetField, enumNode);
                                    struct.put(predicate, enumStruct);
                                    this.addEnumStructProperties(enumStruct, targetField.getValueShape(), enumNode);
                                    ShowlDirectPropertyShape enumId = enumNode.getProperty(Konig.id);
                                    ShowlEnumIndividualReference enumRef = (ShowlEnumIndividualReference)value;
                                    enumStruct.put(Konig.id, enumRef);
                                    ShowlEqualStatement joinCondition = new ShowlEqualStatement(new ShowlDirectPropertyExpression(enumId), enumRef);
                                    ShowlChannel channel = new ShowlChannel(enumNode, joinCondition);
                                    targetDirect.getRootNode().addChannel(channel);
                                    continue;
                                }
                                struct.put(predicate, value);
                            }
                            break block13;
                        }
                        if (valueSet.size() > 1) {
                            msg = MessageFormat.format("Cannot handle multiple values at {}.{}", sourceProperty.getPath(), predicate.getLocalName());
                            throw new ShowlProcessingException(msg);
                        }
                        msg = MessageFormat.format("Cannot derive field at {0}.{1}", sourceProperty.getPath(), predicate.getLocalName());
                        throw new ShowlProcessingException(msg);
                    }
                    if (!s.isEmpty()) {
                        String msg = MessageFormat.format("Cannot handle multiple variants at {}.{}", sourceProperty.getPath(), predicate.getLocalName());
                        throw new ShowlProcessingException(msg);
                    }
                }
                if (var12_12 != null && targetField.getSelectedExpression() == null) {
                    targetField.setSelectedExpression(ShowlDelegationExpression.getInstance());
                }
                if ((targetValueNode = targetField.getValueShape()) == null) continue;
                if (var12_12 == null) {
                    String msg = MessageFormat.format("Target field {0} contains a nested record, but no mapping was found.", targetField.getPath());
                    throw new ShowlProcessingException(msg);
                }
                ShowlBasicStructExpression child = new ShowlBasicStructExpression(targetField);
                this.addStructProperties(state, child, targetField, (ShowlPropertyShape)var12_12);
            }
        }
    }

    private void fail(String pattern, Object ... arguments) throws ShowlProcessingException {
        String msg = MessageFormat.format(pattern, arguments);
        throw new ShowlProcessingException(msg);
    }

    private void addEnumStructProperties(ShowlStructExpression enumStruct, ShowlNodeShape targetNode, ShowlNodeShape enumNode) {
        for (ShowlDirectPropertyShape targetProperty : targetNode.getProperties()) {
            ShowlDirectPropertyShape enumProperty = enumNode.getProperty(targetProperty.getPredicate());
            if (enumProperty == null) {
                throw new ShowlProcessingException("Enum property not found for " + targetProperty.getPath());
            }
            enumStruct.put(targetProperty.getPredicate(), new ShowlEnumPropertyExpression(enumProperty));
        }
    }

    private boolean alternativePathsMapping(State state, boolean isEnum, ShowlPropertyShapeGroup sourcePropertyGroup, ShowlPropertyShapeGroup targetProperty) {
        if (this.arrayMapping(state, sourcePropertyGroup, targetProperty)) {
            return true;
        }
        return this.alternativePaths(state, sourcePropertyGroup, targetProperty);
    }

    private boolean alternativePaths(State state, ShowlPropertyShapeGroup sourcePropertyGroup, ShowlPropertyShapeGroup targetProperty) {
        ShowlDirectPropertyShape targetDirect = targetProperty.direct();
        PropertyConstraint constraint = targetDirect.getPropertyConstraint();
        if (constraint != null && constraint.getMaxCount() != null && constraint.getMaxCount() == 1 && this.containsAlternativePaths(sourcePropertyGroup)) {
            ShowlAlternativePathsExpression e = this.createAlternativePathsExpression(state, sourcePropertyGroup, targetDirect);
            targetDirect.setSelectedExpression(e);
            return true;
        }
        return false;
    }

    private ShowlAlternativePathsExpression createAlternativePathsExpression(State state, ShowlPropertyShapeGroup sourcePropertyGroup, ShowlDirectPropertyShape targetDirect) {
        ShowlAlternativePathsExpression e = new ShowlAlternativePathsExpression();
        this.addMembers(state, e, targetDirect, sourcePropertyGroup);
        return e;
    }

    private boolean containsAlternativePaths(ShowlPropertyShapeGroup sourcePropertyGroup) {
        if (sourcePropertyGroup.size() < 2) {
            return false;
        }
        int count = 0;
        for (ShowlPropertyShape p : sourcePropertyGroup) {
            if (!this.containsHasValue(p) || ++count <= 1) continue;
            return true;
        }
        return false;
    }

    private boolean containsHasValue(ShowlPropertyShape p) {
        if (!p.getHasValue().isEmpty()) {
            return true;
        }
        if (p.getValueShape() != null) {
            return this.containsHasValue(p.getValueShape());
        }
        return false;
    }

    private boolean containsHasValue(ShowlNodeShape node) {
        return this.containsHasValue(node.getProperties()) || this.listContainsHasValue(node.getDerivedProperties());
    }

    private boolean listContainsHasValue(Collection<ShowlDerivedPropertyList> derivedProperties) {
        for (ShowlDerivedPropertyList list : derivedProperties) {
            if (!this.containsHasValue(list)) continue;
            return true;
        }
        return false;
    }

    private boolean containsHasValue(Collection<? extends ShowlPropertyShape> properties) {
        for (ShowlPropertyShape showlPropertyShape : properties) {
            if (!this.containsHasValue(showlPropertyShape)) continue;
            return true;
        }
        return false;
    }

    private boolean useHasValue(ShowlPropertyShapeGroup sourcePropertyGroup, ShowlDirectPropertyShape targetDirect) {
        ShowlExpression s = null;
        int count = 0;
        for (ShowlPropertyShape sourceProperty : sourcePropertyGroup) {
            Set<ShowlExpression> valueSet = sourceProperty.getHasValue();
            if (valueSet.size() > 1) {
                return false;
            }
            if (valueSet.size() != 1) continue;
            if (++count > 1) {
                return false;
            }
            s = valueSet.iterator().next();
        }
        if (count == 1) {
            targetDirect.setSelectedExpression(s);
        }
        return count == 1;
    }

    private boolean useClassIriTemplate(ShowlPropertyShapeGroup sourcePropertyGroup, ShowlDirectPropertyShape targetProperty) {
        Value templateValue;
        ShowlClass owlClass = targetProperty.getValueType(this.schemaService);
        Graph graph = this.schemaService.getOwlReasoner().getGraph();
        Vertex v = graph.getVertex((Resource)owlClass.getId());
        if (v != null && (templateValue = v.getValue(Konig.iriTemplate)) != null) {
            IriTemplate iriTemplate = new IriTemplate(templateValue.stringValue());
            for (ShowlPropertyShape sourceProperty : sourcePropertyGroup) {
                ShowlExpression e = ShowlFunctionExpression.fromIriTemplate(this.schemaService, this.nodeService, sourceProperty, iriTemplate);
                if (!ShowlUtil.isWellDefined(e)) continue;
                targetProperty.setSelectedExpression(e);
                return true;
            }
        }
        return false;
    }

    private ShowlNodeShape nextSource(State state) {
        Set<ShowlPropertyShapeGroup> propertyPool = state.propertyPool;
        Set<ShowlNodeShape> candidateSet = state.candidateSet;
        Iterator<ShowlNodeShape> sequence = candidateSet.iterator();
        if (candidateSet.size() == 1) {
            ShowlNodeShape result = sequence.next();
            sequence.remove();
            return result;
        }
        int bestRank = 0;
        ShowlNodeShape result = null;
        while (sequence.hasNext()) {
            ShowlNodeShape candidate = sequence.next();
            ShowlEffectiveNodeShape targetNode = candidate.getTargetNode().effectiveNode();
            ShowlEffectiveNodeShape sourceNode = candidate.effectiveNode();
            int rank = this.rank(sourceNode, targetNode, propertyPool);
            if (logger.isTraceEnabled()) {
                logger.trace("nextSource: rank({})={}", (Object)sourceNode.toString(), (Object)rank);
            }
            if (rank == 0) {
                sequence.remove();
                continue;
            }
            if (rank == bestRank) {
                if (candidate.getId().stringValue().length() >= result.getId().stringValue().length()) continue;
                bestRank = rank;
                result = candidate;
                continue;
            }
            if (rank <= bestRank) continue;
            bestRank = rank;
            result = candidate;
        }
        if (result != null) {
            candidateSet.remove(result);
        }
        return result;
    }

    private int rank(ShowlEffectiveNodeShape sourceNode, ShowlEffectiveNodeShape targetNode, Set<ShowlPropertyShapeGroup> propertyPool) {
        int rank = 0;
        for (ShowlPropertyShapeGroup p : propertyPool) {
            List<ShowlPropertyShapeGroup> path;
            ShowlPropertyShapeGroup q;
            if (p.getSelectedExpression() != null || (q = sourceNode.findPropertyByPath(path = p.relativePath(targetNode))) == null || !q.isWellDefined()) continue;
            ++rank;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("rank: rank({})={}", (Object)sourceNode, (Object)rank);
        }
        return rank;
    }

    private Set<ShowlPropertyShapeGroup> propertyPool(ShowlNodeShape targetNode) {
        LinkedHashSet<ShowlPropertyShapeGroup> pool = new LinkedHashSet<ShowlPropertyShapeGroup>();
        this.addPropertiesToPool(pool, targetNode.effectiveNode());
        return pool;
    }

    private void addPropertiesToPool(Set<ShowlPropertyShapeGroup> pool, ShowlEffectiveNodeShape eNode) {
        for (ShowlPropertyShapeGroup p : eNode.getProperties()) {
            if (p.withSelectedExpression() == null && p.direct() != null) {
                pool.add(p);
                if (logger.isTraceEnabled()) {
                    logger.trace("addPropertiesToPool: added {}", (Object)p.pathString());
                }
            }
            if (p.getValueShape() == null) continue;
            this.addPropertiesToPool(pool, p.getValueShape());
        }
    }

    private void handleModifiedProperty(State state) {
        ShowlPropertyShapeGroup targetProperty = state.getTargetModified();
        if (targetProperty != null && targetProperty.getSelectedExpression() == null) {
            ShowlDirectPropertyShape sourceModified;
            ShowlDirectPropertyShape targetModified = targetProperty.direct();
            ShowlNodeShape focusNode = this.focusSourceNode(state);
            if (focusNode != null && (sourceModified = focusNode.getProperty(Konig.modified)) != null) {
                targetModified.setSelectedExpression(new ShowlDirectPropertyExpression(sourceModified));
                return;
            }
            targetModified.setSelectedExpression(ShowlSystimeExpression.INSTANCE);
        }
    }

    private ShowlNodeShape focusSourceNode(State state) {
        ShowlNodeShape result = this.focusSourceNode();
        if (result != null) {
            return result;
        }
        List<ShowlChannel> list = state.targetNode.nonEnumChannels(this.schemaService.getOwlReasoner());
        return list.isEmpty() ? null : list.get(0).getSourceNode();
    }

    protected ShowlNodeShape focusSourceNode() {
        return null;
    }

    static class State {
        ShowlNodeShape targetNode;
        Set<ShowlPropertyShapeGroup> propertyPool;
        Set<ShowlNodeShape> candidateSet;
        Set<Object> memory = new HashSet<Object>();
        Map<ShowlPropertyShape, ShowlNodeShape> enumMap;
        private ShowlPropertyShapeGroup targetModified;
        private ShowlNodeShapeService nodeService;

        public State(ShowlNodeShape targetNode, Set<ShowlPropertyShapeGroup> propertyPool, Set<ShowlNodeShape> candidateSet, ShowlNodeShapeService nodeService, Map<ShowlPropertyShape, ShowlNodeShape> enumMap) {
            this.propertyPool = propertyPool;
            this.candidateSet = candidateSet;
            this.targetNode = targetNode;
            this.nodeService = nodeService;
            this.enumMap = enumMap;
        }

        public ShowlPropertyShapeGroup getTargetModified() {
            return this.targetModified;
        }

        public void setTargetModified(ShowlPropertyShapeGroup targetModified) {
            this.targetModified = targetModified;
        }

        public boolean done() {
            return this.propertyPool.isEmpty() || this.candidateSet.isEmpty();
        }

        public ShowlNodeShape enumNode(ShowlNodeShape targetNode) {
            ShowlPropertyShape targetProperty = targetNode.getAccessor();
            ShowlNodeShape enumNode = this.enumMap.get(targetProperty);
            if (enumNode == null) {
                ShowlClass enumClass = targetProperty.getValueShape().getOwlClass();
                Shape enumShape = this.nodeService.enumNodeShape(enumClass);
                enumNode = this.nodeService.createShowlNodeShape(null, enumShape, enumClass);
                this.enumMap.put(targetProperty, enumNode);
                enumNode.setTargetNode(targetProperty.getValueShape());
                enumNode.setTargetProperty(targetProperty);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("State.enumNode({})", (Object)targetNode.getPath());
            }
            return enumNode;
        }
    }
}

