/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.Graph;
import io.konig.core.showl.ShowlMappingFilter;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.vocab.Konig;
import io.konig.datasource.DataSource;
import io.konig.shacl.Shape;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class ConsumesDataFromFilter
implements ShowlMappingFilter {
    private Graph graph;

    public ConsumesDataFromFilter(Graph graph) {
        this.graph = graph;
    }

    @Override
    public boolean allowMapping(ShowlNodeShape source, ShowlNodeShape target) {
        Shape sourceShape = source.getShape();
        Shape targetShape = target.getShape();
        if (sourceShape != null && targetShape != null) {
            for (DataSource targetChannel : targetShape.getShapeDataSource()) {
                for (URI targetSystem : targetChannel.getIsPartOf()) {
                    if (this.graph.getVertex((Resource)targetSystem) == null) continue;
                    for (DataSource sourceChannel : sourceShape.getShapeDataSource()) {
                        for (URI sourceSystem : sourceChannel.getIsPartOf()) {
                            if (!this.graph.contains((Resource)targetSystem, Konig.consumesDataFrom, (Value)sourceSystem)) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }
}

