/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.Graph;
import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlService;
import io.konig.core.showl.ShowlSourceNodeSelector;
import io.konig.core.vocab.Konig;
import io.konig.datasource.DataSource;
import io.konig.shacl.Shape;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class DataLayerSourceNodeSelector
implements ShowlSourceNodeSelector {
    @Override
    public Set<ShowlNodeShape> selectCandidateSources(ShowlService factory, ShowlNodeShape targetShape) {
        Set<URI> sourceSystemSet;
        HashSet<ShowlNodeShape> result = new HashSet<ShowlNodeShape>();
        URI targetClass = targetShape.getOwlClass().getId();
        if (!Konig.Undefined.equals((Object)targetClass) && !(sourceSystemSet = this.sourceSystemSet(factory, targetShape)).isEmpty()) {
            ShowlClass owlClass = targetShape.getOwlClass();
            for (ShowlNodeShape sourceNode : owlClass.getTargetClassOf()) {
                Shape sourceShape = sourceNode.getShape();
                if (sourceShape == targetShape.getShape()) continue;
                for (DataSource ds : sourceShape.getShapeDataSource()) {
                    if (!this.acceptableSource(ds, sourceSystemSet)) continue;
                    result.add(factory.createNodeShape(sourceShape, ds));
                }
            }
        }
        return result;
    }

    private boolean acceptableSource(DataSource ds, Set<URI> sourceSystemSet) {
        for (URI systemId : ds.getIsPartOf()) {
            if (!sourceSystemSet.contains(systemId)) continue;
            return true;
        }
        return false;
    }

    private Set<URI> sourceSystemSet(ShowlService factory, ShowlNodeShape targetShape) {
        Graph graph = factory.getGraph();
        HashSet<URI> result = new HashSet<URI>();
        ShowlNodeShape root = targetShape.getRoot();
        if (root.getShapeDataSource() != null) {
            for (URI targetSystem : root.getShapeDataSource().getDataSource().getIsPartOf()) {
                Set<URI> sourceSystemSet = graph.v((Resource)targetSystem).out(Konig.receivesDataFrom).toUriSet();
                result.addAll(sourceSystemSet);
            }
        }
        return result;
    }
}

