/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.showl.ShowlDataSource;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlService;
import io.konig.core.showl.ShowlSourceNodeSelector;
import io.konig.datasource.DataSource;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.URI;

public class DataSourceTypeSourceNodeSelector
implements ShowlSourceNodeSelector {
    private ShapeManager shapeManager;
    private URI originDataSource;

    public DataSourceTypeSourceNodeSelector(ShapeManager shapeManager, URI originDataSource) {
        this.shapeManager = shapeManager;
        this.originDataSource = originDataSource;
    }

    @Override
    public Set<ShowlNodeShape> selectCandidateSources(ShowlService factory, ShowlNodeShape targetShape) {
        HashSet<ShowlNodeShape> result = new HashSet<ShowlNodeShape>();
        for (DataSource ds : targetShape.getShape().getShapeDataSource()) {
            if (!ds.getType().contains(this.originDataSource)) continue;
            this.addSourceShape(result, factory, targetShape.getShape(), ds);
            return result;
        }
        URI owlClass = targetShape.getOwlClass().getId();
        if (owlClass != null) {
            List<Shape> candidates = this.shapeManager.getShapesByTargetClass(owlClass);
            for (Shape shape : candidates) {
                DataSource ds = shape.findDataSourceByType(this.originDataSource);
                if (ds == null) continue;
                this.addSourceShape(result, factory, shape, ds);
            }
        }
        return result;
    }

    private void addSourceShape(Set<ShowlNodeShape> result, ShowlService factory, Shape shape, DataSource ds) {
        ShowlNodeShape sourceShape = factory.createNodeShape(shape);
        sourceShape.setShapeDataSource(new ShowlDataSource(sourceShape, ds));
        result.add(sourceShape);
    }
}

