/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.showl.ShowlDataSource;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlNodeShapeBuilder;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlTargetNodeShapeFactory;
import io.konig.datasource.DataSource;
import io.konig.shacl.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class DestinationTypeTargetNodeShapeFactory
implements ShowlTargetNodeShapeFactory {
    private Set<URI> datasourceType;
    private ShowlNodeShapeBuilder builder;

    public DestinationTypeTargetNodeShapeFactory(Set<URI> datasourceType, ShowlNodeShapeBuilder builder) {
        this.datasourceType = datasourceType;
        this.builder = builder;
    }

    @Override
    public List<ShowlNodeShape> createTargetNodeShapes(Shape shape) throws ShowlProcessingException {
        ArrayList<ShowlNodeShape> result = null;
        block0: for (DataSource ds : shape.getShapeDataSource()) {
            for (URI dsType : ds.getType()) {
                if (!this.datasourceType.contains(dsType) || this.builder.isEnumClass((Resource)shape.getTargetClass())) continue;
                ShowlNodeShape targetNode = this.builder.buildNodeShape(null, shape);
                targetNode.setShapeDataSource(new ShowlDataSource(targetNode, ds));
                if (result == null) {
                    result = new ArrayList<ShowlNodeShape>();
                }
                result.add(targetNode);
                continue block0;
            }
        }
        return result == null ? Collections.emptyList() : result;
    }
}

