/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.OwlReasoner;
import io.konig.core.showl.ShowlDerivedPropertyExpression;
import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlJoinCondition;
import io.konig.core.showl.ShowlMapping;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlService;
import io.konig.core.showl.ShowlStaticPropertyShape;
import io.konig.core.vocab.Konig;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumMappingAction {
    private static final Logger logger = LoggerFactory.getLogger(EnumMappingAction.class);
    private ShowlNodeShape enumTargetShape;
    private ShowlService factory;
    private OwlReasoner reasoner;

    public EnumMappingAction(ShowlNodeShape enumTargetShape, ShowlService factory, OwlReasoner reasoner) {
        this.enumTargetShape = enumTargetShape;
        this.factory = factory;
        this.reasoner = reasoner;
        if (logger.isTraceEnabled()) {
            logger.trace("new EnumMappingAction({})", (Object)enumTargetShape.getPath());
        }
    }

    public ShowlNodeShape getEnumTargetShape() {
        return this.enumTargetShape;
    }

    public void execute() {
        List<ShowlPropertyShape> inverseFunctionals = this.listInverseFunctionals();
        if (inverseFunctionals.isEmpty()) {
            if (logger.isWarnEnabled()) {
                StringBuilder builder = new StringBuilder();
                String comma = "";
                List<ShowlDirectPropertyShape> unmapped = this.unmappedProperties();
                for (ShowlDirectPropertyShape direct : unmapped) {
                    builder.append(comma);
                    builder.append(direct.getPredicate().getLocalName());
                    comma = ", ";
                }
                logger.warn("In enumeration shape {}, no mapping found for: {} ", (Object)this.enumTargetShape.getPath(), (Object)builder.toString());
            }
        } else {
            ShowlNodeShape enumSourceShape = this.factory.logicalNodeShape(this.enumTargetShape.getOwlClass().getId());
            for (ShowlPropertyShape key : inverseFunctionals) {
                for (ShowlDirectPropertyShape direct : this.enumTargetShape.getProperties()) {
                    if (direct == key) continue;
                    ShowlStaticPropertyShape staticProperty = enumSourceShape.staticProperty(direct.getProperty());
                    ShowlDerivedPropertyExpression e = new ShowlDerivedPropertyExpression(staticProperty);
                    direct.addExpression(e);
                }
            }
        }
    }

    public void obsoleteExecute() {
        List<ShowlPropertyShape> inverseFunctionals = this.listInverseFunctionals();
        if (inverseFunctionals.isEmpty()) {
            if (logger.isWarnEnabled()) {
                StringBuilder builder = new StringBuilder();
                String comma = "";
                List<ShowlDirectPropertyShape> unmapped = this.unmappedProperties();
                for (ShowlDirectPropertyShape direct : unmapped) {
                    builder.append(comma);
                    builder.append(direct.getPredicate().getLocalName());
                    comma = ", ";
                }
                logger.warn("In enumeration shape {}, no mapping found for: {} ", (Object)this.enumTargetShape.getPath(), (Object)builder.toString());
            }
        } else {
            ShowlNodeShape enumSourceShape = this.factory.logicalNodeShape(this.enumTargetShape.getOwlClass().getId());
            for (ShowlPropertyShape key : inverseFunctionals) {
                for (ShowlJoinCondition join : key.listJoinConditions()) {
                    for (ShowlDirectPropertyShape direct : this.enumTargetShape.getProperties()) {
                        if (direct == key) continue;
                        ShowlStaticPropertyShape staticProperty = enumSourceShape.staticProperty(direct.getProperty());
                        new ShowlMapping(join, staticProperty, direct);
                    }
                }
            }
        }
    }

    private List<ShowlPropertyShape> listInverseFunctionals() {
        ArrayList<ShowlPropertyShape> list = new ArrayList<ShowlPropertyShape>();
        for (ShowlDirectPropertyShape direct : this.enumTargetShape.getProperties()) {
            URI predicate = direct.getPredicate();
            if (!direct.getMappings().isEmpty() && this.reasoner.isInverseFunctionalProperty(predicate)) {
                list.add(direct);
                continue;
            }
            ShowlPropertyShape peer = direct.getSynonym();
            if (peer == null || peer.getMappings().isEmpty() || !this.reasoner.isInverseFunctionalProperty(peer.getPredicate())) continue;
            list.add(direct);
        }
        return list;
    }

    private List<ShowlDirectPropertyShape> unmappedProperties() {
        ArrayList<ShowlDirectPropertyShape> list = new ArrayList<ShowlDirectPropertyShape>();
        for (ShowlDirectPropertyShape direct : this.enumTargetShape.getProperties()) {
            if (direct.getPredicate().equals((Object)Konig.id) || !direct.getMappings().isEmpty()) continue;
            list.add(direct);
        }
        return list;
    }
}

