/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.showl.ShowlDataSource;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlNodeShapeBuilder;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlSourceNodeFactory;
import io.konig.core.vocab.Konig;
import io.konig.datasource.DataSource;
import io.konig.shacl.Shape;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class ExplicitDerivedFromSourceNodeFactory
implements ShowlSourceNodeFactory {
    private ShowlNodeShapeBuilder nodeShapeBuilder;

    public ExplicitDerivedFromSourceNodeFactory(ShowlNodeShapeBuilder nodeShapeBuilder) {
        this.nodeShapeBuilder = nodeShapeBuilder;
    }

    @Override
    public Set<ShowlNodeShape> candidateSourceNodes(ShowlNodeShape targetNode) throws ShowlProcessingException {
        Set<Shape> explicitDerivedFrom = targetNode.getShape().getExplicitDerivedFrom();
        if (!explicitDerivedFrom.isEmpty()) {
            LinkedHashSet<ShowlNodeShape> result = new LinkedHashSet<ShowlNodeShape>();
            for (Shape sourceShape : explicitDerivedFrom) {
                DataSource ds = this.dataSource(sourceShape);
                if (ds == null) continue;
                ShowlNodeShape node = this.nodeShapeBuilder.buildNodeShape(null, sourceShape);
                node.setTargetNode(targetNode);
                node.setShapeDataSource(new ShowlDataSource(node, ds));
                result.add(node);
            }
            if (!result.isEmpty()) {
                return result;
            }
        }
        return Collections.emptySet();
    }

    private DataSource dataSource(Shape sourceShape) {
        for (DataSource ds : sourceShape.getShapeDataSource()) {
            if (ds.isA(Konig.GoogleCloudStorageFolder)) {
                return ds;
            }
            if (ds.isA(Konig.GoogleCloudStorageBucket)) {
                return ds;
            }
            if (!ds.isA(Konig.GoogleBigQueryTable)) continue;
            return ds;
        }
        return null;
    }
}

