/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.showl.ShowlChannel;
import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlNodeShapeConsumer;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.datasource.DataSource;
import io.konig.lineage.DatasourceProperty;
import io.konig.lineage.DatasourcePropertyPath;
import io.konig.lineage.PropertyGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class LineageShowlNodeShapeConsumer
implements ShowlNodeShapeConsumer {
    @Override
    public void consume(ShowlNodeShape node) throws ShowlProcessingException {
        DataSource ds;
        if (node.getRoot() == node && node.getShapeDataSource() != null && (ds = node.getShapeDataSource().getDataSource()) != null && !node.getChannels().isEmpty()) {
            this.scan(ds, node, node.getChannels());
        }
    }

    private void scan(DataSource ds, ShowlNodeShape node, List<ShowlChannel> channels) {
        for (ShowlDirectPropertyShape p : node.getProperties()) {
            HashSet<ShowlPropertyShape> set = new HashSet<ShowlPropertyShape>();
            ShowlExpression e = p.getSelectedExpression();
            if (e != null) {
                for (ShowlChannel channel : channels) {
                    ShowlNodeShape sourceNode = channel.getSourceNode();
                    e.addDeclaredProperties(sourceNode, set);
                }
            }
            DatasourceProperty q = this.produceProperty(p);
            PropertyGenerator generator = this.produceGenerator(q);
            for (ShowlPropertyShape sourceProperty : set) {
                DatasourceProperty r = this.produceProperty(sourceProperty);
                generator.addGeneratorInput(r);
                r.addGeneratorInputOf(generator);
            }
        }
    }

    private PropertyGenerator produceGenerator(DatasourceProperty q) {
        PropertyGenerator generator = q.getGeneratedFrom();
        if (generator == null) {
            generator = new PropertyGenerator();
            generator.setId(this.generatorId(q));
            generator.setGeneratorOutput(q);
            q.setGeneratedFrom(generator);
        }
        return generator;
    }

    private DatasourceProperty produceProperty(ShowlPropertyShape p) {
        DatasourcePropertyPath path;
        DataSource ds = p.getRootNode().getShapeDataSource().getDataSource();
        DatasourceProperty q = ds.findPropertyByPath(path = this.path(p));
        if (q == null) {
            q = new DatasourceProperty();
            q.setPropertyPath(path);
            q.setId(this.propertyId(ds, q.getPropertyPath()));
            q.setPropertySource(ds);
            ds.addDatasourceProperty(q);
        }
        return q;
    }

    private URI generatorId(DatasourceProperty q) {
        return new URIImpl(q.getId().stringValue() + "/generator");
    }

    private URI propertyId(DataSource ds, DatasourcePropertyPath propertyPath) {
        StringBuilder builder = new StringBuilder(ds.getId().stringValue());
        String delim = "/property/";
        for (URI predicate : propertyPath) {
            builder.append(delim);
            delim = ".";
            builder.append(predicate.getLocalName());
        }
        return new URIImpl(builder.toString());
    }

    private DatasourcePropertyPath path(ShowlPropertyShape p) {
        DatasourcePropertyPath path = new DatasourcePropertyPath();
        while (p != null) {
            path.add(p.getPredicate());
            p = p.getDeclaringShape().getAccessor();
        }
        Collections.reverse(path);
        return path;
    }
}

