/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.NamespaceManager;
import io.konig.core.io.PrettyPrintWriter;
import io.konig.core.showl.NodeNamer;
import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlJoinCondition;
import io.konig.core.showl.ShowlManager;
import io.konig.core.showl.ShowlMapping;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlNodeShapeSet;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlTemplatePropertyShape;
import io.konig.core.util.IriTemplate;
import io.konig.core.util.ValueFormat;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.openrdf.model.Resource;

public class MappingReport {
    public void write(Writer out, ShowlManager manager, NamespaceManager nsManager) {
        PrettyPrintWriter pretty = PrettyPrintWriter.of(out);
        pretty.setNamespaceManager(nsManager);
        Worker worker = new Worker(manager, pretty);
        worker.printAll();
        pretty.flush();
    }

    private static class Worker {
        private ShowlManager manager;
        private PrettyPrintWriter out;

        public Worker(ShowlManager manager, PrettyPrintWriter out) {
            this.manager = manager;
            this.out = out;
        }

        public void printAll() {
            for (Resource shapeId : this.manager.listNodeShapeIds()) {
                ShowlNodeShapeSet set = this.manager.getNodeShapeSet(shapeId);
                for (ShowlNodeShape shape : set) {
                    if (shape.getAccessor() != null) continue;
                    this.printRootShape(shape);
                    this.out.println();
                }
            }
        }

        private void printRootShape(ShowlNodeShape shape) {
            NodeNamer namer = new NodeNamer();
            this.out.indent();
            this.out.print("CONSTRUCT ");
            this.out.resource(shape.getId());
            this.out.println();
            this.printJoin(shape, namer);
            this.printProperties(shape, namer);
            this.out.println();
        }

        private void printJoin(ShowlNodeShape shape, NodeNamer namer) {
            boolean indented;
            HashSet<ShowlJoinCondition> set = new HashSet<ShowlJoinCondition>();
            for (ShowlDirectPropertyShape direct : shape.getProperties()) {
                for (ShowlMapping m : direct.getMappings()) {
                    set.add(m.getJoinCondition());
                }
            }
            ArrayList list = new ArrayList(set);
            this.out.indent();
            this.out.print("FROM");
            boolean bl = indented = list.size() > 1;
            if (indented) {
                this.out.pushIndent();
            }
            for (ShowlJoinCondition join : list) {
                if (indented) {
                    this.out.println();
                    this.out.indent();
                } else {
                    this.out.print(' ');
                }
                ShowlNodeShape other = join.otherNode(shape);
                this.out.uri(other.getShape().getIri());
                String varName = join.focusAlias(namer);
                this.out.print(" AS ");
                this.out.print(varName);
            }
            if (indented) {
                this.out.popIndent();
            }
            this.out.println();
        }

        private String joinValue(ShowlPropertyShape p, ShowlNodeShape shape, ShowlJoinCondition join, NodeNamer namer) {
            if (p.getDeclaringShape() == shape) {
                return p.getPredicate().getLocalName();
            }
            if (p instanceof ShowlTemplatePropertyShape) {
                ShowlTemplatePropertyShape t = (ShowlTemplatePropertyShape)p;
                IriTemplate template = t.getTemplate();
                StringBuilder builder = new StringBuilder();
                builder.append("CONCAT(");
                String comma = "";
                String shapeAlias = join.focusAlias(namer);
                for (ValueFormat.Element element : template.toList()) {
                    builder.append(comma);
                    comma = ", ";
                    switch (element.getType()) {
                        case TEXT: {
                            builder.append('\"');
                            builder.append(element.getText());
                            builder.append('\"');
                            break;
                        }
                        case VARIABLE: {
                            builder.append(shapeAlias);
                            builder.append('.');
                            builder.append(element.getText());
                        }
                    }
                }
                builder.append(")");
                return builder.toString();
            }
            return this.path(p, join, namer);
        }

        private void printProperties(ShowlNodeShape shape, NodeNamer namer) {
            ArrayList<ShowlDirectPropertyShape> list = new ArrayList<ShowlDirectPropertyShape>(shape.getProperties());
            if (list.isEmpty()) {
                return;
            }
            Collections.sort(list, new Comparator<ShowlDirectPropertyShape>(){

                @Override
                public int compare(ShowlDirectPropertyShape a, ShowlDirectPropertyShape b) {
                    String x = a.getPredicate().getLocalName();
                    String y = b.getPredicate().getLocalName();
                    return x.compareTo(y);
                }
            });
            this.out.indent();
            this.out.print("SET");
            this.out.pushIndent();
            String comma = "";
            for (ShowlDirectPropertyShape p : list) {
                this.out.println(comma);
                comma = ", ";
                this.printProperty(p, namer);
            }
            this.out.popIndent();
        }

        private void printProperty(ShowlDirectPropertyShape p, NodeNamer namer) {
            this.out.indent();
            this.out.print(p.getPredicate().getLocalName());
            this.printPropertyMappings(p, namer);
        }

        private void printPropertyMappings(ShowlDirectPropertyShape p, NodeNamer namer) {
            Collection<ShowlMapping> mappings = p.getMappings();
            int size = mappings.size();
            if (size == 0) {
                this.printMappingFromJoinCondition(p, namer);
                return;
            }
            if (size > 1) {
                this.out.pushIndent();
            }
            for (ShowlMapping m : mappings) {
                ShowlPropertyShape other = m.findOther(p);
                if (size == 1) {
                    this.out.print(" = ");
                } else {
                    this.out.println();
                    this.out.indent();
                    this.out.print("= ");
                }
                this.out.print(this.path(other, m.getJoinCondition(), namer));
            }
            if (size > 1) {
                this.out.popIndent();
            }
        }

        private void printMappingFromJoinCondition(ShowlDirectPropertyShape p, NodeNamer namer) {
            ShowlNodeShape node = p.getDeclaringShape();
            for (ShowlDirectPropertyShape q : node.getProperties()) {
                for (ShowlMapping m : q.getMappings()) {
                    ShowlJoinCondition join = m.getJoinCondition();
                    ShowlPropertyShape r = join.propertyOf(node);
                    if (r != p) continue;
                    ShowlPropertyShape other = join.otherProperty(r);
                    this.out.print(" = ");
                    this.out.print(this.joinValue(other, node, join, namer));
                    return;
                }
            }
            this.out.print(" = ?");
        }

        private String path(ShowlPropertyShape source, ShowlJoinCondition join, NodeNamer namer) {
            ArrayList<ShowlPropertyShape> elements = new ArrayList<ShowlPropertyShape>();
            ShowlNodeShape node = null;
            ShowlPropertyShape p = source;
            while (p != null) {
                elements.add(p);
                node = p.getDeclaringShape();
                p = node.getAccessor();
            }
            StringBuilder builder = new StringBuilder();
            String varname = join.focusAlias(namer);
            builder.append(varname);
            for (int i = elements.size() - 1; i >= 0; --i) {
                ShowlPropertyShape p2 = (ShowlPropertyShape)elements.get(i);
                builder.append(p2.pathSeparator());
                builder.append(p2.getPredicate().getLocalName());
            }
            return builder.toString();
        }
    }
}

