/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlFromCondition;
import io.konig.core.showl.ShowlJoinCondition;
import io.konig.core.showl.ShowlJoinMapping;
import io.konig.core.showl.ShowlManager;
import io.konig.core.showl.ShowlMapping;
import io.konig.core.showl.ShowlMappingFilter;
import io.konig.core.showl.ShowlMappingStrategy;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlSourceToSourceJoinCondition;
import io.konig.core.vocab.Konig;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObsoleteMappingStrategy
implements ShowlMappingStrategy {
    public static final Logger logger = LoggerFactory.getLogger(ObsoleteMappingStrategy.class);
    private ShowlMappingFilter filter;

    public ObsoleteMappingStrategy() {
    }

    public ObsoleteMappingStrategy(ShowlMappingFilter filter) {
        this.filter = filter;
    }

    @Override
    public Set<ShowlPropertyShape> selectMappings(ShowlManager manager, ShowlNodeShape target) {
        if (logger.isTraceEnabled()) {
            logger.trace("selecteMappings: target={}", (Object)target.getPath());
        }
        LinkedHashSet<ShowlJoinCondition> set = new LinkedHashSet<ShowlJoinCondition>();
        LinkedHashSet<ShowlPropertyShape> pool = new LinkedHashSet<ShowlPropertyShape>();
        this.buildPool(target, pool, set);
        LinkedHashMap<ShowlJoinCondition, RankedJoinCondition> rankingMap = new LinkedHashMap<ShowlJoinCondition, RankedJoinCondition>();
        for (ShowlJoinCondition join : set) {
            rankingMap.put(join, new RankedJoinCondition(join));
            if (!logger.isTraceEnabled()) continue;
            logger.trace("selectMappings: rankingMap put {}", (Object)join);
        }
        while (!pool.isEmpty()) {
            int originalSize = pool.size();
            this.updateRankings(rankingMap, pool);
            RankedJoinCondition best = null;
            do {
                if ((best = this.findBestJoinCondition(rankingMap.values())) == null) continue;
                if (this.addSelectedJoin(target, best)) {
                    rankingMap.remove(best.getJoin());
                    this.selectMappings(target, best.getJoin(), pool);
                    break;
                }
                best.invalidate();
                logger.trace("selectMappings: Failed to generate join condition.");
            } while (best != null);
            if (pool.size() != originalSize) continue;
            break;
        }
        return pool;
    }

    private void buildPool(ShowlNodeShape target, Set<ShowlPropertyShape> pool, Set<ShowlJoinCondition> set) {
        for (ShowlDirectPropertyShape direct : target.getProperties()) {
            pool.add(direct);
            if (logger.isTraceEnabled()) {
                logger.trace("buildPool: added {}", (Object)direct.getPath());
            }
            for (ShowlMapping m : direct.getMappings()) {
                ShowlPropertyShape other;
                ShowlNodeShape sourceNode;
                if (this.filter != null && !this.filter.allowMapping(sourceNode = (other = m.findOther(direct)).getDeclaringShape(), target)) {
                    logger.trace("selectMappings: filtering {}", (Object)sourceNode);
                    continue;
                }
                set.add(m.getJoinCondition());
            }
            ShowlNodeShape valueShape = direct.getValueShape();
            if (valueShape != null) {
                this.buildPool(valueShape, pool, set);
                continue;
            }
            ShowlPropertyShape peer = direct.getPeer();
            if (peer == null || (valueShape = peer.getValueShape()) == null) continue;
            this.buildPeerPool(valueShape, pool, set);
        }
    }

    private void buildPeerPool(ShowlNodeShape target, Set<ShowlPropertyShape> pool, Set<ShowlJoinCondition> set) {
    }

    private boolean addSelectedJoin(ShowlNodeShape targetNode, RankedJoinCondition ranked) {
        ShowlJoinCondition rankedJoin = ranked.getJoin();
        if (rankedJoin instanceof ShowlFromCondition) {
            targetNode.addSelectedJoin(rankedJoin);
            return true;
        }
        ShowlPropertyShape targetProperty = rankedJoin.propertyOf(targetNode);
        ShowlPropertyShape sourceProperty = rankedJoin.otherProperty(targetProperty);
        ShowlNodeShape sourceNode = sourceProperty.getDeclaringShape();
        if (targetNode.getSelectedJoins().isEmpty()) {
            targetNode.addSelectedJoin(new ShowlFromCondition(rankedJoin, sourceNode));
            return true;
        }
        List<ShowlJoinCondition> list = targetNode.getSelectedJoins();
        for (int i = list.size() - 1; i >= 0; --i) {
            ShowlJoinCondition prior = list.get(i);
            ShowlSourceToSourceJoinCondition s2s = this.sourceToSourceJoin(prior, sourceNode);
            if (s2s == null) continue;
            targetNode.addSelectedJoin(s2s);
            return true;
        }
        return false;
    }

    private ShowlSourceToSourceJoinCondition sourceToSourceJoin(ShowlJoinCondition prior, ShowlNodeShape b) {
        ShowlNodeShape a = prior.focusNode();
        ShowlPropertyShape aId = a.findProperty(Konig.id);
        ShowlPropertyShape bId = b.findProperty(Konig.id);
        if (aId != null && bId != null) {
            return new ShowlSourceToSourceJoinCondition(null, aId, bId);
        }
        return null;
    }

    private void selectMappings(ShowlNodeShape node, ShowlJoinCondition join, Set<ShowlPropertyShape> pool) {
        ShowlPropertyShape joinProperty = join.propertyOf(node);
        Iterator<ShowlPropertyShape> sequence = pool.iterator();
        while (sequence.hasNext()) {
            ShowlPropertyShape p = sequence.next();
            String action = "was NOT selected";
            ShowlMapping m = p.getMapping(join);
            if (m == null && p == joinProperty) {
                m = new ShowlJoinMapping(join);
            }
            if (m != null) {
                p.setSelectedMapping(m);
                sequence.remove();
                action = "was selected";
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("selectMappings: {} {}", (Object)p.getPath(), (Object)action);
        }
    }

    private RankedJoinCondition findBestJoinCondition(Collection<RankedJoinCondition> values) {
        int best = 0;
        RankedJoinCondition result = null;
        Iterator<RankedJoinCondition> sequence = values.iterator();
        while (sequence.hasNext()) {
            RankedJoinCondition r = sequence.next();
            if (r.getRanking() == 0) {
                sequence.remove();
                continue;
            }
            if (r.getRanking() <= best) continue;
            best = r.getRanking();
            result = r;
        }
        return result;
    }

    private void updateRankings(Map<ShowlJoinCondition, RankedJoinCondition> rankingMap, Set<ShowlPropertyShape> pool) {
        for (RankedJoinCondition e : rankingMap.values()) {
            e.reset();
        }
        for (ShowlPropertyShape p : pool) {
            if (logger.isTraceEnabled()) {
                logger.trace("updateRankings: updating {}", (Object)p.getPath());
            }
            for (ShowlMapping m : p.getMappings()) {
                RankedJoinCondition r = rankingMap.get(m.getJoinCondition());
                if (r != null) {
                    r.incrementRanking();
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("updateRankings: ranking({}...{})={}", new Object[]{m.getLeftProperty().getPath(), m.getRightProperty().getPath(), r.getRanking()});
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace("updateRankings: ranking({}...{})=null", (Object)m.getLeftProperty().getPath(), (Object)m.getRightProperty().getPath());
            }
        }
    }

    private void updateNestedRanking(ShowlNodeShape valueShape, RankedJoinCondition r) {
        if (logger.isTraceEnabled()) {
            logger.trace("updateNestedRanking({})", (Object)valueShape.getPath());
        }
    }

    private static class RankedJoinCondition {
        private int ranking;
        private ShowlJoinCondition join;

        public RankedJoinCondition(ShowlJoinCondition join) {
            this.join = join;
        }

        public void incrementRanking() {
            ++this.ranking;
        }

        public void reset() {
            this.ranking = 0;
        }

        public int getRanking() {
            return this.ranking;
        }

        public ShowlJoinCondition getJoin() {
            return this.join;
        }

        public void invalidate() {
            this.ranking = -1;
        }

        public String toString() {
            return "RankedJoinCondition(ranking: " + this.ranking + ", join: " + this.join.toString() + ")";
        }
    }
}

