/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.showl.BasicTransformService;
import io.konig.core.showl.OverlaySourceNodeFactory;
import io.konig.core.showl.ShowlArrayExpression;
import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlEnumPropertyExpression;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlNodeShapeService;
import io.konig.core.showl.ShowlOverlayExpression;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlPropertyShapeGroup;
import io.konig.core.showl.ShowlSchemaService;
import io.konig.core.showl.ShowlSourceNodeFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OverlayTransformService
extends BasicTransformService {
    private Set<ShowlNodeShape> candidates;
    private Map<ShowlPropertyShape, ShowlNodeShape> enumMap;

    public OverlayTransformService(ShowlSchemaService schemaService, ShowlNodeShapeService nodeService, ShowlSourceNodeFactory sourceNodeFactory, Set<ShowlNodeShape> candidates) {
        super(schemaService, nodeService, sourceNodeFactory);
        this.candidates = candidates;
    }

    @Override
    protected Map<ShowlPropertyShape, ShowlNodeShape> enumMap() {
        if (this.enumMap == null) {
            this.enumMap = new HashMap<ShowlPropertyShape, ShowlNodeShape>();
        }
        return this.enumMap;
    }

    @Override
    protected boolean acceptEnumClass(ShowlPropertyShapeGroup targetGroup) {
        ShowlNodeShape targetNode;
        ShowlDirectPropertyShape targetDirect = targetGroup.direct();
        ShowlNodeShape showlNodeShape = targetNode = targetDirect == null ? null : targetDirect.getValueShape();
        if (targetNode == null) {
            return false;
        }
        ShowlNodeShape sourceNode = this.focusSourceNode();
        ShowlPropertyShapeGroup peer = this.findPeer(sourceNode, targetNode);
        return peer != null;
    }

    @Override
    protected ShowlNodeShape focusSourceNode() {
        ShowlSourceNodeFactory sourceNodeFactory = this.getSourceNodeFactory();
        if (sourceNodeFactory instanceof OverlaySourceNodeFactory) {
            return ((OverlaySourceNodeFactory)sourceNodeFactory).getSourceNode();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ShowlPropertyShapeGroup> computeTransform(ShowlNodeShape targetNode) throws ShowlProcessingException {
        ShowlSourceNodeFactory sourceNodeFactory = this.getSourceNodeFactory();
        OverlaySourceNodeFactory overlayFactory = new OverlaySourceNodeFactory(targetNode, sourceNodeFactory);
        this.setSourceNodeFactory(overlayFactory);
        HashMap<ShowlDirectPropertyShape, ShowlExpression> expressionMap = new HashMap<ShowlDirectPropertyShape, ShowlExpression>();
        try {
            for (ShowlNodeShape sourceNode : this.candidates) {
                overlayFactory.setSourceNode(sourceNode);
                this.basicComputeTransform(targetNode);
                this.stashExpressions(targetNode, expressionMap);
            }
            this.setSelectedExpressions(targetNode, expressionMap);
            HashSet<ShowlPropertyShapeGroup> unmapped = new HashSet<ShowlPropertyShapeGroup>();
            this.collectUnmappedProperties(targetNode, unmapped);
            HashSet<ShowlPropertyShapeGroup> hashSet = unmapped;
            return hashSet;
        }
        finally {
            this.setSourceNodeFactory(sourceNodeFactory);
        }
    }

    private void collectUnmappedProperties(ShowlNodeShape targetNode, Set<ShowlPropertyShapeGroup> unmapped) {
        for (ShowlDirectPropertyShape p : targetNode.getProperties()) {
            if (p.getSelectedExpression() == null) {
                unmapped.add(p.asGroup());
            }
            if (p.getValueShape() == null) continue;
            this.collectUnmappedProperties(p.getValueShape(), unmapped);
        }
    }

    private void stashExpressions(ShowlNodeShape targetNode, Map<ShowlDirectPropertyShape, ShowlExpression> map) {
        for (ShowlDirectPropertyShape p : targetNode.getProperties()) {
            ShowlNodeShape valueShape;
            ShowlExpression e = p.getSelectedExpression();
            if (e == null) continue;
            p.setSelectedExpression(null);
            ShowlExpression prior = map.get(p);
            if (prior == null) {
                map.put(p, e);
            } else if (!(prior instanceof ShowlEnumPropertyExpression) || !(e instanceof ShowlEnumPropertyExpression)) {
                ShowlOverlayExpression overlay;
                if (prior instanceof ShowlArrayExpression && e instanceof ShowlArrayExpression) {
                    ShowlArrayExpression priorArray = (ShowlArrayExpression)prior;
                    ShowlArrayExpression newArray = (ShowlArrayExpression)e;
                    for (ShowlExpression member : newArray.getMemberList()) {
                        priorArray.addMember(member);
                    }
                } else if (prior instanceof ShowlOverlayExpression) {
                    overlay = (ShowlOverlayExpression)prior;
                    overlay.add(e);
                } else {
                    overlay = new ShowlOverlayExpression();
                    overlay.add(prior);
                    overlay.add(e);
                    map.put(p, overlay);
                }
            }
            if ((valueShape = p.getValueShape()) == null) continue;
            this.stashExpressions(valueShape, map);
        }
    }

    private void setSelectedExpressions(ShowlNodeShape targetNode, Map<ShowlDirectPropertyShape, ShowlExpression> map) {
        for (Map.Entry<ShowlDirectPropertyShape, ShowlExpression> entry : map.entrySet()) {
            ShowlDirectPropertyShape p = entry.getKey();
            ShowlExpression e = entry.getValue();
            if (e instanceof ShowlArrayExpression) {
                ShowlOverlayExpression overlay = new ShowlOverlayExpression();
                overlay.add(e);
                e = overlay;
            }
            p.setSelectedExpression(e);
        }
    }
}

