/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.OwlReasoner;
import io.konig.core.showl.ShowlChannel;
import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlDerivedPropertyExpression;
import io.konig.core.showl.ShowlDerivedPropertyShape;
import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlEffectiveNodeShape;
import io.konig.core.showl.ShowlEqualStatement;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlIriReferenceExpression;
import io.konig.core.showl.ShowlManager;
import io.konig.core.showl.ShowlMappingStrategy;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlPropertyExpression;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlPropertyShapeGroup;
import io.konig.core.showl.ShowlStatement;
import io.konig.core.showl.StaticDataSource;
import io.konig.core.vocab.Konig;
import io.konig.datasource.DataSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RankedSourceMappingStrategy
implements ShowlMappingStrategy {
    private static Logger logger = LoggerFactory.getLogger(RankedSourceMappingStrategy.class);

    @Override
    public Set<ShowlPropertyShape> selectMappings(ShowlManager manager, ShowlNodeShape targetNode) {
        Worker worker = new Worker(manager);
        return worker.selectMappings(targetNode);
    }

    private static class Worker {
        private ShowlManager manager;

        public Worker(ShowlManager manager) {
            this.manager = manager;
        }

        private Set<ShowlPropertyShape> selectMappings(ShowlNodeShape targetNode) {
            HashMap<ShowlNodeShape, NodeRanking> rankingMap = new HashMap<ShowlNodeShape, NodeRanking>();
            LinkedHashSet<ShowlPropertyShape> pool = new LinkedHashSet<ShowlPropertyShape>();
            this.init(targetNode, rankingMap, pool);
            if (logger.isTraceEnabled()) {
                logger.trace("selectMappings:  pool contains...");
                for (ShowlPropertyShape p : pool) {
                    logger.trace("   {}", (Object)p.getPath());
                }
            }
            while (!pool.isEmpty() && !rankingMap.isEmpty()) {
                int originalSize = pool.size();
                NodeRanking best = this.findBestSourceNode(rankingMap);
                if (best != null) {
                    rankingMap.remove(best.getSourceNode());
                    this.handleSourceNode(this.manager, pool, best.getSourceNode(), targetNode);
                }
                if (pool.size() == originalSize) break;
                this.updateRankings(targetNode, pool, rankingMap);
            }
            return pool;
        }

        private void handleSourceNode(ShowlManager manager, Set<ShowlPropertyShape> pool, ShowlNodeShape sourceNode, ShowlNodeShape defaultTargetNode) {
            ShowlNodeShape targetNode = sourceNode.getTargetNode();
            if (targetNode == null) {
                targetNode = defaultTargetNode;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("handleSourceNode: Map from source {} to target {}", (Object)sourceNode.getPath(), (Object)targetNode.getPath());
            }
            HashSet<ShowlPropertyShape> set = new HashSet<ShowlPropertyShape>();
            boolean addChannel = true;
            Iterator<ShowlPropertyShape> sequence = pool.iterator();
            block0: while (sequence.hasNext()) {
                ShowlPropertyShape p = sequence.next();
                if (logger.isTraceEnabled()) {
                    // empty if block
                }
                for (ShowlExpression e : p.getExpressionList()) {
                    this.expressionProperties(e, set);
                    if (!this.satisifiedBySourceNode(set, sourceNode)) continue;
                    p.setSelectedExpression(e);
                    if (addChannel) {
                        addChannel = false;
                        this.addChannel(manager, sourceNode, targetNode);
                    }
                    sequence.remove();
                    continue block0;
                }
            }
        }

        private boolean satisifiedBySourceNode(Set<ShowlPropertyShape> set, ShowlNodeShape sourceNode) {
            ShowlNodeShape root = sourceNode.getRoot();
            for (ShowlPropertyShape p : set) {
                if (p.getRootNode() == root) continue;
                return false;
            }
            return true;
        }

        private void addChannel(ShowlManager manager, ShowlNodeShape sourceNode, ShowlNodeShape targetNode) {
            ShowlNodeShape root = targetNode.getRoot();
            List<ShowlChannel> channelList = root.getChannels();
            ShowlStatement joinStatement = this.joinStatement(manager, sourceNode, targetNode, channelList);
            ShowlChannel channel = new ShowlChannel(sourceNode, joinStatement);
            if (!sourceNode.isStaticEnumShape()) {
                targetNode.addChannel(channel);
                if (root != targetNode) {
                    root.addChannel(channel);
                }
            }
            if (logger.isTraceEnabled()) {
                if (channel.getJoinStatement() == null) {
                    logger.trace("addChannel: FROM {}", (Object)sourceNode.getPath());
                } else {
                    logger.trace("addChannel: JOIN {} ON {}", (Object)sourceNode.getPath(), (Object)channel.getJoinStatement().toString());
                }
            }
            sourceNode.setJoinStatement(joinStatement);
        }

        private ShowlStatement joinStatement(ShowlManager manager, ShowlNodeShape sourceNode, ShowlNodeShape targetNode, List<ShowlChannel> channelList) {
            if (!channelList.isEmpty()) {
                for (int i = channelList.size() - 1; i >= 0; --i) {
                    ShowlPropertyShape leftProperty;
                    ShowlChannel channel = channelList.get(i);
                    ShowlNodeShape leftSourceNode = channel.getSourceNode();
                    if (sourceNode.getTargetProperty() == null && leftSourceNode.getTargetProperty() == null) {
                        ShowlPropertyShape leftId = leftSourceNode.findOut(Konig.id);
                        ShowlPropertyShape rightId = sourceNode.findOut(Konig.id);
                        if (leftId == null || rightId == null) continue;
                        ShowlPropertyExpression left = ShowlPropertyExpression.from(leftId);
                        ShowlPropertyExpression right = ShowlPropertyExpression.from(rightId);
                        ShowlEqualStatement statement = new ShowlEqualStatement(left, right);
                        if (logger.isTraceEnabled()) {
                            logger.trace("joinStatement: {}", (Object)((Object)statement).toString());
                        }
                        return statement;
                    }
                    if (!this.hasStaticDataSource(sourceNode)) continue;
                    ShowlIriReferenceExpression iriRef = this.iriRef(sourceNode);
                    if (iriRef != null) {
                        return null;
                    }
                    if (this.hasHardCodedValue(sourceNode.getTargetProperty())) {
                        return null;
                    }
                    ShowlNodeShape leftJoinNode = this.findJoinNode(leftSourceNode, sourceNode.getTargetProperty());
                    if (leftJoinNode == null || (leftProperty = this.enumSourceKey(manager.getReasoner(), leftJoinNode)) == null) continue;
                    ShowlDirectPropertyShape rightProperty = this.produceEnumProperty(sourceNode, leftProperty);
                    if (leftProperty == null) continue;
                    ShowlPropertyExpression left = ShowlPropertyExpression.from(leftProperty.maybeDirect());
                    ShowlPropertyExpression right = ShowlPropertyExpression.from(rightProperty.maybeDirect());
                    ShowlEqualStatement statement = new ShowlEqualStatement(left, right);
                    if (logger.isTraceEnabled()) {
                        logger.trace("joinStatement: {}", (Object)((Object)statement).toString());
                    }
                    return statement;
                }
                throw new ShowlProcessingException("In target node, " + targetNode.getPath() + ", failed to produce join statement for " + sourceNode.getPath());
            }
            return null;
        }

        private boolean hasHardCodedValue(ShowlPropertyShape targetProperty) {
            ShowlExpression formula = targetProperty.getFormula();
            if (formula instanceof ShowlIriReferenceExpression) {
                targetProperty.setSelectedExpression(formula);
                return true;
            }
            return false;
        }

        private ShowlIriReferenceExpression iriRef(ShowlNodeShape sourceNode) {
            ShowlPropertyShape targetProperty = sourceNode.getTargetProperty();
            if (targetProperty != null) {
                for (ShowlExpression e : targetProperty.getExpressionList()) {
                    if (!(e instanceof ShowlIriReferenceExpression)) continue;
                    return (ShowlIriReferenceExpression)e;
                }
            }
            return null;
        }

        private ShowlNodeShape findJoinNode(ShowlNodeShape sourceNode, ShowlPropertyShape targetProperty) {
            if (logger.isTraceEnabled()) {
                logger.trace("findJoinNode({}, {})", (Object)sourceNode.getPath(), (Object)targetProperty.getPath());
            }
            List<ShowlPropertyShape> path = targetProperty.propertyPath();
            if (sourceNode.getAccessor() != null || sourceNode.getTargetProperty() != null) {
                throw new RuntimeException("Nested enum not supported yet");
            }
            ShowlNodeShape result = this.traversePath(sourceNode, path);
            if (result == null) {
                ShowlPropertyShape showlPropertyShape = this.produceSourceReference(targetProperty);
            }
            return result;
        }

        private ShowlPropertyShape produceSourceReference(ShowlPropertyShape targetProperty) {
            ShowlExpression formula = targetProperty.getFormula();
            if (formula instanceof ShowlDerivedPropertyExpression) {
                ShowlDerivedPropertyShape derivedProperty = ((ShowlDerivedPropertyExpression)formula).getSourceProperty();
                ShowlEffectiveNodeShape node = targetProperty.getRootNode().effectiveNode();
                ShowlPropertyShape result = null;
                List<ShowlPropertyShape> path = derivedProperty.propertyPath();
                for (ShowlPropertyShape p : path) {
                    ShowlPropertyShapeGroup q = node.findPropertyByPredicate(p.getPredicate());
                    if (q == null) {
                        return null;
                    }
                    ShowlPropertyShape r = q.withSelectedExpression();
                    if (r == null) {
                        ShowlClass range = q.range();
                        if (range == null) {
                            logger.warn("Range of property not known {}", (Object)q.pathString());
                            return null;
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace("produceSourceReference: selecting candidate sources for {}", (Object)q.pathString());
                        }
                        for (ShowlPropertyShape qElement : q) {
                            Set<ShowlNodeShape> set;
                            if (qElement.getValueShape() == null || (set = this.manager.getShowlFactory().selectCandidateSources(qElement.getValueShape())).isEmpty()) continue;
                            Set<ShowlPropertyShape> set2 = this.selectMappings(qElement.getValueShape());
                        }
                    }
                    node = q.getValueShape();
                }
                return result;
            }
            return null;
        }

        private ShowlNodeShape traversePath(ShowlNodeShape sourceNode, List<ShowlPropertyShape> path) {
            for (ShowlPropertyShape p : path) {
                ShowlPropertyShape q = sourceNode.findOut(p.getPredicate());
                if (q == null) {
                    return null;
                }
                sourceNode = q.getValueShape();
            }
            return sourceNode;
        }

        private ShowlPropertyShape enumSourceKey(OwlReasoner reasoner, ShowlNodeShape node) {
            for (ShowlPropertyShape p : node.allOutwardProperties()) {
                if (!reasoner.isInverseFunctionalProperty(p.getPredicate())) continue;
                return p;
            }
            return null;
        }

        private ShowlDirectPropertyShape produceEnumProperty(ShowlNodeShape sourceNode, ShowlPropertyShape leftProperty) {
            URI predicate = leftProperty.getPredicate();
            ShowlDirectPropertyShape direct = sourceNode.getProperty(predicate);
            if (direct == null) {
                direct = new ShowlDirectPropertyShape(sourceNode, leftProperty.getProperty(), null);
                leftProperty.getProperty().addPropertyShape(direct);
                sourceNode.addProperty(direct);
                ShowlNodeShape globalEnum = sourceNode.getLogicalNodeShape();
                if (globalEnum != null && globalEnum != sourceNode) {
                    this.produceEnumProperty(globalEnum, leftProperty);
                }
            }
            return direct;
        }

        private void updateRankings(ShowlNodeShape targetNode, Set<ShowlPropertyShape> pool, Map<ShowlNodeShape, NodeRanking> rankingMap) {
            for (NodeRanking ranking : rankingMap.values()) {
                ranking.reset();
            }
            ShowlNodeShape targetRoot = targetNode.getRoot();
            HashSet<ShowlPropertyShape> set = new HashSet<ShowlPropertyShape>();
            for (ShowlPropertyShape p : pool) {
                for (ShowlExpression e : p.getExpressionList()) {
                    for (ShowlPropertyShape sourceProperty : this.expressionProperties(e, set)) {
                        NodeRanking ranking;
                        ShowlNodeShape sourceRoot = sourceProperty.getRootNode();
                        if (sourceRoot == targetRoot || (ranking = rankingMap.get(sourceRoot)) == null) continue;
                        ranking.increment();
                    }
                }
            }
        }

        private NodeRanking findBestSourceNode(Map<ShowlNodeShape, NodeRanking> rankingMap) {
            int best = 0;
            NodeRanking result = null;
            Iterator<NodeRanking> sequence = rankingMap.values().iterator();
            while (sequence.hasNext()) {
                NodeRanking r = sequence.next();
                if (r.getRanking() == 0) {
                    sequence.remove();
                    continue;
                }
                if (r.getRanking() <= best || this.hasStaticDataSource(r.getSourceNode())) continue;
                best = r.getRanking();
                result = r;
            }
            if (result == null) {
                for (NodeRanking r : rankingMap.values()) {
                    if (r.getRanking() <= best || !this.hasStaticDataSource(r.getSourceNode())) continue;
                    best = r.getRanking();
                    result = r;
                }
            }
            return result;
        }

        private boolean hasStaticDataSource(ShowlNodeShape sourceNode) {
            for (DataSource ds : sourceNode.getShape().getShapeDataSource()) {
                if (!(ds instanceof StaticDataSource)) continue;
                return true;
            }
            return false;
        }

        private void init(ShowlNodeShape targetNode, Map<ShowlNodeShape, NodeRanking> rankingMap, Set<ShowlPropertyShape> pool) {
            HashSet<ShowlPropertyShape> sourcePropertySet = new HashSet<ShowlPropertyShape>();
            ShowlNodeShape targetRoot = targetNode.getRoot();
            for (ShowlDirectPropertyShape p : targetNode.getProperties()) {
                if (p.getSelectedExpression() != null) continue;
                if (p.getFormula() == null) {
                    pool.add(p);
                } else {
                    p.getFormula().addProperties(pool);
                }
                for (ShowlExpression e : p.getExpressionList()) {
                    for (ShowlPropertyShape sourceProperty : this.expressionProperties(e, sourcePropertySet)) {
                        ShowlNodeShape sourceRoot = sourceProperty.getRootNode();
                        if (sourceRoot == targetRoot) continue;
                        NodeRanking ranking = rankingMap.get(sourceRoot);
                        if (ranking == null) {
                            ranking = new NodeRanking(sourceRoot);
                            rankingMap.put(sourceRoot, ranking);
                            if (logger.isTraceEnabled()) {
                                logger.trace("init: new NodeRanking({}) for {}", (Object)sourceRoot.getPath());
                            }
                        }
                        ranking.increment();
                    }
                }
                if (p.getValueShape() == null) continue;
                this.init(p.getValueShape(), rankingMap, pool);
            }
        }

        private Set<ShowlPropertyShape> expressionProperties(ShowlExpression e, Set<ShowlPropertyShape> set) {
            set.clear();
            e.addProperties(set);
            return set;
        }

        private static class NodeRanking {
            private ShowlNodeShape sourceNode;
            private int ranking;

            public NodeRanking(ShowlNodeShape sourceNode) {
                this.sourceNode = sourceNode;
            }

            public void reset() {
                this.ranking = 0;
            }

            public ShowlNodeShape getSourceNode() {
                return this.sourceNode;
            }

            public void increment() {
                ++this.ranking;
            }

            public int getRanking() {
                return this.ranking;
            }
        }
    }
}

