/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.impl.RdfUtil;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlService;
import io.konig.core.showl.ShowlSourceNodeSelector;
import io.konig.core.showl.ShowlVariablePropertyShape;
import io.konig.core.vocab.Konig;
import io.konig.datasource.DataSource;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawCubeSourceNodeSelector
implements ShowlSourceNodeSelector {
    private static Logger logger = LoggerFactory.getLogger(RawCubeSourceNodeSelector.class);
    private ShapeManager shapeManager;

    public RawCubeSourceNodeSelector(ShapeManager shapeManager) {
        this.shapeManager = shapeManager;
    }

    @Override
    public Set<ShowlNodeShape> selectCandidateSources(ShowlService factory, ShowlNodeShape targetShape) {
        PropertyConstraint variable;
        URI owlClass;
        Shape targetNode;
        ShowlPropertyShape accessor = targetShape.getAccessor();
        if (accessor instanceof ShowlVariablePropertyShape) {
            // empty if block
        }
        if ((targetNode = targetShape.getShape()).getNodeShapeCube() != null && targetNode.getVariable().size() == 1 && (owlClass = RdfUtil.uri((Value)(variable = targetNode.getVariable().get(0)).getValueClass())) != null) {
            HashSet<ShowlNodeShape> result = new HashSet<ShowlNodeShape>();
            for (Shape candidate : this.shapeManager.getShapesByTargetClass(owlClass)) {
                DataSource ds = candidate.findDataSourceByType(Konig.GoogleBigQueryTable);
                if (ds == null) continue;
                ShowlPropertyShape var = targetShape.findOut(variable.getPredicate());
                if (var == null) {
                    logger.warn("Variable ?{} not found in target node {}", (Object)variable.getPredicate().getLocalName(), (Object)targetShape.getPath());
                    continue;
                }
                ShowlNodeShape sourceNode = factory.createNodeShape(candidate, ds);
                if (var.getValueShape() == null) {
                    logger.warn("Variable ?{} does not have any nested properties in target node {}", (Object)variable.getPredicate().getLocalName(), (Object)targetShape.getPath());
                    continue;
                }
                sourceNode.setTargetNode(var.getValueShape());
                result.add(sourceNode);
            }
            return result;
        }
        return Collections.emptySet();
    }
}

