/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.Graph;
import io.konig.core.Vertex;
import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlDataSource;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlNodeShapeBuilder;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlSourceNodeFactory;
import io.konig.core.vocab.Konig;
import io.konig.datasource.DataSource;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivesDataFromSourceNodeFactory
implements ShowlSourceNodeFactory {
    private static final Logger logger = LoggerFactory.getLogger(ReceivesDataFromSourceNodeFactory.class);
    private ShowlNodeShapeBuilder nodeShapeBuilder;
    private Graph graph;

    public ReceivesDataFromSourceNodeFactory(ShowlNodeShapeBuilder nodeShapeBuilder, Graph graph) {
        this.nodeShapeBuilder = nodeShapeBuilder;
        this.graph = graph;
    }

    @Override
    public Set<ShowlNodeShape> candidateSourceNodes(ShowlNodeShape targetNode) throws ShowlProcessingException {
        HashSet<ShowlNodeShape> set = new HashSet<ShowlNodeShape>();
        ShowlDataSource dataSource = targetNode.getRoot().getShapeDataSource();
        if (dataSource != null) {
            Set<URI> sourceSystems = this.sourceSystems(dataSource.getDataSource());
            ShowlClass owlClass = targetNode.getOwlClass();
            for (ShowlNodeShape candidate : owlClass.getTargetClassOf()) {
                DataSource ds = this.candidateDataSource(candidate, sourceSystems);
                if (ds == null) continue;
                ShowlNodeShape sourceShape = this.nodeShapeBuilder.buildNodeShape(null, candidate.getShape());
                sourceShape.setTargetNode(targetNode);
                sourceShape.setShapeDataSource(new ShowlDataSource(sourceShape, ds));
                set.add(sourceShape);
                if (!logger.isTraceEnabled()) continue;
                logger.trace("candidateSourceNodes: {} is candidate source for {}", (Object)candidate.getPath(), (Object)targetNode.getPath());
            }
        } else {
            logger.warn("Cannot find candidate source nodes because the target node {} does not have a data source defined.", (Object)targetNode.getPath());
        }
        return set;
    }

    private DataSource candidateDataSource(ShowlNodeShape candidate, Set<URI> sourceSystems) {
        if (candidate.getShape() != null) {
            for (DataSource ds : candidate.getShape().getShapeDataSource()) {
                for (URI system : ds.getIsPartOf()) {
                    if (!sourceSystems.contains(system)) continue;
                    return ds;
                }
            }
        }
        return null;
    }

    private Set<URI> sourceSystems(DataSource dataSource) {
        HashSet<URI> result = new HashSet<URI>();
        for (URI systemId : dataSource.getIsPartOf()) {
            Vertex system = this.graph.getVertex((Resource)systemId);
            if (system == null) continue;
            for (Value value : system.getValueSet(Konig.receivesDataFrom)) {
                if (!(value instanceof URI)) continue;
                result.add((URI)value);
            }
        }
        return result;
    }
}

