/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.Graph;
import io.konig.core.Vertex;
import io.konig.core.showl.ShowlDataSource;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlNodeShapeBuilder;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlTargetNodeShapeFactory;
import io.konig.core.vocab.Konig;
import io.konig.datasource.DataSource;
import io.konig.shacl.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class ReceivesDataFromTargetNodeShapeFactory
implements ShowlTargetNodeShapeFactory {
    private Set<URI> targetSystems;
    private Graph graph;
    private ShowlNodeShapeBuilder builder;

    public ReceivesDataFromTargetNodeShapeFactory(Set<URI> targetSystems, Graph graph, ShowlNodeShapeBuilder builder) {
        this.targetSystems = targetSystems;
        this.graph = graph;
        this.builder = builder;
    }

    @Override
    public List<ShowlNodeShape> createTargetNodeShapes(Shape shape) throws ShowlProcessingException {
        ArrayList<ShowlNodeShape> result = null;
        block0: for (DataSource ds : shape.getShapeDataSource()) {
            for (URI dataSourceSystem : ds.getIsPartOf()) {
                Vertex v;
                if (!this.targetSystems.contains(dataSourceSystem) || (v = this.graph.getVertex((Resource)dataSourceSystem)) == null || v.getValue(Konig.receivesDataFrom) == null) continue;
                ShowlNodeShape targetNode = this.builder.buildNodeShape(null, shape);
                targetNode.setShapeDataSource(new ShowlDataSource(targetNode, ds));
                if (result == null) {
                    result = new ArrayList<ShowlNodeShape>();
                }
                result.add(targetNode);
                continue block0;
            }
        }
        return result == null ? Collections.emptyList() : result;
    }
}

