/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.OwlReasoner;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.formula.BinaryOperator;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.XMLSchema;

public class ShowlBinaryRelationalExpression
implements ShowlExpression {
    private BinaryOperator operator;
    private ShowlExpression left;
    private ShowlExpression right;

    public ShowlBinaryRelationalExpression(BinaryOperator operator, ShowlExpression left, ShowlExpression right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    public BinaryOperator getOperator() {
        return this.operator;
    }

    public ShowlExpression getLeft() {
        return this.left;
    }

    public ShowlExpression getRight() {
        return this.right;
    }

    @Override
    public String displayValue() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.left.displayValue());
        builder.append(' ');
        builder.append(this.operator.getText());
        builder.append(' ');
        builder.append(this.right.displayValue());
        return builder.toString();
    }

    public String toString() {
        return this.displayValue();
    }

    @Override
    public void addDeclaredProperties(ShowlNodeShape sourceNodeShape, Set<ShowlPropertyShape> set) throws ShowlProcessingException {
        this.left.addDeclaredProperties(sourceNodeShape, set);
        this.right.addDeclaredProperties(sourceNodeShape, set);
    }

    @Override
    public void addProperties(Set<ShowlPropertyShape> set) {
        this.left.addProperties(set);
        this.right.addProperties(set);
    }

    @Override
    public URI valueType(OwlReasoner reasoner) {
        return XMLSchema.BOOLEAN;
    }

    @Override
    public ShowlBinaryRelationalExpression transform() {
        return new ShowlBinaryRelationalExpression(this.operator, this.left.transform(), this.right.transform());
    }
}

