/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.OwlReasoner;
import io.konig.core.showl.ShowlBooleanOperator;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.XMLSchema;

public abstract class ShowlBooleanGroupingExpression
implements ShowlExpression,
ShowlStatement {
    private List<ShowlExpression> operands;

    protected ShowlBooleanGroupingExpression(List<ShowlExpression> operands) {
        this.operands = operands;
    }

    public abstract ShowlBooleanOperator getOperator();

    protected abstract ShowlBooleanGroupingExpression create(List<ShowlExpression> var1);

    @Override
    public ShowlExpression transform() {
        ArrayList<ShowlExpression> list = new ArrayList<ShowlExpression>();
        for (ShowlExpression e : this.operands) {
            list.add(e.transform());
        }
        return this.create(list);
    }

    @Override
    public String displayValue() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        String operator = null;
        for (ShowlExpression e : this.operands) {
            if (operator != null) {
                builder.append(operator);
            } else {
                operator = this.getOperator().name();
            }
            builder.append(e.displayValue());
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public void addDeclaredProperties(ShowlNodeShape sourceNodeShape, Set<ShowlPropertyShape> set) throws ShowlProcessingException {
        for (ShowlExpression e : this.operands) {
            e.addDeclaredProperties(sourceNodeShape, set);
        }
    }

    public List<ShowlExpression> getOperands() {
        return this.operands;
    }

    @Override
    public void addProperties(Set<ShowlPropertyShape> set) {
        for (ShowlExpression e : this.operands) {
            e.addProperties(set);
        }
    }

    @Override
    public URI valueType(OwlReasoner reasoner) {
        return XMLSchema.BOOLEAN;
    }
}

