/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.OwlReasoner;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlUtil;
import io.konig.core.showl.ShowlWhenThenClause;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowlCaseStatement
implements ShowlExpression {
    private static Logger logger = LoggerFactory.getLogger(ShowlCaseStatement.class);
    private ShowlExpression caseCondition;
    private List<ShowlWhenThenClause> whenThenList;
    private ShowlExpression elseClause;

    public ShowlCaseStatement(ShowlExpression caseCondition, List<ShowlWhenThenClause> whenThenList, ShowlExpression elseClause) {
        this.caseCondition = caseCondition;
        this.whenThenList = whenThenList;
        this.elseClause = elseClause;
    }

    public ShowlExpression getCaseCondition() {
        return this.caseCondition;
    }

    public List<ShowlWhenThenClause> getWhenThenList() {
        return this.whenThenList;
    }

    public ShowlExpression getElseClause() {
        return this.elseClause;
    }

    @Override
    public String displayValue() {
        StringBuilder builder = new StringBuilder();
        builder.append("CASE ");
        for (ShowlWhenThenClause whenThen : this.whenThenList) {
            builder.append(whenThen);
            builder.append(' ');
        }
        builder.append("END");
        return builder.toString();
    }

    @Override
    public void addDeclaredProperties(ShowlNodeShape sourceNodeShape, Set<ShowlPropertyShape> set) throws ShowlProcessingException {
        if (this.caseCondition != null) {
            this.caseCondition.addDeclaredProperties(sourceNodeShape, set);
        }
        for (ShowlWhenThenClause whenThen : this.whenThenList) {
            whenThen.addDeclaredProperties(sourceNodeShape, set);
        }
        if (this.elseClause != null) {
            this.elseClause.addDeclaredProperties(sourceNodeShape, set);
        }
    }

    @Override
    public void addProperties(Set<ShowlPropertyShape> set) {
        if (this.caseCondition != null) {
            this.caseCondition.addProperties(set);
        }
        for (ShowlWhenThenClause whenThen : this.whenThenList) {
            whenThen.addProperties(set);
        }
        if (this.elseClause != null) {
            this.elseClause.addProperties(set);
        }
    }

    public String toString() {
        return this.displayValue();
    }

    @Override
    public URI valueType(OwlReasoner reasoner) {
        URI result = null;
        for (ShowlWhenThenClause c : this.whenThenList) {
            URI type = c.getThen().valueType(reasoner);
            result = (URI)reasoner.leastCommonSuperClass((Resource)result, (Resource)type);
        }
        return result;
    }

    @Override
    public ShowlCaseStatement transform() {
        ShowlCaseStatement result = new ShowlCaseStatement(ShowlUtil.transform(this.caseCondition), this.transform(this.whenThenList), ShowlUtil.transform(this.elseClause));
        if (logger.isTraceEnabled()) {
            logger.trace("transform: from...\n {}", (Object)this.displayValue());
            logger.trace("transform: to...\n{}", (Object)result.displayValue());
        }
        return result;
    }

    private List<ShowlWhenThenClause> transform(List<ShowlWhenThenClause> list) {
        ArrayList<ShowlWhenThenClause> result = new ArrayList<ShowlWhenThenClause>();
        for (ShowlWhenThenClause clause : list) {
            result.add(clause.transform());
        }
        return result;
    }
}

