/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.Graph;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlProperty;
import io.konig.core.util.IriTemplate;
import io.konig.core.vocab.Konig;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class ShowlClass {
    private URI owlClassId;
    private Set<ShowlProperty> domainOf = new HashSet<ShowlProperty>();
    private Set<ShowlProperty> rangeOf = new HashSet<ShowlProperty>();
    private Set<ShowlClass> superClasses = null;
    private IriTemplate iriTemplate;
    private Set<ShowlNodeShape> targetClassOf = new HashSet<ShowlNodeShape>();
    private OwlReasoner reasoner;

    public ShowlClass(OwlReasoner reasoner, URI owlClassId) {
        this.reasoner = reasoner;
        this.owlClassId = owlClassId;
    }

    public URI getId() {
        return this.owlClassId;
    }

    public boolean isSubClassOf(ShowlClass other) {
        return this.reasoner.isSubClassOf((Resource)this.owlClassId, (Resource)other.getId());
    }

    public void addSuperClass(ShowlClass superclass) {
        if (this.superClasses == null) {
            this.superClasses = new HashSet<ShowlClass>();
        }
        this.superClasses.add(superclass);
    }

    public Set<ShowlClass> getSuperClasses() {
        return this.superClasses;
    }

    public String toString() {
        return "ShowlClass[" + this.owlClassId.getLocalName() + "]";
    }

    public Set<ShowlProperty> getRangeOf() {
        return this.rangeOf;
    }

    public void addRangeOf(ShowlProperty p) {
        this.rangeOf.add(p);
    }

    public Set<ShowlProperty> getDomainOf() {
        return this.domainOf;
    }

    public void addDomainOf(ShowlProperty p) {
        this.domainOf.add(p);
    }

    public void addTargetClassOf(ShowlNodeShape nodeShape) {
        this.targetClassOf.add(nodeShape);
    }

    public Set<ShowlNodeShape> getTargetClassOf() {
        return this.targetClassOf;
    }

    public IriTemplate getIriTemplate() {
        Value value;
        Graph graph;
        Vertex v;
        if (this.iriTemplate == null && (v = (graph = this.reasoner.getGraph()).getVertex((Resource)this.owlClassId)) != null && (value = v.getValue(Konig.iriTemplate)) != null) {
            this.iriTemplate = new IriTemplate(value.stringValue());
        }
        return this.iriTemplate;
    }

    public int hashCode() {
        return this.owlClassId.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof ShowlClass) {
            ShowlClass peer = (ShowlClass)other;
            return this.owlClassId.equals((Object)peer.getId());
        }
        return false;
    }

    public boolean isEnum(OwlReasoner owlReasoner) {
        return owlReasoner.isEnumerationClass((Resource)this.getId());
    }
}

