/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlDerivedPropertyList;
import io.konig.core.showl.ShowlDerivedPropertyShape;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlNodeShapeBuilder;
import io.konig.core.showl.ShowlNodeShapeService;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlSchemaService;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import java.util.Collection;

public class ShowlClassProcessor {
    private ShowlSchemaService schemaService;
    private ShowlNodeShapeService nodeService;

    public ShowlClassProcessor(ShowlSchemaService schemaService, ShowlNodeShapeService nodeService) {
        this.schemaService = schemaService;
        this.nodeService = nodeService;
    }

    public void buildAll(ShapeManager shapeManager) {
        ShowlNodeShapeBuilder shapeBuilder = new ShowlNodeShapeBuilder(this.schemaService, this.nodeService);
        shapeBuilder.setRecursive(false);
        for (Shape shape : shapeManager.listShapes()) {
            ShowlNodeShape nodeShape = shapeBuilder.buildNodeShape(null, shape);
            nodeShape.getOwlClass().addTargetClassOf(nodeShape);
            this.enrichProperties(nodeShape);
        }
    }

    private void enrichProperties(ShowlNodeShape nodeShape) {
        this.scanDirectProperties(nodeShape);
        this.scanDerivedProperties(nodeShape.getDerivedProperties());
    }

    private void scanDerivedProperties(Collection<ShowlDerivedPropertyList> list) {
        for (ShowlDerivedPropertyList innerList : list) {
            for (ShowlDerivedPropertyShape p : innerList) {
                if (p.getPropertyConstraint() == null) continue;
                p.getProperty().addPropertyShape(p);
            }
        }
    }

    private void scanDirectProperties(ShowlNodeShape node) {
        ShowlClass owlClass = node.getOwlClass();
        for (ShowlPropertyShape showlPropertyShape : node.getProperties()) {
            if (showlPropertyShape.getPropertyConstraint() == null) continue;
            showlPropertyShape.getProperty().addPropertyShape(showlPropertyShape);
            owlClass.addDomainOf(showlPropertyShape.getProperty());
        }
    }
}

