/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.Context;
import io.konig.core.KonigException;
import io.konig.core.showl.ShowlDerivedPropertyShape;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlPropertyExpression;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.util.IriTemplate;
import io.konig.core.util.ValueFormat;
import io.konig.formula.Formula;
import io.konig.formula.FormulaVisitor;
import io.konig.formula.IriTemplateExpression;
import io.konig.formula.QuantifiedExpression;
import io.konig.shacl.PropertyConstraint;
import java.text.MessageFormat;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class ShowlDerivedPropertyExpression
extends ShowlPropertyExpression {
    public ShowlDerivedPropertyExpression(ShowlDerivedPropertyShape sourceProperty) {
        super(sourceProperty);
    }

    @Override
    public ShowlDerivedPropertyShape getSourceProperty() {
        return (ShowlDerivedPropertyShape)super.getSourceProperty();
    }

    @Override
    public void addDeclaredProperties(ShowlNodeShape sourceNodeShape, Set<ShowlPropertyShape> set) throws ShowlProcessingException {
        ShowlDerivedPropertyShape sourceProperty = this.getSourceProperty();
        if (sourceProperty.getRootNode() == sourceNodeShape.getRoot()) {
            QuantifiedExpression formula;
            PropertyConstraint constraint = sourceProperty.getPropertyConstraint();
            QuantifiedExpression quantifiedExpression = formula = constraint == null ? null : constraint.getFormula();
            if (formula == null) {
                super.addDeclaredProperties(sourceNodeShape, set);
                return;
            }
            DeclarePropertiesVisitor visitor = new DeclarePropertiesVisitor(sourceProperty.getDeclaringShape(), set);
            try {
                formula.dispatch(visitor);
            }
            catch (Throwable oops) {
                String msg = MessageFormat.format("Failed to get declared properties from {1} with formula {2}", sourceNodeShape.getPath(), formula.toSimpleString());
                throw new ShowlProcessingException(msg, oops);
            }
        }
    }

    private static class DeclarePropertiesVisitor
    implements FormulaVisitor {
        private ShowlNodeShape declaringNode;
        private Set<ShowlPropertyShape> sink;

        public DeclarePropertiesVisitor(ShowlNodeShape declaringNode, Set<ShowlPropertyShape> sink) {
            this.declaringNode = declaringNode;
            this.sink = sink;
        }

        @Override
        public void enter(Formula formula) {
            if (formula instanceof IriTemplateExpression) {
                IriTemplate template = ((IriTemplateExpression)formula).getTemplate();
                Context context = template.getContext();
                context.compile();
                for (ValueFormat.Element element : template.toList()) {
                    if (element.getType() != ValueFormat.ElementType.VARIABLE) continue;
                    URIImpl predicate = new URIImpl(context.expandIRI(element.getText()));
                    ShowlPropertyShape p = this.declaringNode.findOut((URI)predicate);
                    if (p == null) {
                        throw new KonigException("Property not found: " + predicate.stringValue());
                    }
                    this.sink.add(p);
                }
            }
        }

        @Override
        public void exit(Formula formula) {
        }
    }
}

