/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlProperty;
import io.konig.core.showl.ShowlPropertyPath;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.vocab.Konig;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PropertyConstraint;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowlDirectPropertyShape
extends ShowlPropertyShape {
    private static Logger logger = LoggerFactory.getLogger(ShowlDirectPropertyShape.class);

    public ShowlDirectPropertyShape(ShowlNodeShape declaringShape, ShowlProperty property, PropertyConstraint propertyConstraint) {
        super(declaringShape, property, propertyConstraint);
    }

    public boolean isObjectProperty() {
        if (this.getPredicate().equals((Object)Konig.id)) {
            return true;
        }
        PropertyConstraint p = this.getPropertyConstraint();
        return p.getNodeKind().equals((Object)NodeKind.IRI) || p.getShape() != null;
    }

    void setProperty(ShowlProperty p) {
        this.property = p;
    }

    public boolean isIriReference() {
        if (this.getPredicate().equals((Object)Konig.id)) {
            return true;
        }
        PropertyConstraint p = this.getPropertyConstraint();
        return p.getNodeKind().equals((Object)NodeKind.IRI) && p.getShape() != null;
    }

    public boolean isShortcutProperty() {
        ShowlPropertyShape peer = this.getPeer();
        if (peer != null) {
            ShowlNodeShape parent = this.getDeclaringShape();
            int count = 0;
            ShowlNodeShape peerParent = peer.getDeclaringShape();
            while (peerParent.getAccessor() != null && peerParent != parent) {
                if (++count > 1) {
                    return true;
                }
                peerParent = peerParent.getAccessor().getDeclaringShape();
            }
        }
        return false;
    }

    public ShowlPropertyPath getPeerPath() {
        ShowlPropertyPath path = null;
        ShowlPropertyShape step = this.getPeer();
        if (step != null) {
            path = new ShowlPropertyPath();
            ShowlNodeShape parent = this.getDeclaringShape();
            while (step != null) {
                path.add(step);
                ShowlNodeShape stepParent = step.getDeclaringShape();
                step = stepParent == null || stepParent == parent ? null : stepParent.getAccessor();
            }
            Collections.reverse(path);
        }
        return path;
    }
}

