/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.impl.RdfUtil;
import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlPropertyShapeGroup;
import io.konig.core.showl.ShowlPropertyShapeSynSet;
import io.konig.core.showl.SynsetProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class ShowlEffectiveNodeShape
implements Comparable<ShowlEffectiveNodeShape> {
    private ShowlPropertyShapeGroup accessor;
    private Map<URI, ShowlPropertyShapeGroup> propertyMap = new HashMap<URI, ShowlPropertyShapeGroup>();
    private int ranking;

    public static ShowlEffectiveNodeShape forNode(ShowlNodeShape node) {
        ShowlEffectiveNodeShape enode = new ShowlEffectiveNodeShape();
        ShowlEffectiveNodeShape.addProperties(node, enode);
        return enode;
    }

    public static ShowlEffectiveNodeShape fromRoot(ShowlNodeShape node) {
        ShowlNodeShape root = node.getRoot();
        ShowlEffectiveNodeShape eroot = root.effectiveNode();
        if (node == root) {
            return eroot;
        }
        ShowlPropertyShapeGroup ep = eroot.findEffectiveProperty(node.getAccessor());
        return ep == null ? null : ep.getValueShape();
    }

    public boolean isAncestorOf(ShowlPropertyShapeGroup group) {
        HashSet<ShowlEffectiveNodeShape> memory = new HashSet<ShowlEffectiveNodeShape>();
        return this.isAncestor(memory, this, group);
    }

    private boolean isAncestor(Set<ShowlEffectiveNodeShape> memory, ShowlEffectiveNodeShape node, ShowlPropertyShapeGroup group) {
        ShowlEffectiveNodeShape parent = group.getDeclaringShape();
        if (parent == node) {
            return true;
        }
        if (!memory.contains(parent)) {
            memory.add(parent);
            ShowlPropertyShapeGroup accessor = node.getAccessor();
            if (accessor != null && this.isAncestor(memory, node, accessor)) {
                return true;
            }
            SynsetProperty synset = ((ShowlPropertyShape)group.get(0)).asSynsetProperty();
            URI predicate = group.getPredicate();
            for (ShowlPropertyShape p : synset) {
                ShowlPropertyShapeGroup otherGroup;
                if (predicate.equals((Object)p.getPredicate()) || !this.isAncestor(memory, node, otherGroup = p.asGroup())) continue;
                return true;
            }
        }
        return false;
    }

    public ShowlNodeShape canonicalNode() {
        ShowlDirectPropertyShape p;
        for (ShowlPropertyShapeGroup g : this.propertyMap.values()) {
            ShowlDirectPropertyShape p2 = g.direct();
            if (p2 == null) continue;
            return p2.getDeclaringShape();
        }
        if (this.accessor != null && (p = this.accessor.direct()) != null && p.getValueShape() != null) {
            return p.getValueShape();
        }
        if (this.propertyMap.isEmpty()) {
            throw new IllegalStateException();
        }
        return ((ShowlPropertyShape)this.propertyMap.values().iterator().next().iterator().next()).getDeclaringShape();
    }

    public ShowlClass getTargetClass() {
        for (ShowlPropertyShapeGroup group : this.propertyMap.values()) {
            for (ShowlPropertyShape p : group) {
                ShowlNodeShape node = p.getDeclaringShape();
                ShowlClass targetClass = node.getOwlClass();
                if (targetClass == null) continue;
                return targetClass;
            }
        }
        return null;
    }

    private ShowlPropertyShapeGroup findEffectiveProperty(ShowlPropertyShape p) {
        List<ShowlPropertyShape> list = p.propertyPath();
        ShowlPropertyShapeGroup ep = null;
        ShowlEffectiveNodeShape en = this;
        for (ShowlPropertyShape property : list) {
            if (en == null) {
                return null;
            }
            ep = en.findPropertyByPredicate(property.getPredicate());
            if (ep == null) {
                return null;
            }
            en = ep.getValueShape();
        }
        return ep;
    }

    private static void addProperties(ShowlNodeShape node, ShowlEffectiveNodeShape enode) {
        for (ShowlPropertyShape p : node.allOutwardProperties()) {
            URI predicate = p.getPredicate();
            ShowlPropertyShapeGroup ep = enode.findPropertyByPredicate(predicate);
            if (ep == null) {
                ep = new ShowlPropertyShapeGroup(enode, predicate);
                enode.addProperty(ep);
            }
            ep.add(p);
            if (p.getValueShape() == null) continue;
            ShowlEffectiveNodeShape valueShape = ep.getValueShape();
            if (valueShape == null) {
                valueShape = new ShowlEffectiveNodeShape();
                valueShape.setAccessor(ep);
                ep.setValueShape(valueShape);
            }
            ShowlEffectiveNodeShape.addProperties(p.getValueShape(), valueShape);
        }
    }

    protected ShowlEffectiveNodeShape() {
    }

    public ShowlPropertyShapeGroup getAccessor() {
        return this.accessor;
    }

    public void setAccessor(ShowlPropertyShapeGroup accessor) {
        this.accessor = accessor;
    }

    public Collection<ShowlPropertyShapeGroup> getProperties() {
        return this.propertyMap.values();
    }

    public void addProperty(ShowlPropertyShapeGroup p) {
        this.propertyMap.put(p.getPredicate(), p);
    }

    public ShowlPropertyShapeGroup findPropertyByPredicate(URI predicate) {
        return this.propertyMap.get(predicate);
    }

    public ShowlPropertyShapeSynSet findPropertyByPathWithSynonyms(List<ShowlPropertyShapeGroup> path) {
        ShowlPropertyShapeSynSet result = null;
        ArrayList<ShowlEffectiveNodeShape> nodeList = new ArrayList<ShowlEffectiveNodeShape>();
        nodeList.add(this);
        for (ShowlPropertyShapeGroup pathElement : path) {
            if (nodeList.isEmpty()) {
                return null;
            }
            result = pathElement.synonyms();
        }
        return null;
    }

    public ShowlPropertyShapeGroup findPropertyByPath(List<ShowlPropertyShapeGroup> path) {
        ShowlPropertyShapeGroup p = null;
        ShowlEffectiveNodeShape node = this;
        for (ShowlPropertyShapeGroup pathElement : path) {
            if (node == null) {
                return null;
            }
            p = node.findPropertyByPredicate(pathElement.getPredicate());
            if (p == null) {
                return null;
            }
            node = p.getValueShape();
        }
        return p;
    }

    public String toString() {
        ShowlPropertyShapeGroup p;
        ShowlNodeShape node = this.canonicalNode();
        if (node != null) {
            return node.getPath();
        }
        if (!this.propertyMap.isEmpty() && !(p = this.propertyMap.values().iterator().next()).isEmpty()) {
            return ((ShowlPropertyShape)p.get(0)).getDeclaringShape().toString();
        }
        return super.toString();
    }

    public ShowlEffectiveNodeShape getRoot() {
        return this.accessor == null ? null : this.accessor.getRootNode();
    }

    public int getRanking() {
        return this.ranking;
    }

    public void setRanking(int ranking) {
        this.ranking = ranking;
    }

    public List<ShowlPropertyShapeGroup> path() {
        if (this.accessor == null) {
            return new ArrayList<ShowlPropertyShapeGroup>();
        }
        return this.accessor.path();
    }

    public ShowlPropertyShapeGroup findPropertyByPredicatePath(List<URI> path) {
        ShowlPropertyShapeGroup p = null;
        ShowlEffectiveNodeShape node = this;
        for (URI predicate : path) {
            if (node == null) {
                return null;
            }
            p = node.findPropertyByPredicate(predicate);
            if (p == null) {
                return null;
            }
            node = p.getValueShape();
        }
        return p;
    }

    public ShowlNodeShape directNode() {
        for (ShowlPropertyShapeGroup group : this.getProperties()) {
            ShowlDirectPropertyShape direct = group.synonymDirect();
            if (direct == null) continue;
            return direct.getDeclaringShape();
        }
        return null;
    }

    @Override
    public int compareTo(ShowlEffectiveNodeShape other) {
        ShowlNodeShape thisCanonical = this.canonicalNode();
        ShowlNodeShape otherCanonical = other.canonicalNode();
        URI thisId = RdfUtil.uri((Value)thisCanonical.getId());
        URI otherId = RdfUtil.uri((Value)otherCanonical.getId());
        int result = thisId.getLocalName().compareTo(otherId.getLocalName());
        return result == 0 ? thisId.getNamespace().compareTo(otherId.getNamespace()) : result;
    }
}

