/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.showl.ShowlChannel;
import io.konig.core.showl.ShowlEnumIndividualReference;
import io.konig.core.showl.ShowlEnumNodeExpression;
import io.konig.core.showl.ShowlEqualStatement;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlUtil;
import io.konig.core.vocab.Konig;

public class ShowlEnumJoinInfo {
    private ShowlPropertyShape targetProperty;
    private ShowlPropertyShape enumProperty;
    private ShowlPropertyShape sourceProperty;
    private ShowlEnumIndividualReference hardCodedReference;
    private ShowlExpression expression;

    private ShowlEnumJoinInfo(ShowlPropertyShape targetProperty, ShowlPropertyShape enumProperty, ShowlPropertyShape sourceProperty) {
        this.targetProperty = targetProperty;
        this.enumProperty = enumProperty;
        this.sourceProperty = sourceProperty;
    }

    private ShowlEnumJoinInfo(ShowlPropertyShape targetProperty, ShowlPropertyShape enumProperty, ShowlEnumIndividualReference hardCodedReference) {
        this.targetProperty = targetProperty;
        this.enumProperty = enumProperty;
        this.hardCodedReference = hardCodedReference;
    }

    private ShowlEnumJoinInfo(ShowlPropertyShape targetProperty, ShowlPropertyShape enumProperty, ShowlExpression expression) {
        this.targetProperty = targetProperty;
        this.enumProperty = enumProperty;
        this.expression = expression;
    }

    public ShowlExpression getExpression() {
        return this.expression;
    }

    public ShowlPropertyShape getTargetProperty() {
        return this.targetProperty;
    }

    public ShowlEnumIndividualReference getHardCodedReference() {
        return this.hardCodedReference;
    }

    public ShowlPropertyShape getEnumProperty() {
        return this.enumProperty;
    }

    public ShowlPropertyShape getSourceProperty() {
        return this.sourceProperty;
    }

    public static ShowlEnumJoinInfo forEnumProperty(ShowlPropertyShape targetProperty) throws ShowlProcessingException {
        ShowlExpression e = targetProperty.getSelectedExpression();
        if (e instanceof ShowlEnumNodeExpression) {
            ShowlEnumNodeExpression enumNodeExpr = (ShowlEnumNodeExpression)targetProperty.getSelectedExpression();
            ShowlNodeShape enumNode = enumNodeExpr.getEnumNode();
            ShowlChannel channel1 = enumNodeExpr.getChannel();
            ShowlChannel channel = ShowlUtil.channelFor(enumNode, targetProperty.getRootNode().getChannels());
            if (channel1 == null || channel1 != channel) {
                System.out.print("yikes!");
            }
            if (channel != null && channel.getJoinStatement() instanceof ShowlEqualStatement) {
                ShowlEqualStatement equal = (ShowlEqualStatement)channel.getJoinStatement();
                ShowlPropertyShape enumProperty = ShowlUtil.propertyOf(equal, enumNode);
                ShowlPropertyShape sourceProperty = ShowlUtil.otherProperty(equal, enumNode);
                if (enumProperty != null) {
                    ShowlExpression other;
                    ShowlPropertyShape targetJoinProperty = ShowlUtil.propertyMappedTo(targetProperty.getValueShape(), sourceProperty);
                    if (sourceProperty != null) {
                        if (targetJoinProperty == null && enumProperty.getPredicate().equals((Object)Konig.id)) {
                            targetJoinProperty = targetProperty;
                        }
                        return new ShowlEnumJoinInfo(targetJoinProperty, enumProperty, sourceProperty);
                    }
                    if (equal.getLeft() instanceof ShowlEnumIndividualReference) {
                        return new ShowlEnumJoinInfo(targetJoinProperty, enumProperty, (ShowlEnumIndividualReference)equal.getLeft());
                    }
                    if (equal.getRight() instanceof ShowlEnumIndividualReference) {
                        return new ShowlEnumJoinInfo(targetJoinProperty, enumProperty, (ShowlEnumIndividualReference)equal.getRight());
                    }
                    ShowlExpression enumExpression = ShowlUtil.enumExpression(equal);
                    if (enumExpression != null && (other = equal.otherExpression(enumExpression)) != null) {
                        return new ShowlEnumJoinInfo(targetJoinProperty, enumProperty, other);
                    }
                }
            }
            throw new ShowlProcessingException("Failed to create ShowlEnumJoinInfo for " + targetProperty.getPath());
        }
        return null;
    }
}

