/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.OwlReasoner;
import io.konig.core.showl.HasEnumNode;
import io.konig.core.showl.ShowlChannel;
import io.konig.core.showl.ShowlEqualStatement;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlStatement;
import java.util.Set;
import org.openrdf.model.URI;

public class ShowlEnumNodeExpression
implements ShowlExpression,
HasEnumNode {
    private ShowlNodeShape enumNode;
    private ShowlChannel channel;
    private ShowlStatement joinStatement;

    public ShowlEnumNodeExpression(ShowlNodeShape enumNode) {
        this.enumNode = enumNode;
    }

    public ShowlEnumNodeExpression(ShowlNodeShape enumNode, ShowlChannel channel) {
        this.enumNode = enumNode;
        this.channel = channel;
        this.joinStatement = channel.getJoinStatement();
    }

    @Override
    public ShowlNodeShape getEnumNode() {
        return this.enumNode;
    }

    @Override
    public String displayValue() {
        return this.enumNode.toString();
    }

    @Override
    public void addDeclaredProperties(ShowlNodeShape sourceNodeShape, Set<ShowlPropertyShape> set) throws ShowlProcessingException {
        ShowlEqualStatement equal = this.equalStatement();
        if (equal != null) {
            equal.getLeft().addDeclaredProperties(sourceNodeShape, set);
            equal.getRight().addDeclaredProperties(sourceNodeShape, set);
        }
    }

    @Override
    public void addProperties(Set<ShowlPropertyShape> set) {
        ShowlEqualStatement equal = this.equalStatement();
        if (equal != null) {
            equal.getLeft().addProperties(set);
            equal.getRight().addProperties(set);
        }
    }

    private ShowlEqualStatement equalStatement() {
        ShowlStatement statement;
        if (this.channel != null && (statement = this.channel.getJoinStatement()) instanceof ShowlEqualStatement) {
            return (ShowlEqualStatement)statement;
        }
        return null;
    }

    public String toString() {
        return this.displayValue();
    }

    @Deprecated
    public ShowlChannel getChannel() {
        return this.channel;
    }

    @Deprecated
    public void setChannel(ShowlChannel channel) {
        this.channel = channel;
    }

    @Override
    public URI valueType(OwlReasoner reasoner) {
        return this.enumNode.getOwlClass().getId();
    }

    @Override
    public ShowlEnumNodeExpression transform() {
        return this;
    }

    public ShowlStatement getJoinStatement() {
        return this.joinStatement;
    }

    public void setJoinStatement(ShowlStatement joinStatement) {
        this.joinStatement = joinStatement;
    }
}

