/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.OwlReasoner;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlPropertyExpression;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlStatement;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.XMLSchema;

public class ShowlEqualStatement
implements ShowlExpression,
ShowlStatement {
    private ShowlExpression left;
    private ShowlExpression right;

    public ShowlEqualStatement(ShowlExpression left, ShowlExpression right) {
        this.left = left;
        this.right = right;
    }

    public ShowlExpression getLeft() {
        return this.left;
    }

    public ShowlExpression getRight() {
        return this.right;
    }

    public String toString() {
        return this.left.displayValue() + " = " + this.right.displayValue();
    }

    @Override
    public void addDeclaredProperties(ShowlNodeShape sourceNode, Set<ShowlPropertyShape> set) {
        this.left.addDeclaredProperties(sourceNode, set);
        this.right.addDeclaredProperties(sourceNode, set);
    }

    public ShowlExpression otherExpression(ShowlExpression e) {
        return this.left == e ? this.right : (this.right == e ? this.left : null);
    }

    @Override
    public void addProperties(Set<ShowlPropertyShape> set) {
        this.left.addProperties(set);
        this.right.addProperties(set);
    }

    public ShowlExpression expressionOf(ShowlNodeShape node) {
        ShowlExpression e = this.expressionOf(node, this.left);
        if (e != null) {
            return e;
        }
        return this.expressionOf(node, this.right);
    }

    private ShowlExpression expressionOf(ShowlNodeShape node, ShowlExpression e) {
        ShowlPropertyExpression pe;
        ShowlPropertyShape p;
        if (e instanceof ShowlPropertyExpression && node.encapsulates(p = (pe = (ShowlPropertyExpression)e).getSourceProperty())) {
            return e;
        }
        return null;
    }

    @Override
    public ShowlExpression transform() {
        return new ShowlEqualStatement(this.left.transform(), this.right.transform());
    }

    @Override
    public String displayValue() {
        return this.toString();
    }

    @Override
    public URI valueType(OwlReasoner reasoner) {
        return XMLSchema.BOOLEAN;
    }
}

