/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.Context;
import io.konig.core.OwlReasoner;
import io.konig.core.showl.ShowlDerivedPropertyShape;
import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlNodeShapeService;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlSchemaService;
import io.konig.core.showl.ShowlUtil;
import io.konig.core.showl.expression.ShowlExpressionBuilder;
import io.konig.core.util.IriTemplate;
import io.konig.core.util.ValueFormat;
import io.konig.core.vocab.SH;
import io.konig.formula.Formula;
import io.konig.formula.FormulaUtil;
import io.konig.formula.FormulaVisitor;
import io.konig.formula.FunctionExpression;
import io.konig.formula.PathTerm;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.XMLSchema;

public class ShowlFunctionExpression
implements ShowlExpression {
    private ShowlPropertyShape declaringProperty;
    private FunctionExpression function;
    private List<ShowlExpression> arguments;

    public ShowlFunctionExpression(ShowlPropertyShape declaringProperty, FunctionExpression function) {
        this(declaringProperty, function, new ArrayList<ShowlExpression>());
    }

    public ShowlFunctionExpression(ShowlPropertyShape declaringProperty, FunctionExpression function, List<ShowlExpression> arguments) {
        this.declaringProperty = declaringProperty;
        this.function = function;
        this.arguments = arguments;
    }

    public static ShowlExpression fromIriTemplate(ShowlSchemaService schemaService, ShowlNodeShapeService nodeService, ShowlPropertyShape declaringProperty, IriTemplate template) {
        ValueFormat.Element e;
        List<? extends ValueFormat.Element> list = template.toList();
        if (list.size() == 1 && (e = list.get(0)).getType() == ValueFormat.ElementType.VARIABLE) {
            Context c = template.getContext();
            URIImpl predicate = new URIImpl(c.expandIRI(e.getText()));
            ShowlPropertyShape arg = declaringProperty.getDeclaringShape().findOut((URI)predicate);
            if (arg != null) {
                arg = arg.maybeDirect();
                return ShowlUtil.propertyExpression(arg);
            }
        }
        ShowlExpressionBuilder builder = new ShowlExpressionBuilder(schemaService, nodeService);
        return builder.functionExpression(declaringProperty, FunctionExpression.fromIriTemplate(template));
    }

    public void addArgument(ShowlExpression arg) {
        this.arguments.add(arg);
    }

    @Override
    public String displayValue() {
        return this.function.toSimpleString();
    }

    @Override
    public void addDeclaredProperties(ShowlNodeShape sourceNodeShape, Set<ShowlPropertyShape> set) {
        MyFormulaVisitor visitor = new MyFormulaVisitor(sourceNodeShape, set);
        this.function.dispatch(visitor);
        for (ShowlExpression arg : this.arguments) {
            arg.addDeclaredProperties(sourceNodeShape, set);
        }
    }

    public ShowlNodeShape getDeclaringShape() {
        return this.declaringProperty.getDeclaringShape();
    }

    public ShowlPropertyShape getDeclaringProperty() {
        return this.declaringProperty;
    }

    public FunctionExpression getFunction() {
        return this.function;
    }

    public List<ShowlExpression> getArguments() {
        return this.arguments;
    }

    public String toString() {
        return FormulaUtil.simpleString(this.function);
    }

    @Override
    public void addProperties(Set<ShowlPropertyShape> set) {
        for (ShowlExpression e : this.arguments) {
            e.addProperties(set);
        }
    }

    @Override
    public URI valueType(OwlReasoner reasoner) {
        URI type = this.function.getModel().getReturnType().getRdfType();
        if (type == SH.IRI) {
            return XMLSchema.ANYURI;
        }
        return type;
    }

    @Override
    public ShowlFunctionExpression transform() {
        return new ShowlFunctionExpression(this.declaringProperty, this.function, ShowlUtil.transform(this.arguments));
    }

    static class MyFormulaVisitor
    implements FormulaVisitor {
        private ShowlNodeShape sourceNodeShape;
        private Set<ShowlPropertyShape> set;

        public MyFormulaVisitor(ShowlNodeShape sourceNodeShape, Set<ShowlPropertyShape> set) {
            this.sourceNodeShape = sourceNodeShape;
            this.set = set;
        }

        @Override
        public void enter(Formula formula) {
            if (formula instanceof PathTerm) {
                PathTerm term = (PathTerm)formula;
                URI predicate = term.getIri();
                ShowlPropertyShape p = this.sourceNodeShape.getProperty(predicate);
                if (p != null) {
                    this.set.add(p);
                } else {
                    for (ShowlDerivedPropertyShape derived : this.sourceNodeShape.getDerivedProperty(predicate)) {
                        if (!derived.getHasValueDeprecated().isEmpty()) continue;
                        p = derived.getSynonym();
                        if (p instanceof ShowlDirectPropertyShape) {
                            this.set.add(p);
                            return;
                        }
                        p = derived;
                    }
                    if (p != null) {
                        this.set.add(p);
                    }
                }
            }
        }

        @Override
        public void exit(Formula formula) {
        }
    }
}

