/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlPropertyShape;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class ShowlIriReferenceExpression
implements ShowlExpression {
    private URI iriValue;
    private ShowlPropertyShape referencedBy;

    public ShowlIriReferenceExpression(URI iriValue, ShowlPropertyShape referencedBy) {
        this.iriValue = iriValue;
        this.referencedBy = referencedBy;
    }

    public URI getIriValue() {
        return this.iriValue;
    }

    public ShowlPropertyShape getReferencedBy() {
        return this.referencedBy;
    }

    @Override
    public String displayValue() {
        return "<" + this.iriValue.stringValue() + ">";
    }

    @Override
    public void addDeclaredProperties(ShowlNodeShape sourceNodeShape, Set<ShowlPropertyShape> set) {
    }

    @Override
    public void addProperties(Set<ShowlPropertyShape> set) {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ShowlIriReferenceExpression(iriValue: <");
        builder.append(this.iriValue.stringValue());
        builder.append(">, referencedBy: ");
        builder.append(this.referencedBy.getPath());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public URI valueType(OwlReasoner reasoner) {
        URI result = null;
        Vertex v = reasoner.getGraph().getVertex((Resource)this.iriValue);
        if (v != null) {
            result = reasoner.mostSpecificTypeOf(v);
        }
        return result;
    }

    @Override
    public ShowlIriReferenceExpression transform() {
        return this;
    }
}

