/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.showl.NodeNamer;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlPropertyShape;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShowlJoinCondition {
    private static Logger logger = LoggerFactory.getLogger(ShowlJoinCondition.class);
    private ShowlPropertyShape left;
    private ShowlPropertyShape right;

    public ShowlJoinCondition(ShowlPropertyShape left, ShowlPropertyShape right) {
        this.left = left;
        this.right = right;
        if (logger.isTraceEnabled() && left != null && right != null) {
            logger.trace("new JoinCondition: {} ... {}", (Object)left.getPath(), (Object)right.getPath());
        }
        if (left != null) {
            left.addJoinCondition(this);
        }
        if (right != null) {
            right.addJoinCondition(this);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ShowlJoinCondition(");
        String comma = "";
        if (this.left != null) {
            builder.append("left: ");
            builder.append(this.left.toString());
            comma = ", ";
        }
        if (this.right != null) {
            builder.append(comma);
            builder.append("right: ");
            builder.append(this.right.toString());
        }
        builder.append(")");
        return builder.toString();
    }

    public ShowlPropertyShape getLeft() {
        return this.left;
    }

    public ShowlPropertyShape getRight() {
        return this.right;
    }

    public ShowlPropertyShape propertyOf(ShowlNodeShape node) {
        return node == this.left.getDeclaringShape() ? this.left : (node == this.right.getDeclaringShape() ? this.right : null);
    }

    public ShowlNodeShape otherNode(ShowlNodeShape n) {
        return this.left != null && n == this.left.getDeclaringShape() ? this.right.getDeclaringShape() : (this.right != null && n == this.right.getDeclaringShape() ? this.left.getDeclaringShape() : null);
    }

    public boolean isJoinProperty(ShowlPropertyShape p) {
        return p == this.left || p == this.right;
    }

    public ShowlPropertyShape otherProperty(ShowlPropertyShape p) {
        return p == this.left ? this.right : (p == this.right ? this.left : null);
    }

    public ShowlNodeShape focusNode() {
        return this.right.getDeclaringShape();
    }

    public String focusAlias(NodeNamer namer) {
        return namer.varname(this.focusNode());
    }

    public ShowlNodeShape otherNode(Set<ShowlNodeShape> set) {
        if (this.left != null && !set.contains(this.left.getDeclaringShape())) {
            return this.left.getDeclaringShape();
        }
        if (this.right != null && !set.contains(this.right.getDeclaringShape())) {
            return this.right.getDeclaringShape();
        }
        return null;
    }
}

