/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.OwlReasoner;
import io.konig.core.vocab.Konig;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.impl.BNodeImpl;

@Deprecated
public class ShowlLegacyTargetClassReasoner {
    private static int nodeCount = 0;

    public void inferTargetClasses(ShapeManager shapeManager, OwlReasoner reasoner) {
        Worker worker = new Worker(shapeManager, reasoner);
        worker.run();
    }

    static class Property {
        private URI id;
        private URI domain;
        private URI range;
        private Set<Edge> edges;

        Property() {
        }

        public Set<URI> domainIncludes(Worker worker, Set<Node> filter) {
            HashSet<URI> result = new HashSet<URI>();
            if (this.domain != null) {
                result.add(this.domain);
            } else {
                for (Edge e : this.edges) {
                    URI targetClass = worker.targetClass(e.getSubject(), filter);
                    if (targetClass == null) continue;
                    result.add(targetClass);
                }
            }
            return result;
        }
    }

    static class Edge {
        private Node subject;
        private Property predicate;
        private Node object;

        Edge() {
        }

        public Node getSubject() {
            return this.subject;
        }

        public Property getPredicate() {
            return this.predicate;
        }

        public Node getObject() {
            return this.object;
        }
    }

    static class Node {
        private Resource id;
        private URI targetClass;
        private Shape shape;
        private Set<Edge> outbound = new HashSet<Edge>();
        private Set<Edge> inbound = new HashSet<Edge>();

        public Node(Shape shape) {
            this.shape = shape;
            this.id = shape.getId();
            this.targetClass = shape.getTargetClass();
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public URI getTargetClass() {
            return this.targetClass;
        }

        public Shape getShape() {
            return this.shape;
        }

        public Set<Edge> getOutbound() {
            return this.outbound;
        }

        public Set<Edge> getInbound() {
            return this.inbound;
        }

        public void setTargetClass(URI targetClass) {
            this.targetClass = targetClass;
            if (this.shape != null) {
                this.shape.setTargetClass(targetClass);
            }
        }
    }

    private static class Worker {
        private ShapeManager shapeManager;
        private OwlReasoner reasoner;
        private Set<Node> classlessNodes = new HashSet<Node>();
        private Map<Resource, Node> nodeMap = new HashMap<Resource, Node>();

        public Worker(ShapeManager shapeManager, OwlReasoner reasoner) {
            this.shapeManager = shapeManager;
            this.reasoner = reasoner;
        }

        public void run() {
            this.buildGraph();
        }

        private void buildGraph() {
            for (Shape shape : this.shapeManager.listShapes()) {
                Node node = this.node(shape);
                this.buildEdges(node);
            }
        }

        private void buildEdges(Node node) {
        }

        private BNode createBNode() {
            String id = "stcr" + ++nodeCount;
            return new BNodeImpl(id);
        }

        private Node node(Shape shape) {
            Node node;
            Resource shapeId = shape.getId();
            if (shapeId == null) {
                shapeId = this.createBNode();
                shape.setId(shapeId);
            }
            if ((node = this.nodeMap.get(shapeId)) == null) {
                node = new Node(shape);
                this.nodeMap.put(shapeId, node);
            }
            return node;
        }

        private URI targetClass(Node node, Set<Node> filter) {
            URI targetClass = node.getTargetClass();
            if (targetClass == null) {
                targetClass = this.inferTargetClass(node, filter);
            }
            return targetClass;
        }

        private URI inferTargetClass(Node node, Set<Node> filter) {
            if (filter.contains(node)) {
                return null;
            }
            filter.add(node);
            HashSet<URI> candidates = new HashSet<URI>();
            for (Edge edge : node.getOutbound()) {
                Set<URI> domainIncludes = edge.getPredicate().domainIncludes(this, filter);
                block1: for (URI domain : domainIncludes) {
                    for (URI candidate : candidates) {
                        if (!this.reasoner.isSubClassOf((Resource)candidate, (Resource)domain)) continue;
                        continue block1;
                    }
                    candidates.add(domain);
                }
            }
            URI result = null;
            if (candidates.size() == 1) {
                result = (URI)candidates.iterator().next();
                node.setTargetClass(result);
            }
            return result;
        }

        private URI targetClass(Shape shape) {
            URI targetClass = shape.getTargetClass();
            if (targetClass == null) {
                targetClass = Konig.Undefined;
            }
            return targetClass;
        }
    }
}

