/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.OwlReasoner;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlPropertyShape;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openrdf.model.URI;

public abstract class ShowlListExpression
implements ShowlExpression {
    List<ShowlExpression> memberList;

    public ShowlListExpression() {
        this(new ArrayList<ShowlExpression>());
    }

    public ShowlListExpression(List<ShowlExpression> memberList) {
        this.memberList = memberList;
    }

    public void addMember(ShowlExpression member) {
        this.memberList.add(member);
    }

    @Override
    public String displayValue() {
        StringBuilder builder = new StringBuilder();
        builder.append("Array[");
        String comma = "";
        for (ShowlExpression e : this.memberList) {
            builder.append(comma);
            comma = ", ";
            builder.append(e.displayValue());
        }
        builder.append(']');
        return builder.toString();
    }

    public String toString() {
        return this.displayValue();
    }

    @Override
    public void addDeclaredProperties(ShowlNodeShape sourceNodeShape, Set<ShowlPropertyShape> set) throws ShowlProcessingException {
        for (ShowlExpression e : this.memberList) {
            e.addDeclaredProperties(sourceNodeShape, set);
        }
    }

    public List<ShowlExpression> getMemberList() {
        return this.memberList;
    }

    @Override
    public void addProperties(Set<ShowlPropertyShape> set) {
        for (ShowlExpression e : this.memberList) {
            e.addProperties(set);
        }
    }

    @Override
    public URI valueType(OwlReasoner reasoner) {
        return this.memberList.get(0).valueType(reasoner);
    }
}

