/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.OwlReasoner;
import io.konig.core.showl.ShowlContainmentOperator;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlUtil;
import java.util.List;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.XMLSchema;

public class ShowlListRelationalExpression
implements ShowlExpression {
    private ShowlPropertyShape referencedBy;
    private ShowlExpression left;
    private ShowlContainmentOperator operator;
    private List<ShowlExpression> right;

    public ShowlListRelationalExpression(ShowlPropertyShape referencedBy, ShowlExpression left, ShowlContainmentOperator operator, List<ShowlExpression> right) {
        this.referencedBy = referencedBy;
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    public ShowlContainmentOperator getOperator() {
        return this.operator;
    }

    public ShowlPropertyShape getReferencedBy() {
        return this.referencedBy;
    }

    public ShowlExpression getLeft() {
        return this.left;
    }

    public List<ShowlExpression> getRight() {
        return this.right;
    }

    @Override
    public String displayValue() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.left.displayValue());
        builder.append(" IN ( ");
        String comma = "";
        for (ShowlExpression e : this.right) {
            builder.append(comma);
            comma = " , ";
            builder.append(e.displayValue());
        }
        builder.append(" )");
        return builder.toString();
    }

    public String toString() {
        return this.displayValue();
    }

    @Override
    public void addDeclaredProperties(ShowlNodeShape sourceNodeShape, Set<ShowlPropertyShape> set) throws ShowlProcessingException {
        this.left.addDeclaredProperties(sourceNodeShape, set);
        for (ShowlExpression e : this.right) {
            e.addDeclaredProperties(sourceNodeShape, set);
        }
    }

    @Override
    public void addProperties(Set<ShowlPropertyShape> set) {
        this.left.addProperties(set);
        for (ShowlExpression e : this.right) {
            e.addProperties(set);
        }
    }

    @Override
    public URI valueType(OwlReasoner reasoner) {
        return XMLSchema.BOOLEAN;
    }

    @Override
    public ShowlListRelationalExpression transform() {
        return new ShowlListRelationalExpression(this.referencedBy, this.left.transform(), this.operator, ShowlUtil.transform(this.right));
    }
}

