/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.Context;
import io.konig.core.Graph;
import io.konig.core.NamespaceManager;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.core.impl.BasicContext;
import io.konig.core.impl.RdfUtil;
import io.konig.core.showl.EnumMappingAction;
import io.konig.core.showl.RankedSourceMappingStrategy;
import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlClassManager;
import io.konig.core.showl.ShowlDataSource;
import io.konig.core.showl.ShowlDerivedPropertyExpression;
import io.konig.core.showl.ShowlDerivedPropertyList;
import io.konig.core.showl.ShowlDerivedPropertyShape;
import io.konig.core.showl.ShowlDirectPropertyExpression;
import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlEnumPropertyExpression;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlFormulaPropertyShape;
import io.konig.core.showl.ShowlFromCondition;
import io.konig.core.showl.ShowlFunctionExpression;
import io.konig.core.showl.ShowlIdRefPropertyShape;
import io.konig.core.showl.ShowlInwardPropertyShape;
import io.konig.core.showl.ShowlJoinCondition;
import io.konig.core.showl.ShowlJoinMapping;
import io.konig.core.showl.ShowlMapping;
import io.konig.core.showl.ShowlMappingStrategy;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlNodeShapeConsumer;
import io.konig.core.showl.ShowlNodeShapeSet;
import io.konig.core.showl.ShowlOutwardPropertyShape;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlProperty;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlRootTargetClassSelector;
import io.konig.core.showl.ShowlService;
import io.konig.core.showl.ShowlSourceNodeSelector;
import io.konig.core.showl.ShowlTargetNodeSelector;
import io.konig.core.showl.ShowlTargetToSourceJoinCondition;
import io.konig.core.showl.ShowlTemplatePropertyShape;
import io.konig.core.showl.ShowlUtil;
import io.konig.core.showl.ShowlVariablePropertyShape;
import io.konig.core.showl.StaticDataSource;
import io.konig.core.showl.expression.ShowlExpressionBuilder;
import io.konig.core.util.IriTemplate;
import io.konig.core.util.ValueFormat;
import io.konig.core.vocab.Konig;
import io.konig.datasource.DataSource;
import io.konig.formula.Direction;
import io.konig.formula.DirectionStep;
import io.konig.formula.Expression;
import io.konig.formula.Formula;
import io.konig.formula.FormulaVisitor;
import io.konig.formula.HasPathStep;
import io.konig.formula.IriValue;
import io.konig.formula.LiteralFormula;
import io.konig.formula.PathExpression;
import io.konig.formula.PathStep;
import io.konig.formula.PathTerm;
import io.konig.formula.PredicateObjectList;
import io.konig.formula.PrimaryExpression;
import io.konig.formula.QuantifiedExpression;
import io.konig.formula.VariableTerm;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.OWL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowlManager
implements ShowlClassManager {
    private static final Logger logger = LoggerFactory.getLogger(ShowlManager.class);
    private Map<Resource, ShowlNodeShapeSet> nodeShapes = new LinkedHashMap<Resource, ShowlNodeShapeSet>();
    private Map<URI, ShowlClass> owlClasses = new LinkedHashMap<URI, ShowlClass>();
    private Map<URI, ShowlProperty> properties = new LinkedHashMap<URI, ShowlProperty>();
    private ShowlNodeShapeSet emptySet = null;
    private OwlReasoner reasoner;
    private ShowlNodeShapeConsumer consumer;
    private ShapeManager shapeManager;
    private List<ShowlNodeShape> classlessShapes;
    private Set<NodeMapping> nodeMappings = null;
    private ShowlTargetNodeSelector targetNodeSelector;
    private ShowlSourceNodeSelector sourceNodeSelector;
    private Map<Resource, EnumMappingAction> enumMappingActions;
    private ShowlService showlFactory;
    private ShowlMappingStrategy mappingStrategy;
    private StaticDataSource staticDataSource = null;
    private Set<ShowlNodeShape> consumable;

    public ShowlManager(ShapeManager shapeManager, OwlReasoner reasoner) {
        this(shapeManager, reasoner, new ShowlRootTargetClassSelector(), null);
    }

    public ShowlManager(ShapeManager shapeManager, OwlReasoner reasoner, ShowlSourceNodeSelector sourceNodeSelector, ShowlNodeShapeConsumer consumer) {
        this.shapeManager = shapeManager;
        this.reasoner = reasoner;
        this.sourceNodeSelector = sourceNodeSelector;
        this.consumer = consumer;
        this.showlFactory = new Factory();
    }

    public ShowlManager(ShapeManager shapeManager, OwlReasoner reasoner, ShowlTargetNodeSelector targetNodeSelector, ShowlSourceNodeSelector sourceNodeSelector, ShowlNodeShapeConsumer consumer) {
        this.shapeManager = shapeManager;
        this.reasoner = reasoner;
        this.targetNodeSelector = targetNodeSelector;
        this.sourceNodeSelector = sourceNodeSelector;
        this.mappingStrategy = new RankedSourceMappingStrategy();
        this.consumer = consumer;
        this.showlFactory = new Factory();
    }

    public ShapeManager getShapeManager() {
        return this.shapeManager;
    }

    public ShowlService getShowlFactory() {
        return this.showlFactory;
    }

    public void load() throws ShowlProcessingException {
        this.clear();
        this.loadShapes();
        this.inferTargetClasses();
        this.inferInverses();
        this.buildJoinConditions();
    }

    public ShowlTargetNodeSelector getTargetNodeSelector() {
        return this.targetNodeSelector;
    }

    public void setTargetNodeSelector(ShowlTargetNodeSelector targetNodeSelector) {
        this.targetNodeSelector = targetNodeSelector;
    }

    public ShowlSourceNodeSelector getSourceNodeSelector() {
        return this.sourceNodeSelector;
    }

    public void setSourceNodeSelector(ShowlSourceNodeSelector sourceNodeSelector) {
        this.sourceNodeSelector = sourceNodeSelector;
    }

    public Set<Resource> listNodeShapeIds() {
        return this.nodeShapes.keySet();
    }

    public ShowlNodeShape getNodeShape(Resource shapeId) {
        return this.nodeShapes.get(shapeId).top();
    }

    public ShowlNodeShapeSet getNodeShapeSet(Resource shapeId) {
        ShowlNodeShapeSet set = this.nodeShapes.get(shapeId);
        return set == null ? this.emptySet() : set;
    }

    public ShowlProperty getProperty(URI propertyId) {
        return this.properties.get(propertyId);
    }

    public Collection<ShowlProperty> getProperties() {
        return this.properties.values();
    }

    private ShowlNodeShapeSet emptySet() {
        if (this.emptySet == null) {
            this.emptySet = new ShowlNodeShapeSet();
        }
        return this.emptySet;
    }

    @Override
    public OwlReasoner getReasoner() {
        return this.reasoner;
    }

    public void clear() {
        this.nodeMappings = null;
        this.classlessShapes = null;
    }

    protected void inferInverses() {
        ArrayList<ShowlProperty> list = new ArrayList<ShowlProperty>(this.getProperties());
        for (ShowlProperty p : list) {
            if (!p.getInverses().isEmpty()) continue;
            this.inferInverse(p);
        }
    }

    private void inferInverse(ShowlProperty p) {
        URI predicate = p.getPredicate();
        Set<URI> set = this.reasoner.inverseOf(predicate);
        for (URI other : set) {
            p.addInverse(this.produceShowlProperty(other));
        }
        for (ShowlPropertyShape q : p.getPropertyShapes()) {
            ShowlPropertyShape peer = q.getPeer();
            if (peer == null || peer.getDirection() == q.getDirection()) continue;
            p.addInverse(peer.getProperty());
        }
    }

    private void buildJoinConditions() throws ShowlProcessingException {
        this.nodeMappings = new LinkedHashSet<NodeMapping>();
        this.enumMappingActions = new HashMap<Resource, EnumMappingAction>();
        this.consumable = null;
        this.buildTransformExpressions();
        if (this.consumable != null) {
            for (ShowlNodeShape node : this.consumable) {
                this.consumer.consume(node);
            }
        }
        this.consumable = null;
        this.nodeMappings = null;
        this.enumMappingActions = null;
    }

    private void buildTransformExpressions() {
        for (Shape shape : this.shapeManager.listShapes()) {
            List<ShowlNodeShape> targetList = this.targetNodeSelector.produceTargetNodes(this.showlFactory, shape);
            for (ShowlNodeShape targetNode : targetList) {
                this.buildTransform(targetNode);
                if (this.mappingStrategy == null) continue;
                Set<ShowlPropertyShape> unmapped = this.mappingStrategy.selectMappings(this, targetNode);
                if (unmapped.isEmpty()) {
                    if (this.consumer == null) continue;
                    this.consumer.consume(targetNode);
                    continue;
                }
                logger.warn("Failed to map the following properties:...");
                for (ShowlPropertyShape p : unmapped) {
                    logger.warn("    {}", (Object)p.getPath());
                }
            }
        }
    }

    private void buildTransform(ShowlNodeShape targetNode) {
        Set<ShowlNodeShape> candidates = this.selectCandidateSources(targetNode);
        this.addSourcesForVariables(candidates, targetNode);
        if (candidates.isEmpty() && logger.isWarnEnabled()) {
            logger.warn("buildTransform:  Cannot build transform for {}.  No candidate sources were found.", (Object)targetNode.getPath());
        }
        this.buildTransforms(targetNode, candidates);
    }

    private Set<ShowlNodeShape> selectCandidateSources(ShowlNodeShape targetNode) {
        Set<ShowlNodeShape> set = this.sourceNodeSelector.selectCandidateSources(this.showlFactory, targetNode);
        for (ShowlNodeShape sourceNode : set) {
            if (sourceNode.getTargetNode() != null) continue;
            sourceNode.setTargetNode(targetNode);
        }
        return set;
    }

    private void addSourcesForVariables(Set<ShowlNodeShape> candidates, ShowlNodeShape targetNode) {
        for (PropertyConstraint c : targetNode.getShape().getVariable()) {
            URI predicate = c.getPredicate();
            ShowlPropertyShape p = targetNode.findOut(predicate);
            if (p == null || p.getValueShape() == null) continue;
            Set<ShowlNodeShape> set = this.selectCandidateSources(p.getValueShape());
            candidates.addAll(set);
        }
    }

    private void buildTransforms(ShowlNodeShape defaultTargetNode, Collection<ShowlNodeShape> candidates) {
        for (ShowlNodeShape sourceNode : candidates) {
            ShowlNodeShape targetNode = sourceNode.getTargetNode();
            if (targetNode == null) {
                targetNode = defaultTargetNode;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("buildTransforms: From source {} to target {}", (Object)sourceNode.getPath(), (Object)targetNode.getPath());
            }
            for (ShowlDirectPropertyShape targetProperty : targetNode.getProperties()) {
                ShowlExpression formula = targetProperty.getFormula();
                if (formula == null) {
                    this.matchProperty(sourceNode, targetProperty);
                    continue;
                }
                LinkedHashSet<ShowlPropertyShape> set = new LinkedHashSet<ShowlPropertyShape>();
                formula.addProperties(set);
                for (ShowlPropertyShape arg : set) {
                    this.matchProperty(sourceNode, arg);
                }
            }
        }
        for (ShowlDirectPropertyShape direct : defaultTargetNode.getProperties()) {
            ShowlClass owlClass;
            ShowlNodeShape valueShape = direct.getValueShape();
            if (valueShape == null || (owlClass = valueShape.getOwlClass()) == null || !this.reasoner.isEnumerationClass((Resource)owlClass.getId())) continue;
            this.addEnumMappings(valueShape);
        }
    }

    private void addEnumMappings(ShowlNodeShape targetShape) {
        ShowlNodeShape globalEnumShape = this.showlFactory.logicalNodeShape(targetShape.getOwlClass().getId());
        ShowlNodeShape localEnumShape = this.localEnumShape(globalEnumShape, targetShape);
        localEnumShape.setLogicalNodeShape(globalEnumShape);
        for (ShowlDirectPropertyShape direct : targetShape.getProperties()) {
            this.directProperty(globalEnumShape, direct.getProperty());
            ShowlDirectPropertyShape localEnumProperty = this.directProperty(localEnumShape, direct.getProperty());
            direct.addExpression(new ShowlEnumPropertyExpression(localEnumProperty));
            if (!logger.isTraceEnabled()) continue;
            logger.trace("addEnumMapping: {}...{}", (Object)localEnumProperty.getPath(), (Object)direct.getPath());
        }
    }

    private ShowlNodeShape localEnumShape(ShowlNodeShape globalEnumShape, ShowlNodeShape targetShape) {
        ShowlNodeShape local = new ShowlNodeShape(this, null, globalEnumShape.getShape(), globalEnumShape.getOwlClass());
        globalEnumShape.getOwlClass().addTargetClassOf(local);
        local.setTargetProperty(targetShape.getAccessor());
        local.setShapeDataSource(new ShowlDataSource(local, this.staticDataSource()));
        return local;
    }

    private DataSource staticDataSource() {
        if (this.staticDataSource == null) {
            this.staticDataSource = new StaticDataSource();
        }
        return this.staticDataSource;
    }

    private ShowlDirectPropertyShape directProperty(ShowlNodeShape enumShape, ShowlProperty property) {
        URI predicate = property.getPredicate();
        ShowlDirectPropertyShape direct = enumShape.getProperty(predicate);
        if (direct == null) {
            direct = this.createDirectPropertyShape(enumShape, property, null);
            enumShape.addProperty(direct);
        }
        return direct;
    }

    private boolean matchProperty(ShowlNodeShape sourceNode, ShowlPropertyShape targetProperty) {
        if (targetProperty == null) {
            return false;
        }
        URI targetPredicate = targetProperty.getPredicate();
        ShowlPropertyShape sourceProperty = sourceNode.getProperty(targetPredicate);
        if (this.match(sourceProperty, targetProperty)) {
            return true;
        }
        ShowlDerivedPropertyList derivedList = sourceNode.getDerivedProperty(targetPredicate);
        ShowlPropertyShape showlPropertyShape = sourceProperty = derivedList == null ? null : derivedList.unfiltered();
        return this.match(sourceProperty, targetProperty);
    }

    private boolean match(ShowlPropertyShape sourceProperty, ShowlPropertyShape targetProperty) {
        if (sourceProperty != null) {
            ShowlPropertyShape synonym;
            if (!(sourceProperty instanceof ShowlDirectPropertyShape) && (synonym = sourceProperty.getSynonym()) instanceof ShowlDirectPropertyShape) {
                sourceProperty = synonym;
            }
            if (!(targetProperty instanceof ShowlDirectPropertyShape) && (synonym = targetProperty.getSynonym()) instanceof ShowlDirectPropertyShape) {
                targetProperty = synonym;
            }
            this.addExpression(targetProperty, sourceProperty);
            return true;
        }
        return false;
    }

    private void buildJoinConditions(ShowlNodeShape nodeA, MappingRole role, ShowlJoinCondition joinCondition, ShowlNodeShapeConsumer consumer) throws ShowlProcessingException {
        if (nodeA.getShape().getNodeShapeCube() != null) {
            this.joinCube(nodeA, joinCondition);
            this.addConsumable(nodeA);
        } else if (nodeA.getAccessor() == null && nodeA.hasDataSource() && !this.isUndefinedClass(nodeA.getOwlClass())) {
            Set<ShowlNodeShape> candidates = this.selectCandidateSources(nodeA);
            for (ShowlNodeShape nodeB : candidates) {
                ShowlNodeShape sourceNode;
                if (nodeB.getShape() == nodeA.getShape()) {
                    ShowlNodeShape targetNode = role == MappingRole.TARGET ? nodeA : nodeB;
                    ShowlNodeShape sourceNode2 = role == MappingRole.TARGET ? nodeB : nodeA;
                    this.createIdentityMapping(sourceNode2, targetNode, null);
                    continue;
                }
                ShowlClass classA = nodeA.getOwlClass();
                ShowlClass classB = nodeB.getOwlClass();
                ShowlNodeShape targetNode = role == MappingRole.TARGET ? nodeA : nodeB;
                ShowlNodeShape showlNodeShape = sourceNode = role == MappingRole.TARGET ? nodeB : nodeA;
                if (classA.isSubClassOf(classB) || classB.isSubClassOf(classA)) {
                    this.doJoin(targetNode, sourceNode, joinCondition);
                    continue;
                }
                this.joinNested(sourceNode, targetNode, joinCondition);
            }
            this.joinObjectProperties(nodeA, joinCondition);
            if (consumer != null) {
                this.addConsumable(nodeA);
            }
        }
    }

    private void joinCube(ShowlNodeShape targetNode, ShowlJoinCondition joinCondition) {
        PropertyConstraint p;
        URI valueType;
        List<PropertyConstraint> varList = targetNode.getShape().getVariable();
        if (varList.size() != 1) {
            this.fail("Expected a single variable for NodeShape {0} associated with a cadl:Cube", targetNode.getPath());
        }
        if ((valueType = RdfUtil.uri((Value)(p = varList.get(0)).getValueClass())) == null) {
            this.fail("sh:class of variable ?{0} on NodeShape {1} must be defined.", p.getPredicate().getLocalName(), RdfUtil.compactName(this.reasoner.getGraph().getNamespaceManager(), targetNode.getShape().getId()));
        }
        for (ShowlDerivedPropertyShape varProperty : targetNode.getDerivedProperty(p.getPredicate())) {
            ShowlNodeShape varNode = varProperty.getValueShape();
            if (varNode == null) continue;
            Set<ShowlNodeShape> candidates = this.selectCandidateSources(targetNode);
            for (ShowlNodeShape sourceNode : candidates) {
                List<ShowlPropertyShape> idList = sourceNode.out(Konig.id);
                if (idList.isEmpty()) continue;
                ShowlPropertyShape sourceId = idList.get(0);
                ShowlTargetToSourceJoinCondition t2s = new ShowlTargetToSourceJoinCondition(varProperty, sourceId);
                ShowlFromCondition fromCondition = new ShowlFromCondition(t2s, sourceNode);
                for (ShowlPropertyShape targetOut : varNode.allOutwardProperties()) {
                    for (ShowlPropertyShape sourceOut : sourceNode.out(targetOut.getPredicate())) {
                        if (!(sourceOut instanceof ShowlDirectPropertyShape)) continue;
                        this.produceMapping(fromCondition, sourceOut, targetOut);
                    }
                }
            }
        }
    }

    private void fail(String pattern, Object ... args) {
        String text = MessageFormat.format(pattern, args);
        throw new ShowlProcessingException(text);
    }

    private void createIdentityMapping(ShowlNodeShape sourceNode, ShowlNodeShape targetNode, ShowlJoinCondition join) {
        if (join == null) {
            join = new ShowlFromCondition(null, sourceNode);
        }
        for (ShowlDirectPropertyShape targetProperty : targetNode.getProperties()) {
            ShowlDirectPropertyShape sourceProperty = sourceNode.getProperty(targetProperty.getPredicate());
            new ShowlMapping(join, sourceProperty, targetProperty);
            if (targetProperty.getValueShape() == null) continue;
            this.createIdentityMapping(sourceProperty.getValueShape(), targetProperty.getValueShape(), join);
        }
    }

    private void addConsumable(ShowlNodeShape nodeA) {
        if (this.consumable == null) {
            this.consumable = new HashSet<ShowlNodeShape>();
        }
        this.consumable.add(nodeA);
        if (logger.isTraceEnabled()) {
            logger.trace("addConsumable({})", (Object)nodeA.getPath());
        }
    }

    private void joinNested(ShowlNodeShape sourceNode, ShowlNodeShape targetNode, ShowlJoinCondition prior) {
        ShowlClass targetClass;
        ShowlNodeShape nestedSource;
        if (logger.isTraceEnabled()) {
            logger.trace("joinNested({}, {})", (Object)sourceNode.getPath(), (Object)targetNode.getPath());
        }
        if ((nestedSource = this.findNestedSource(sourceNode, targetClass = targetNode.getOwlClass())) != null) {
            this.doJoin(targetNode, nestedSource, prior);
        }
    }

    private ShowlNodeShape findNestedSource(ShowlNodeShape sourceNode, ShowlClass targetClass) {
        NestedShapeSelector selector = new NestedShapeSelector(targetClass);
        selector.scan(sourceNode.getProperties());
        this.scanDerivedProperties(selector, sourceNode);
        selector.scan(sourceNode.getInwardProperties());
        return selector.getSelected();
    }

    private void scanDerivedProperties(NestedShapeSelector selector, ShowlNodeShape sourceNode) {
        for (List list : sourceNode.getDerivedProperties()) {
            selector.scan(list);
        }
    }

    private void joinObjectProperties(ShowlNodeShape leftNode, ShowlJoinCondition joinCondition) throws ShowlProcessingException {
        this.joinOutwardObjectPropeties(leftNode, joinCondition);
        this.joinInwardObjectProperties(leftNode, joinCondition);
    }

    private void joinInwardObjectProperties(ShowlNodeShape leftNode, ShowlJoinCondition joinCondition) {
        for (ShowlPropertyShape showlPropertyShape : leftNode.getInwardProperties()) {
            ShowlClass childClass = showlPropertyShape.getValueType(this.showlFactory);
            if (!this.isUndefinedClass(childClass)) {
                for (ShowlNodeShape rightNode : childClass.getTargetClassOf()) {
                    if (rightNode.isNamedRoot()) {
                        ShowlPropertyShape rightJoinProperty = rightNode.findProperty(showlPropertyShape.getPredicate());
                        if (rightJoinProperty == null) continue;
                        this.doJoinInwardObjectProperty(showlPropertyShape, rightJoinProperty, joinCondition);
                        continue;
                    }
                    if (rightNode.getAccessor() == showlPropertyShape || !logger.isTraceEnabled()) continue;
                    logger.trace("joinInwardObjectProperties: TODO: For {}, handle rightNode {}", (Object)showlPropertyShape.getPath(), (Object)rightNode.getPath());
                }
                continue;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("joinInwardObjectProperties: Class is not defined: {}", (Object)showlPropertyShape.getPath());
        }
    }

    private void doJoinInwardObjectProperty(ShowlPropertyShape leftProperty, ShowlPropertyShape rightJoinProperty, ShowlJoinCondition joinCondition) {
        ShowlPropertyShape leftJoinProperty = leftProperty.getDeclaringShape().findProperty(Konig.id);
        ShowlPropertyShape rightProperty = rightJoinProperty.getDeclaringShape().findProperty(Konig.id);
        if (leftJoinProperty == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("doJoinInwardObjectProperty: aborting join because left node does not have an Id: {}", (Object)leftProperty.getPath());
            }
            return;
        }
        ShowlTargetToSourceJoinCondition newJoin = new ShowlTargetToSourceJoinCondition(leftJoinProperty, rightJoinProperty);
        new ShowlMapping(newJoin, leftProperty, rightProperty);
        if (logger.isTraceEnabled()) {
            logger.trace("doJoinInwardObjectProperty: {} ... {}", (Object)leftProperty.getPath(), (Object)rightJoinProperty.getPath());
        }
        this.doBuildMappings(leftProperty.getValueShape(), rightJoinProperty.getDeclaringShape(), (ShowlJoinCondition)newJoin);
    }

    private void joinOutwardObjectPropeties(ShowlNodeShape leftNode, ShowlJoinCondition joinCondition) throws ShowlProcessingException {
        this.joinOutwardObjectProperties(leftNode.getProperties(), joinCondition);
        this.joinOutwardDerivedObjectProperties(leftNode.getDerivedProperties(), joinCondition);
    }

    private void joinOutwardDerivedObjectProperties(Collection<ShowlDerivedPropertyList> collection, ShowlJoinCondition joinCondition) {
        for (List list : collection) {
            this.joinOutwardObjectProperties(list, joinCondition);
        }
    }

    private void joinOutwardObjectProperties(Collection<? extends ShowlPropertyShape> properties, ShowlJoinCondition joinCondition) throws ShowlProcessingException {
        for (ShowlPropertyShape showlPropertyShape : properties) {
            ShowlPropertyShape sourceNodeId;
            ShowlClass childClass;
            ShowlNodeShape sourceNode = showlPropertyShape.getValueShape();
            if (sourceNode == null || this.isUndefinedClass(childClass = sourceNode.getOwlClass()) || (sourceNodeId = sourceNode.findProperty(Konig.id)) == null) continue;
            this.buildJoinConditions(sourceNode, MappingRole.SOURCE, joinCondition, null);
        }
    }

    private void doJoin(ShowlNodeShape targetNode, ShowlNodeShape sourceNode, ShowlJoinCondition joinCondition) {
        ShowlPropertyShape sourceId = sourceNode.findProperty(Konig.id);
        ShowlPropertyShape targetId = targetNode.findProperty(Konig.id);
        if (sourceId == null && (sourceId = this.useClassIriTemplate(sourceNode)) == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Cannot join {}...{} because left Id is not defined", (Object)sourceNode.getPath(), (Object)targetNode.getPath());
            }
            return;
        }
        if (targetId == null && (targetId = this.useClassIriTemplate(targetNode)) == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Cannot join {}...{} because right Id is not defined", (Object)sourceNode.getPath(), (Object)targetNode.getPath());
            }
            return;
        }
        if (sourceId.findJoinCondition(targetId) == null) {
            ShowlTargetToSourceJoinCondition join = new ShowlTargetToSourceJoinCondition(targetId, sourceId);
            this.buildMappings(sourceNode, targetNode, join);
        }
    }

    private ShowlPropertyShape useClassIriTemplate(ShowlNodeShape sourceNode) {
        IriTemplate template;
        ShowlClass owlClass = sourceNode.getOwlClass();
        if (owlClass != null && (template = owlClass.getIriTemplate()) != null) {
            ShowlTemplatePropertyShape p = new ShowlTemplatePropertyShape(sourceNode, null, template);
            sourceNode.addDerivedProperty(p);
            if (logger.isTraceEnabled()) {
                logger.trace("useClassIriTemplate({}) ... {}", (Object)sourceNode.getPath(), (Object)template.getText());
            }
            return p;
        }
        return null;
    }

    private void buildMappings(ShowlNodeShape leftNode, ShowlNodeShape rightNode, ShowlJoinCondition join) {
        if (logger.isTraceEnabled()) {
            logger.trace("buildMappings({}, {})", (Object)leftNode.getPath(), (Object)rightNode.getPath());
        }
        this.doBuildMappings(leftNode, rightNode, join);
        this.doBuildMappings(rightNode, leftNode, join);
    }

    private void doBuildMappings(ShowlNodeShape leftNode, ShowlNodeShape rightNode, ShowlJoinCondition join) {
        if (leftNode == null || rightNode == null) {
            return;
        }
        NodeMapping key = new NodeMapping(leftNode, rightNode, join);
        if (!this.nodeMappings.contains(key)) {
            this.nodeMappings.add(key);
            this.doBuildMappings(leftNode.getProperties(), rightNode, join);
            this.buildDerivedMappings(leftNode.getDerivedProperties(), rightNode, join);
            this.buildInwardMappings(leftNode.getInwardProperties(), rightNode, join);
        }
    }

    private void buildDerivedMappings(Collection<ShowlDerivedPropertyList> collection, ShowlNodeShape rightNode, ShowlJoinCondition join) {
        for (List list : collection) {
            this.doBuildMappings(list, rightNode, join);
        }
    }

    private void buildInwardMappings(Collection<? extends ShowlPropertyShape> properties, ShowlNodeShape rightNode, ShowlJoinCondition join) {
        for (ShowlPropertyShape showlPropertyShape : properties) {
            ShowlNodeShape rightChild;
            ShowlNodeShape leftChild;
            ShowlPropertyShape rightProperty = rightNode.getInwardProperty(showlPropertyShape.getPredicate());
            if (rightProperty == null) {
                ShowlProperty inverse;
                Iterator<ShowlProperty> iterator = showlPropertyShape.getProperty().getInverses().iterator();
                while (iterator.hasNext() && (rightProperty = rightNode.findProperty((inverse = iterator.next()).getPredicate())) == null) {
                }
            }
            if (rightProperty == null) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("buildInwardMapping - Failed to find mapping for {} in {}", (Object)showlPropertyShape.getPath(), (Object)rightNode.getPath());
                continue;
            }
            ShowlPropertyShape directLeft = this.directProperty(showlPropertyShape);
            ShowlPropertyShape directRight = this.directProperty(rightProperty);
            if (directLeft != null && directRight != null && directLeft.getMapping(join) == null) {
                this.produceMapping(join, directLeft, directRight);
            }
            if ((leftChild = showlPropertyShape.getValueShape()) == null || (rightChild = rightProperty.getValueShape()) == null) continue;
            this.buildMappings(leftChild, rightChild, join);
        }
    }

    private void doBuildMappings(Collection<? extends ShowlPropertyShape> properties, ShowlNodeShape rightNode, ShowlJoinCondition join) {
        ShowlPropertyShape rightAccessor = rightNode.getAccessor();
        for (ShowlPropertyShape showlPropertyShape : properties) {
            ShowlNodeShape rightChild;
            ShowlPropertyShape peer;
            ShowlPropertyShape rightProperty = rightNode.findProperty(showlPropertyShape.getPredicate());
            if (rightProperty == null) {
                if (rightAccessor instanceof ShowlInwardPropertyShape && rightAccessor.getPredicate().equals((Object)showlPropertyShape.getPredicate())) {
                    ShowlPropertyShape rightId = this.produceIdProperty(rightAccessor.getDeclaringShape());
                    this.produceMapping(join, showlPropertyShape, rightId);
                    if (showlPropertyShape.getValueShape() != null) {
                        this.doBuildMappings(showlPropertyShape.getValueShape(), rightAccessor.getDeclaringShape(), join);
                    }
                } else {
                    if (this.reasoner.isEnumerationClass((Resource)rightNode.getOwlClass().getId())) {
                        ShowlNodeShape leftNode = showlPropertyShape.getDeclaringShape();
                        EnumMappingAction action = this.enumMappingActions.get(rightNode.getId());
                        if (action != null) continue;
                        action = new EnumMappingAction(leftNode, this.showlFactory, this.reasoner);
                        this.enumMappingActions.put(leftNode.getId(), action);
                        continue;
                    }
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("doBuildMappings - mapping not found for {} in {}", (Object)showlPropertyShape.getPath(), (Object)rightNode.getPath());
                    continue;
                }
            }
            if (Konig.id.equals((Object)showlPropertyShape.getPredicate()) && rightProperty != null && Konig.id.equals((Object)rightProperty.getPredicate())) {
                this.produceMapping(join, showlPropertyShape, rightProperty);
                continue;
            }
            ShowlPropertyShape showlPropertyShape2 = this.propertyToMap(showlPropertyShape);
            rightProperty = this.propertyToMap(rightProperty);
            if (showlPropertyShape2 == null || rightProperty == null) continue;
            this.produceMapping(join, showlPropertyShape2, rightProperty);
            ShowlNodeShape leftChild = showlPropertyShape2.getValueShape();
            if (leftChild == null && (peer = showlPropertyShape2.getPeer()) != null) {
                leftChild = peer.getValueShape();
            }
            if (leftChild == null || (rightChild = rightProperty.getValueShape()) == null) continue;
            this.buildMappings(leftChild, rightChild, join);
        }
    }

    private ShowlPropertyShape produceIdProperty(ShowlNodeShape rightNode) {
        ShowlPropertyShape id = rightNode.findProperty(Konig.id);
        if (id == null) {
            id = this.useClassIriTemplate(rightNode);
        }
        return id;
    }

    private ShowlPropertyShape propertyToMap(ShowlPropertyShape p) {
        ShowlPropertyShape result = this.directProperty(p);
        if (result != null) {
            return result;
        }
        result = this.derivedByFormula(p);
        if (result != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("propertyToMap({}) => {}", (Object)p.getPath(), (Object)result.getPath());
            }
            return result;
        }
        return p;
    }

    private ShowlDerivedPropertyShape derivedByFormula(ShowlPropertyShape p) {
        ShowlDerivedPropertyShape derived;
        if (p instanceof ShowlDerivedPropertyShape && (derived = (ShowlDerivedPropertyShape)p).getPropertyConstraint() != null && derived.getPropertyConstraint().getFormula() != null) {
            return derived;
        }
        return null;
    }

    private void produceMapping(ShowlJoinCondition join, ShowlPropertyShape left, ShowlPropertyShape right) {
        if (join.isJoinProperty(left) && join.isJoinProperty(right)) {
            new ShowlJoinMapping(join);
        } else {
            new ShowlMapping(join, left, right);
        }
    }

    private ShowlPropertyShape directProperty(ShowlPropertyShape p) {
        return p == null ? null : (p.isDirect() ? p : p.getPeer());
    }

    private boolean isUndefinedClass(ShowlClass owlClass) {
        return ShowlUtil.isUndefinedClass(owlClass);
    }

    private void buildMapping(ShowlJoinCondition join, ShowlNodeShape leftNode, ShowlPropertyShape leftProperty, ShowlNodeShape rightNode) {
        if (logger.isTraceEnabled()) {
            logger.trace("buildMapping: {}...{}", (Object)leftProperty.getPath(), (Object)rightNode.getPath());
        }
        if (leftProperty.getMapping(join) == null) {
            ShowlPropertyShape rightProperty = rightNode.findProperty(leftProperty.getPredicate());
            if (rightProperty == null) {
                Set<ShowlProperty> set = leftProperty.getProperty().getConnectedProperties();
                for (ShowlProperty q : set) {
                    if (q != leftProperty.getProperty() && (rightProperty = rightNode.findProperty(q.getPredicate())) != null) break;
                }
            }
            if (rightProperty != null) {
                if (rightProperty.isLeaf() && !rightProperty.isDirect() && (rightProperty = rightProperty.getPeer()) == null) {
                    return;
                }
                ShowlMapping mapping = new ShowlMapping(join, leftProperty, rightProperty);
                leftProperty.addMapping(mapping);
                rightProperty.addMapping(mapping);
                this.buildNestedMappings(join, leftProperty, rightProperty);
            }
        }
    }

    private void buildNestedMappings(ShowlJoinCondition join, ShowlPropertyShape leftProperty, ShowlPropertyShape rightProperty) {
        ShowlNodeShape leftNode = leftProperty.getValueShape();
        ShowlNodeShape rightNode = rightProperty.getValueShape();
        if (leftNode != null && rightNode != null) {
            for (ShowlPropertyShape showlPropertyShape : leftNode.getProperties()) {
                this.buildMapping(join, leftNode, showlPropertyShape, rightNode);
            }
        }
    }

    public void inferTargetClasses() {
        for (ShowlNodeShape gns : this.classlessShapes) {
            this.inferTargetClass(gns);
        }
        this.classlessShapes = null;
    }

    private void inferTargetClass(ShowlNodeShape node) {
        if (!ShowlUtil.isUndefinedClass(node.getOwlClass())) {
            return;
        }
        DomainReasoner domainReasoner = new DomainReasoner(this.reasoner);
        Set<ShowlPropertyShape> allProperties = node.allOutwardProperties();
        for (ShowlPropertyShape p : allProperties) {
            ShowlProperty property;
            if (p.isNestedAccordingToFormula() || (property = p.getProperty()) == null) continue;
            if (property.getDomain() != null) {
                domainReasoner.require(property.getDomain().getId());
                continue;
            }
            domainReasoner.domainIncludes(property.domainIncludes(this.showlFactory));
        }
        Set<URI> candidates = domainReasoner.getRequiredClasses();
        if (candidates.isEmpty()) {
            candidates = this.inferTargetClassFromFormula(node, domainReasoner);
        }
        if (candidates.size() == 1) {
            URI owlClass = candidates.iterator().next();
            this.replaceOwlClass(node, owlClass);
            if (logger.isTraceEnabled()) {
                logger.trace("inferTargetClass: Set {} as target class of {}", (Object)owlClass.getLocalName(), (Object)node.getPath());
            }
        } else if (logger.isWarnEnabled()) {
            if (candidates.isEmpty()) {
                candidates = domainReasoner.getAllClasses();
            }
            if (candidates.isEmpty()) {
                logger.warn("No candidates found for target class of " + node.getPath());
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append("Target class at " + node.getPath() + " is ambiguous.  Candidates include\n");
                for (URI c : candidates) {
                    builder.append("  ");
                    builder.append(c.getLocalName());
                    builder.append('\n');
                }
                logger.warn(builder.toString());
            }
        }
    }

    private boolean updateCandidates(Set<URI> candidates, ShowlProperty property) {
        Set<URI> domainIncludes = property.domainIncludes(this.showlFactory);
        Iterator<URI> sequence = domainIncludes.iterator();
        while (sequence.hasNext()) {
            URI domain = sequence.next();
            if (!OWL.THING.equals((Object)domain) && !Konig.Undefined.equals((Object)domain)) continue;
            sequence.remove();
        }
        if (domainIncludes.isEmpty()) {
            return true;
        }
        if (candidates.isEmpty()) {
            candidates.addAll(domainIncludes);
            return true;
        }
        boolean compatible = true;
        block1: for (URI domain : domainIncludes) {
            URI candidate;
            sequence = candidates.iterator();
            while (sequence.hasNext() && !domain.equals((Object)(candidate = sequence.next()))) {
                if (this.reasoner.isSubClassOf((Resource)domain, (Resource)candidate)) {
                    sequence.remove();
                    candidates.add(domain);
                    continue block1;
                }
                if (!this.reasoner.isSubClassOf((Resource)candidate, (Resource)domain)) continue;
                continue block1;
            }
        }
        return compatible;
    }

    private Set<URI> inferTargetClassFromFormula(ShowlNodeShape node, DomainReasoner domainReasoner) {
        ShowlPropertyShape accessor = node.getAccessor();
        if (accessor != null) {
            ShowlClass owlClass = accessor.getProperty().getRange();
            if (owlClass != null) {
                return this.setOf(owlClass.getId());
            }
            ShowlPropertyShape peer = accessor.getPeer();
            if (peer != null && (owlClass = peer.getProperty().getRange()) != null) {
                return this.setOf(owlClass.getId());
            }
        }
        boolean updated = false;
        for (ShowlPropertyShape showlPropertyShape : node.getProperties()) {
            URI predicate;
            ShowlProperty property;
            DirectionStep dirStep;
            PathStep step;
            PathExpression path;
            List<PathStep> stepList;
            PrimaryExpression primary;
            QuantifiedExpression formula;
            PropertyConstraint constraint = showlPropertyShape.getPropertyConstraint();
            if (constraint == null || (formula = constraint.getFormula()) == null || !((primary = formula.asPrimaryExpression()) instanceof PathExpression) || (stepList = (path = (PathExpression)primary).getStepList()).size() != 1 || !((step = stepList.get(0)) instanceof DirectionStep) || (dirStep = (DirectionStep)step).getDirection() != Direction.OUT || (property = this.getProperty(predicate = dirStep.getTerm().getIri())) == null) continue;
            Set<URI> domainIncludes = property.domainIncludes(this.showlFactory);
            domainReasoner.domainIncludes(domainIncludes);
            updated = true;
        }
        return updated ? domainReasoner.getRequiredClasses() : Collections.emptySet();
    }

    private <T> Set<T> setOf(T ... elements) {
        HashSet<T> result = new HashSet<T>();
        for (T e : elements) {
            result.add(e);
        }
        return result;
    }

    private void replaceOwlClass(ShowlNodeShape node, URI owlClassId) {
        ShowlClass newClass = this.produceOwlClass(owlClassId);
        node.setOwlClass(newClass);
        if (logger.isDebugEnabled()) {
            logger.debug("Set OWL Class of " + node.getPath() + " as <" + owlClassId.stringValue() + ">");
        }
    }

    protected void loadShapes() {
        this.classlessShapes = new ArrayList<ShowlNodeShape>();
        Set<Shape> rootShapes = this.selectShapes();
        for (Shape shape : rootShapes) {
            this.createNodeShape(null, shape);
        }
    }

    protected Set<Shape> selectShapes() {
        LinkedHashSet<Shape> result = new LinkedHashSet<Shape>();
        LinkedHashMap<Shape, Boolean> hasReference = new LinkedHashMap<Shape, Boolean>();
        List<Shape> shapeList = this.shapeManager.listShapes();
        for (Shape shape : shapeList) {
            this.putReferences(shape.getProperty(), hasReference);
        }
        for (Shape shape : shapeList) {
            if (shape.getShapeDataSource().isEmpty() && hasReference.get(shape) != null) continue;
            result.add(shape);
        }
        return result;
    }

    protected void putReferences(List<PropertyConstraint> property, Map<Shape, Boolean> hasReference) {
        for (PropertyConstraint p : property) {
            Shape shape = p.getShape();
            if (shape == null || hasReference.put(shape, Boolean.TRUE) != null) continue;
            this.putReferences(shape.getProperty(), hasReference);
        }
    }

    private ShowlNodeShape createShowlNodeShape(ShowlPropertyShape accessor, Shape shape, ShowlClass owlClass) {
        ShowlNodeShapeSet set;
        ShowlNodeShape result = new ShowlNodeShape(this, accessor, shape, owlClass);
        owlClass.addTargetClassOf(result);
        if (Konig.Undefined.equals((Object)owlClass.getId()) && this.classlessShapes != null) {
            this.classlessShapes.add(result);
        }
        if ((set = this.nodeShapes.get(shape.getId())) == null) {
            set = new ShowlNodeShapeSet();
            this.nodeShapes.put(shape.getId(), set);
        }
        set.add(result);
        return result;
    }

    private ShowlNodeShape createNodeShape(ShowlPropertyShape accessor, Shape shape) {
        ShowlClass owlClass = this.targetOwlClass(accessor, shape);
        ShowlNodeShape result = this.createShowlNodeShape(accessor, shape, owlClass);
        this.addProperties(result);
        return result;
    }

    private ShowlClass targetOwlClass(ShowlPropertyShape accessor, Shape shape) {
        PropertyConstraint p;
        if (accessor != null && (p = accessor.getPropertyConstraint()) != null && p.getValueClass() instanceof URI) {
            return this.produceOwlClass((URI)p.getValueClass());
        }
        URI classId = shape.getTargetClass();
        if (classId == null) {
            classId = Konig.Undefined;
        }
        return this.produceOwlClass(classId);
    }

    void addProperties(ShowlNodeShape declaringShape) {
        Shape childShape;
        ShowlPropertyShape q;
        ShowlProperty property;
        URI predicate;
        if (logger.isTraceEnabled()) {
            logger.trace("addProperties({})", (Object)declaringShape.getPath());
        }
        this.addIdProperty(declaringShape);
        for (PropertyConstraint p : declaringShape.getShape().getVariable()) {
            predicate = p.getPredicate();
            property = this.produceShowlProperty(predicate);
            property.setDomain(declaringShape.getOwlClass());
            property.setRange(this.produceOwlClass(RdfUtil.uri((Value)p.getValueClass())));
            ShowlVariablePropertyShape out = new ShowlVariablePropertyShape(declaringShape, property);
            property.addPropertyShape(out);
            declaringShape.addDerivedProperty(out);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("addProperties: add variable ?{} to {}", (Object)predicate.getLocalName(), (Object)declaringShape.getPath());
        }
        for (PropertyConstraint p : declaringShape.getShape().getProperty()) {
            predicate = p.getPredicate();
            if (predicate == null) continue;
            property = this.produceShowlProperty(predicate);
            q = this.createDirectPropertyShape(declaringShape, property, p);
            declaringShape.addProperty((ShowlDirectPropertyShape)q);
            this.processFormula(q);
            childShape = p.getShape();
            if (childShape == null) continue;
            if (declaringShape.hasAncestor(childShape.getId())) {
                this.error("Cyclic shape detected at: " + q.getPath());
            }
            this.createNodeShape(q, childShape);
        }
        for (PropertyConstraint p : declaringShape.getShape().getDerivedProperty()) {
            predicate = p.getPredicate();
            if (predicate == null) continue;
            property = this.produceShowlProperty(predicate);
            q = this.createFormulaPropertyShape(declaringShape, property, p);
            declaringShape.addDerivedProperty((ShowlDerivedPropertyShape)q);
            childShape = p.getShape();
            if (childShape == null) continue;
            if (declaringShape.hasAncestor(childShape.getId())) {
                this.error("Cyclic shape detected at: " + q.getPath());
            }
            this.error("child shape of derived property not supported yet for " + q.getPath());
        }
    }

    private ShowlFormulaPropertyShape createFormulaPropertyShape(ShowlNodeShape declaringShape, ShowlProperty property, PropertyConstraint constraint) {
        ShowlFormulaPropertyShape p = new ShowlFormulaPropertyShape(declaringShape, property, constraint);
        if (logger.isTraceEnabled()) {
            logger.trace("createDerivedPropertyShape: {}", (Object)p.getPath());
        }
        return p;
    }

    void addIdProperty(ShowlNodeShape declaringShape) {
        if (declaringShape.getShape().getIriTemplate() != null) {
            ShowlProperty property = this.produceShowlProperty(Konig.id);
            ShowlOutwardPropertyShape out = new ShowlOutwardPropertyShape(declaringShape, property);
            out.setFormula(ShowlFunctionExpression.fromIriTemplate(this.showlFactory, this.showlFactory, out, declaringShape.getShape().getIriTemplate()));
            declaringShape.addDerivedProperty(out);
        } else if (declaringShape.getShape().getNodeKind() == NodeKind.IRI) {
            ShowlProperty property = this.produceShowlProperty(Konig.id);
            ShowlDirectPropertyShape p = this.createDirectPropertyShape(declaringShape, property, null);
            declaringShape.addProperty(p);
        }
    }

    private ShowlDirectPropertyShape createDirectPropertyShape(ShowlNodeShape declaringShape, ShowlProperty property, PropertyConstraint constraint) {
        ShowlDirectPropertyShape p = new ShowlDirectPropertyShape(declaringShape, property, constraint);
        property.addPropertyShape(p);
        if (logger.isTraceEnabled()) {
            logger.trace("createDirectPropertyShape: created {}", (Object)p.getPath());
        }
        return p;
    }

    private void error(String text) {
        logger.error(text);
    }

    protected ShowlProperty produceShowlProperty(URI predicate) {
        ShowlProperty property = this.properties.get(predicate);
        if (property == null) {
            property = new ShowlProperty(predicate);
            this.properties.put(predicate, property);
            URI domain = RdfUtil.uri((Value)this.reasoner.getDomain(predicate));
            URI range = RdfUtil.uri((Value)this.reasoner.getRange(predicate));
            if (domain != null) {
                property.setDomain(this.produceOwlClass(domain));
            }
            if (range != null) {
                property.setRange(this.produceOwlClass(range));
            }
        }
        return property;
    }

    private void processFormula(ShowlPropertyShape ps) {
        QuantifiedExpression e;
        PropertyConstraint p = ps.getPropertyConstraint();
        QuantifiedExpression quantifiedExpression = e = p == null ? null : p.getFormula();
        if (e != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("processFormula({})", (Object)ps.getPath());
            }
            this.setShowlExpression(ps, e);
            e.dispatch(new PathVisitor(ps));
        }
    }

    private void setShowlExpression(ShowlPropertyShape ps, QuantifiedExpression e) {
        ShowlExpressionBuilder builder = new ShowlExpressionBuilder(this.showlFactory, this.showlFactory);
        ShowlExpression ex = builder.expression(ps, e);
        ps.setFormula(ex);
    }

    private ShowlClass theMostSpecificClass(ShowlClass a, ShowlClass b) {
        ShowlClass result = a == null ? b : (b == null ? a : (this.reasoner.isSubClassOf((Resource)a.getId(), (Resource)b.getId()) ? a : b));
        return result == null ? this.produceOwlClass(Konig.Undefined) : result;
    }

    ShowlClass produceOwlClass(URI owlClass) {
        ShowlClass result;
        if (owlClass == null) {
            owlClass = Konig.Undefined;
        }
        if ((result = this.owlClasses.get(owlClass)) == null) {
            result = new ShowlClass(this.getReasoner(), owlClass);
            this.owlClasses.put(owlClass, result);
        }
        return result;
    }

    @Override
    public Collection<ShowlClass> listClasses() {
        return this.owlClasses.values();
    }

    @Override
    public ShowlClass findClassById(URI classId) {
        return this.owlClasses.get(classId);
    }

    private void addExpression(ShowlPropertyShape target, ShowlPropertyShape source) {
        if (source instanceof ShowlDirectPropertyShape) {
            target.addExpression(new ShowlDirectPropertyExpression((ShowlDirectPropertyShape)source));
        } else {
            ShowlDerivedPropertyShape derived = (ShowlDerivedPropertyShape)source;
            this.addClassIriTemplateFormula(target, derived);
            if (derived.getFormula() != null) {
                target.addExpression(derived.getFormula());
            } else {
                target.addExpression(new ShowlDerivedPropertyExpression((ShowlDerivedPropertyShape)source));
            }
        }
        ShowlNodeShape targetNode = target.getValueShape();
        if (targetNode != null && !this.reasoner.isEnumerationClass((Resource)targetNode.getOwlClass().getId())) {
            ShowlPropertyShape synonym;
            ShowlNodeShape sourceNode = source.getValueShape();
            if (sourceNode == null && (synonym = source.getSynonym()) != null) {
                sourceNode = synonym.getValueShape();
            }
            if (sourceNode != null) {
                ArrayList<ShowlNodeShape> list = new ArrayList<ShowlNodeShape>();
                list.add(sourceNode);
                this.buildTransforms(targetNode, list);
            }
        }
    }

    private void addClassIriTemplateFormula(ShowlPropertyShape target, ShowlDerivedPropertyShape derived) {
        if (derived.getFormula() == null && derived.getValueShape() != null) {
            Value templateValue;
            ShowlClass owlClass = target.getValueType(this.showlFactory);
            Vertex v = this.reasoner.getGraph().getVertex((Resource)owlClass.getId());
            if (v != null && (templateValue = v.getValue(Konig.iriTemplate)) != null) {
                ShowlNodeShape node = derived.getValueShape();
                IriTemplate classTemplate = new IriTemplate(templateValue.stringValue());
                Context classContext = classTemplate.getContext();
                classContext.compile();
                IriTemplate template = new IriTemplate();
                BasicContext context = new BasicContext("");
                template.setContext(context);
                for (ValueFormat.Element element : classTemplate.toList()) {
                    switch (element.getType()) {
                        case TEXT: {
                            template.addText(element.getText());
                            break;
                        }
                        case VARIABLE: {
                            URIImpl termId = new URIImpl(classContext.expandIRI(element.getText()));
                            ShowlPropertyShape p = node.findOut((URI)termId);
                            if (p == null) break;
                            if (p instanceof ShowlDerivedPropertyShape) {
                                p = p.getSynonym();
                            }
                            if (p instanceof ShowlDirectPropertyShape) {
                                URI predicate = p.getPredicate();
                                context.addTerm(predicate.getLocalName(), predicate.stringValue());
                                template.addVariable(predicate.getLocalName());
                                break;
                            }
                            return;
                        }
                    }
                }
                ShowlExpression e = ShowlFunctionExpression.fromIriTemplate(this.showlFactory, this.showlFactory, derived, template);
                derived.setFormula(e);
            }
        }
    }

    public class Factory
    implements ShowlService {
        @Override
        public ShowlNodeShape logicalNodeShape(URI owlClass) throws ShowlProcessingException {
            NamespaceManager nsManager = ShowlManager.this.reasoner.getGraph().getNamespaceManager();
            Namespace ns = nsManager.findByName(owlClass.getNamespace());
            if (ns == null) {
                throw new ShowlProcessingException("Prefix not found for namespace <" + owlClass.getNamespace() + ">");
            }
            StringBuilder builder = new StringBuilder();
            builder.append("urn:konig:logicalShape:");
            builder.append(ns.getPrefix());
            builder.append(':');
            builder.append(owlClass.getLocalName());
            URIImpl shapeId = new URIImpl(builder.toString());
            ShowlNodeShapeSet set = (ShowlNodeShapeSet)ShowlManager.this.nodeShapes.get(shapeId);
            if (set == null) {
                set = new ShowlNodeShapeSet();
                ShowlManager.this.nodeShapes.put(shapeId, set);
                Shape shape = new Shape((Resource)shapeId);
                ShowlClass showlClass = ShowlManager.this.produceOwlClass(owlClass);
                shape.addShapeDataSource(ShowlManager.this.staticDataSource());
                ShowlNodeShape node = new ShowlNodeShape(ShowlManager.this, null, shape, showlClass);
                showlClass.addTargetClassOf(node);
                set.add(node);
                shape.setNodeKind(NodeKind.IRI);
                shape.setTargetClass(owlClass);
                ShowlManager.this.addIdProperty(node);
                node.setShapeDataSource(new ShowlDataSource(node, ShowlManager.this.staticDataSource()));
                return node;
            }
            return set.top();
        }

        @Override
        public ShowlNodeShape createNodeShape(Shape shape) throws ShowlProcessingException {
            URI owlClass = shape.getTargetClass();
            if (owlClass == null) {
                throw new ShowlProcessingException("sh:targetClass must be defined for shape " + RdfUtil.compactName(ShowlManager.this.getReasoner().getGraph().getNamespaceManager(), shape.getId()));
            }
            ShowlClass showlClass = ShowlManager.this.targetOwlClass(null, shape);
            ShowlNodeShape nodeShape = new ShowlNodeShape(ShowlManager.this, null, shape, showlClass);
            showlClass.addTargetClassOf(nodeShape);
            ShowlManager.this.addProperties(nodeShape);
            if (logger.isTraceEnabled()) {
                logger.trace("Factory.createNodeShape({})", (Object)RdfUtil.localName(shape.getId()));
            }
            return nodeShape;
        }

        @Override
        public ShowlNodeShape createNodeShape(Shape shape, DataSource ds) throws ShowlProcessingException {
            ShowlNodeShape node = this.createNodeShape(shape);
            if (ds != null) {
                node.setShapeDataSource(new ShowlDataSource(node, ds));
            }
            return node;
        }

        @Override
        public ShowlProperty produceProperty(URI predicate) throws ShowlProcessingException {
            return ShowlManager.this.produceShowlProperty(predicate);
        }

        @Override
        public ShowlClass inferDomain(ShowlProperty p) {
            return p.inferDomain(ShowlManager.this.showlFactory);
        }

        @Override
        public ShowlClass inferRange(ShowlProperty p) {
            return p.inferRange(ShowlManager.this.showlFactory);
        }

        @Override
        public ShowlClass mostSpecificClass(ShowlClass a, ShowlClass b) {
            return ShowlManager.this.theMostSpecificClass(a, b);
        }

        @Override
        public ShowlNodeShape createShowlNodeShape(ShowlPropertyShape accessor, Shape shape, ShowlClass owlClass) {
            ShowlNodeShapeSet set;
            ShowlNodeShape result = new ShowlNodeShape(ShowlManager.this, accessor, shape, owlClass);
            owlClass.addTargetClassOf(result);
            if (Konig.Undefined.equals((Object)owlClass.getId()) && ShowlManager.this.classlessShapes != null) {
                ShowlManager.this.classlessShapes.add(result);
            }
            if ((set = (ShowlNodeShapeSet)ShowlManager.this.nodeShapes.get(shape.getId())) == null) {
                set = new ShowlNodeShapeSet();
                ShowlManager.this.nodeShapes.put(shape.getId(), set);
            }
            set.add(result);
            return result;
        }

        @Override
        public Set<ShowlNodeShape> selectCandidateSources(ShowlNodeShape targetShape) {
            return ShowlManager.this.selectCandidateSources(targetShape);
        }

        @Override
        public Graph getGraph() {
            return ShowlManager.this.reasoner.getGraph();
        }

        @Override
        public ShapeManager getShapeManager() {
            return ShowlManager.this.shapeManager;
        }

        @Override
        public ShowlClass produceShowlClass(URI classId) {
            return ShowlManager.this.produceOwlClass(classId);
        }

        @Override
        public OwlReasoner getOwlReasoner() {
            return ShowlManager.this.reasoner;
        }

        @Override
        public Shape enumNodeShape(ShowlClass enumClass) throws ShowlProcessingException {
            throw new ShowlProcessingException("enumNodeShape method not supported");
        }
    }

    private static class NestedShapeSelector {
        private ShowlNodeShape selected;
        private ShowlClass owlClass;
        private boolean failed = false;

        public NestedShapeSelector(ShowlClass owlClass) {
            this.owlClass = owlClass;
        }

        void scan(Collection<? extends ShowlPropertyShape> list) {
            if (!this.failed) {
                for (ShowlPropertyShape showlPropertyShape : list) {
                    ShowlNodeShape nested = showlPropertyShape.getValueShape();
                    if (nested == null || !nested.getOwlClass().isSubClassOf(this.owlClass)) continue;
                    if (this.selected == null) {
                        this.selected = nested;
                        continue;
                    }
                    if (logger.isTraceEnabled() && !this.failed) {
                        logger.trace("Nested shape selection is ambiguous. Options include {} and {}", (Object)this.selected.getPath(), (Object)nested.getPath());
                    }
                    this.failed = true;
                    return;
                }
            }
        }

        public ShowlNodeShape getSelected() {
            return this.failed ? null : this.selected;
        }
    }

    private class ModalClass {
        private boolean required;
        private URI owlClass;

        public ModalClass(URI owlClass, boolean required) {
            this.required = required;
            this.owlClass = owlClass;
        }

        public boolean isRequired() {
            return this.required;
        }

        public URI getOwlClass() {
            return this.owlClass;
        }

        public void update(URI owlClass, boolean required) {
            this.owlClass = owlClass;
            if (required) {
                this.required = true;
            }
        }
    }

    private class DomainReasoner {
        private OwlReasoner reasoner;
        private Set<ModalClass> candidates = new HashSet<ModalClass>();

        public DomainReasoner(OwlReasoner reasoner) {
            this.reasoner = reasoner;
        }

        public void require(URI owlClass) {
            this.candidates.add(new ModalClass(owlClass, true));
        }

        public void domainIncludes(Set<URI> domainIncludes) {
            boolean required = domainIncludes.size() == 1;
            for (URI domain : domainIncludes) {
                URI matched = null;
                for (ModalClass modal : this.candidates) {
                    URI candidate = modal.getOwlClass();
                    if (this.reasoner.isSubClassOf((Resource)domain, (Resource)candidate)) {
                        modal.update(domain, required);
                        matched = domain;
                        continue;
                    }
                    if (!this.reasoner.isSubClassOf((Resource)candidate, (Resource)domain)) continue;
                    modal.update(candidate, required);
                    matched = candidate;
                }
                if (matched != null) continue;
                this.candidates.add(new ModalClass(domain, required));
            }
        }

        public Set<URI> getRequiredClasses() {
            HashSet<URI> result = new HashSet<URI>();
            for (ModalClass modal : this.candidates) {
                if (!modal.isRequired()) continue;
                result.add(modal.getOwlClass());
            }
            return result;
        }

        public Set<URI> getAllClasses() {
            HashSet<URI> result = new HashSet<URI>();
            for (ModalClass modal : this.candidates) {
                result.add(modal.getOwlClass());
            }
            return result;
        }
    }

    private static enum MappingRole {
        SOURCE,
        TARGET;

    }

    private static class NodeMapping {
        private ShowlNodeShape leftNode;
        private ShowlNodeShape rightNode;
        private ShowlJoinCondition join;

        public NodeMapping(ShowlNodeShape leftNode, ShowlNodeShape rightNode, ShowlJoinCondition join) {
            this.leftNode = leftNode;
            this.rightNode = rightNode;
            this.join = join;
        }

        public boolean equals(Object other) {
            if (other instanceof NodeMapping) {
                NodeMapping b = (NodeMapping)other;
                return b.leftNode == this.leftNode && b.rightNode == this.rightNode && b.join == this.join;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.leftNode, this.rightNode, this.join);
        }
    }

    class PathVisitor
    implements FormulaVisitor {
        protected ShowlPropertyShape propertyShape;
        private ShowlPropertyShape prior;
        private int depth = 0;

        public PathVisitor(ShowlPropertyShape propertyShape) {
            this.propertyShape = propertyShape;
        }

        public ShowlPropertyShape getLast() {
            return this.prior;
        }

        @Override
        public void enter(Formula formula) {
            if (formula instanceof HasPathStep) {
                this.enterHasPathStep();
            }
            if (formula instanceof PathExpression) {
                PathExpression path = (PathExpression)formula;
                ShowlNodeShape declaringShape = this.targetShape();
                if (logger.isTraceEnabled()) {
                    logger.debug("PathVisitor.enter(declaringShape: {}, formula: {}", (Object)declaringShape.getPath(), (Object)((PathExpression)formula).simpleText());
                }
                String shapeIdValue = declaringShape.getShape().getId().stringValue();
                this.prior = null;
                List<PathStep> stepList = path.getStepList();
                for (int i = 0; i < stepList.size(); ++i) {
                    ShowlNodeShape valueShape;
                    PathStep step = stepList.get(i);
                    if (step instanceof DirectionStep) {
                        DirectionStep dirStep = (DirectionStep)step;
                        URI predicate = dirStep.getTerm().getIri();
                        ShowlProperty property = ShowlManager.this.produceShowlProperty(predicate);
                        ShowlNodeShape parentShape = null;
                        ShowlInwardPropertyShape thisStep = null;
                        shapeIdValue = shapeIdValue + dirStep.getDirection().getSymbol() + predicate.getLocalName();
                        switch (dirStep.getDirection()) {
                            case OUT: {
                                ShowlPropertyShape p;
                                ShowlClass prevClass;
                                DirectionStep prevStep;
                                ShowlClass owlClass;
                                if (i == 0) {
                                    parentShape = dirStep.getTerm() instanceof VariableTerm ? this.varRoot(dirStep.getTerm()) : declaringShape;
                                } else {
                                    owlClass = property.inferDomain(ShowlManager.this.showlFactory);
                                    prevStep = path.directionStepBefore(i);
                                    prevClass = this.valueClassOf(prevStep);
                                    owlClass = ShowlManager.this.theMostSpecificClass(owlClass, prevClass);
                                    parentShape = this.createNodeShape(this.prior, shapeIdValue, owlClass);
                                }
                                thisStep = p = this.outwardProperty(parentShape, property, i);
                                break;
                            }
                            case IN: {
                                ShowlPropertyShape p;
                                ShowlClass prevClass;
                                DirectionStep prevStep;
                                ShowlClass owlClass;
                                if (i == 0) {
                                    parentShape = declaringShape;
                                } else {
                                    owlClass = property.inferRange(ShowlManager.this.showlFactory);
                                    prevStep = path.directionStepBefore(i);
                                    prevClass = this.valueClassOf(prevStep);
                                    owlClass = ShowlManager.this.theMostSpecificClass(owlClass, prevClass);
                                    parentShape = this.createNodeShape(this.prior, shapeIdValue, owlClass);
                                }
                                thisStep = p = this.inwardProperty(parentShape, property);
                            }
                        }
                        this.prior = thisStep;
                        continue;
                    }
                    if (this.prior == null) {
                        ShowlManager.this.error("Top-level filter not supported");
                    }
                    if ((valueShape = this.prior.getValueShape()) == null) {
                        ShowlProperty property = ShowlManager.this.produceShowlProperty(this.prior.getPredicate());
                        ShowlClass owlClass = property.inferRange(ShowlManager.this.showlFactory);
                        valueShape = this.createNodeShape(this.prior, shapeIdValue, owlClass);
                        this.prior.setValueShape(valueShape);
                    }
                    this.buildHasStep(this.prior, (HasPathStep)step);
                }
                this.setPeer();
            }
        }

        private ShowlNodeShape varRoot(PathTerm term) {
            URI predicate = term.getIri();
            ShowlPropertyShape p = this.propertyShape;
            while (p != null) {
                ShowlNodeShape node = p.getDeclaringShape();
                Shape shape = node.getShape();
                if (shape == null) {
                    ShowlManager.this.fail("Declaring Shape is null at {0}", new Object[]{p.getPath()});
                }
                if (shape.getVariableById(predicate) != null) {
                    return node;
                }
                p = node.getAccessor();
            }
            ShowlManager.this.fail("Root node for ?{0} not found in formula of {1}", new Object[]{predicate.getLocalName(), this.propertyShape.getPath()});
            return null;
        }

        private void enterHasPathStep() {
            ++this.depth;
        }

        protected void setPeer() {
            QuantifiedExpression formula;
            if (this.depth == 0 && this.prior != null && (formula = this.propertyShape.getPropertyConstraint().getFormula()).asPrimaryExpression() instanceof PathExpression) {
                this.propertyShape.addPeer(this.prior);
                ShowlManager.this.addExpression(this.propertyShape, this.prior);
                ShowlManager.this.addExpression(this.prior, this.propertyShape);
            }
        }

        protected ShowlNodeShape targetShape() {
            return this.propertyShape.getDeclaringShape();
        }

        private void buildHasStep(ShowlPropertyShape p, HasPathStep step) {
            if (logger.isDebugEnabled()) {
                logger.debug("buildHasStep(propertyShape: {}, step: {})", (Object)p.getPath(), (Object)step.toSimpleString());
            }
            for (PredicateObjectList pol : step.getConstraints()) {
                PathExpression path = pol.getPath();
                HasPathVisitor predicateVisitor = new HasPathVisitor(p);
                path.dispatch(predicateVisitor);
                ShowlPropertyShape last = predicateVisitor.getLast();
                for (Expression e : pol.getObjectList().getExpressions()) {
                    PrimaryExpression primary = e.asPrimaryExpression();
                    if (primary == null) {
                        ShowlManager.this.error("Expression not supported");
                    }
                    if (primary instanceof IriValue) {
                        IriValue value = (IriValue)primary;
                        URI iri = value.getIri();
                        last.addHasValueDeprecated((Value)iri);
                        continue;
                    }
                    if (!(primary instanceof LiteralFormula)) continue;
                    LiteralFormula formula = (LiteralFormula)primary;
                    last.addHasValueDeprecated((Value)formula.getLiteral());
                }
            }
        }

        private ShowlInwardPropertyShape inwardProperty(ShowlNodeShape parentShape, ShowlProperty property) {
            ShowlInwardPropertyShape prior = parentShape.getInwardProperty(property.getPredicate());
            if (prior != null) {
                return prior;
            }
            ShowlInwardPropertyShape p = new ShowlInwardPropertyShape(parentShape, property);
            parentShape.addInwardProperty(p);
            return p;
        }

        private ShowlPropertyShape outwardProperty(ShowlNodeShape parentShape, ShowlProperty property, int i) {
            ShowlPropertyShape prior = parentShape.findProperty(property.getPredicate());
            if (prior != null) {
                return prior;
            }
            PropertyConstraint c = null;
            if (i == 0) {
                c = new PropertyConstraint(property.getPredicate());
                c.setNodeKind(this.propertyShape.getNodeKind());
            }
            ShowlOutwardPropertyShape p = new ShowlOutwardPropertyShape(parentShape, property, c);
            property.addPropertyShape(p);
            parentShape.addDerivedProperty(p);
            if (logger.isTraceEnabled()) {
                logger.trace("outwardProperty: created {}", (Object)p.getPath());
            }
            return p;
        }

        private ShowlNodeShape createNodeShape(ShowlPropertyShape accessor, String shapeIdValue, ShowlClass owlClass) {
            ShowlNodeShape nestedShape;
            ShowlNodeShape value = accessor.getValueShape();
            if (value != null) {
                return value;
            }
            URIImpl shapeId = new URIImpl(shapeIdValue);
            Shape shape = new Shape((Resource)shapeId);
            NodeKind kind = accessor.getNodeKind();
            if (kind == null && (nestedShape = accessor.getValueShape()) != null) {
                kind = nestedShape.getNodeKind();
            }
            shape.setNodeKind(kind);
            ShowlNodeShape node = ShowlManager.this.createShowlNodeShape(accessor, shape, owlClass);
            if (kind == NodeKind.IRI) {
                ShowlProperty konigId = ShowlManager.this.produceShowlProperty(Konig.id);
                ShowlIdRefPropertyShape p = new ShowlIdRefPropertyShape(node, konigId, this.propertyShape);
                node.addDerivedProperty(p);
            }
            return node;
        }

        private ShowlClass valueClassOf(DirectionStep step) {
            if (step != null) {
                ShowlProperty property = ShowlManager.this.produceShowlProperty(step.getTerm().getIri());
                switch (step.getDirection()) {
                    case OUT: {
                        return property.inferRange(ShowlManager.this.showlFactory);
                    }
                    case IN: {
                        return property.inferDomain(ShowlManager.this.showlFactory);
                    }
                }
            }
            return ShowlManager.this.produceOwlClass(Konig.Undefined);
        }

        @Override
        public void exit(Formula formula) {
            if (formula instanceof HasPathStep) {
                --this.depth;
            }
        }
    }

    class HasPathVisitor
    extends PathVisitor {
        public HasPathVisitor(ShowlPropertyShape propertyShape) {
            super(propertyShape);
        }

        @Override
        protected ShowlNodeShape targetShape() {
            return this.propertyShape.getValueShape();
        }

        @Override
        protected void setPeer() {
        }
    }
}

