/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.showl.ShowlJoinCondition;
import io.konig.core.showl.ShowlPropertyShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowlMapping {
    private static final Logger logger = LoggerFactory.getLogger(ShowlMapping.class);
    private ShowlJoinCondition joinCondition;
    private ShowlPropertyShape leftProperty;
    private ShowlPropertyShape rightProperty;

    public ShowlMapping(ShowlJoinCondition joinCondition, ShowlPropertyShape leftProperty, ShowlPropertyShape rightProperty) {
        this.joinCondition = joinCondition;
        this.leftProperty = leftProperty;
        this.rightProperty = rightProperty;
        leftProperty.addMapping(this);
        rightProperty.addMapping(this);
        if (logger.isTraceEnabled()) {
            logger.trace("new ShowlMapping {}...{}", (Object)leftProperty.getPath(), (Object)rightProperty.getPath());
        }
    }

    public ShowlJoinCondition getJoinCondition() {
        return this.joinCondition;
    }

    public ShowlPropertyShape getLeftProperty() {
        return this.leftProperty;
    }

    public ShowlPropertyShape getRightProperty() {
        return this.rightProperty;
    }

    public ShowlPropertyShape findOther(ShowlPropertyShape p) {
        return p == this.leftProperty ? this.rightProperty : (p == this.rightProperty ? this.leftProperty : null);
    }

    public String toString() {
        return "ShowlMapping(" + this.leftProperty.getPath() + "..." + this.rightProperty.getPath() + ")";
    }
}

