/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.Context;
import io.konig.core.OwlReasoner;
import io.konig.core.impl.RdfUtil;
import io.konig.core.showl.ShowlChannel;
import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlDataSource;
import io.konig.core.showl.ShowlDerivedPropertyList;
import io.konig.core.showl.ShowlDerivedPropertyShape;
import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlEffectiveNodeShape;
import io.konig.core.showl.ShowlEnumNodeExpression;
import io.konig.core.showl.ShowlEqualStatement;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlFromCondition;
import io.konig.core.showl.ShowlInwardPropertyShape;
import io.konig.core.showl.ShowlJoinCondition;
import io.konig.core.showl.ShowlManager;
import io.konig.core.showl.ShowlMapping;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlProperty;
import io.konig.core.showl.ShowlPropertyExpression;
import io.konig.core.showl.ShowlPropertyPath;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlStatement;
import io.konig.core.showl.ShowlStaticPropertyShape;
import io.konig.core.showl.ShowlTemplatePropertyShape;
import io.konig.core.showl.ShowlUniqueKeyCollection;
import io.konig.core.showl.ShowlUtil;
import io.konig.core.showl.StaticDataSource;
import io.konig.core.showl.SynsetNode;
import io.konig.core.showl.Traversable;
import io.konig.core.util.IriTemplate;
import io.konig.core.util.ValueFormat;
import io.konig.core.vocab.Konig;
import io.konig.shacl.NodeKind;
import io.konig.shacl.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class ShowlNodeShape
implements Traversable {
    private ShowlPropertyShape accessor;
    private ShowlClass owlClass;
    private Shape shape;
    private Map<URI, ShowlDirectPropertyShape> properties = new HashMap<URI, ShowlDirectPropertyShape>();
    private Map<URI, ShowlDerivedPropertyList> derivedProperties = new HashMap<URI, ShowlDerivedPropertyList>();
    private Map<URI, ShowlInwardPropertyShape> inProperties = null;
    private List<ShowlJoinCondition> selectedJoins;
    private ShowlDataSource shapeDataSource;
    private List<ShowlChannel> channelList;
    private ShowlPropertyShape targetProperty;
    private ShowlStatement joinStatement;
    private ShowlNodeShape targetNode;
    private ShowlEffectiveNodeShape effectiveNode;
    private SynsetNode synsetNode;
    private ShowlUniqueKeyCollection uniqueKeyCollection;
    private ShowlManager manager;
    @Deprecated
    private ShowlNodeShape logicalNodeShape;

    public ShowlNodeShape(ShowlPropertyShape accessor, Shape shape, ShowlClass owlClass) {
        this(null, accessor, shape, owlClass);
    }

    public ShowlNodeShape(ShowlManager manager, ShowlPropertyShape accessor, Shape shape, ShowlClass owlClass) {
        this.manager = manager;
        this.accessor = accessor;
        this.shape = shape;
        this.owlClass = owlClass;
        if (accessor != null) {
            accessor.setValueShape(this);
        }
    }

    public ShowlManager getShowlManager() {
        return this.manager;
    }

    public ShowlEffectiveNodeShape getEffectiveNode() {
        return this.effectiveNode;
    }

    public SynsetNode synsetNode() {
        if (this.synsetNode == null) {
            this.synsetNode = new SynsetNode(this);
        }
        return this.synsetNode;
    }

    public ShowlEffectiveNodeShape effectiveNode() {
        if (this.effectiveNode == null) {
            this.effectiveNode = this.accessor == null ? ShowlEffectiveNodeShape.forNode(this) : ShowlEffectiveNodeShape.fromRoot(this);
        }
        return this.effectiveNode;
    }

    public boolean isStaticEnumShape() {
        return this.shapeDataSource != null && this.shapeDataSource.getDataSource() instanceof StaticDataSource;
    }

    public ShowlPropertyShape keyProperty(ShowlNodeShape sourceNode, ShowlJoinCondition join) {
        if (join instanceof ShowlFromCondition) {
            for (ShowlJoinCondition j : this.getSelectedJoins()) {
                ShowlNodeShape otherNode;
                if (j == join || (otherNode = j.otherNode(sourceNode)) == null) continue;
                return j.propertyOf(sourceNode);
            }
        } else {
            return join.propertyOf(sourceNode);
        }
        return null;
    }

    public Set<ShowlPropertyShape> joinProperties(ShowlNodeShape otherNode) throws ShowlProcessingException {
        HashSet<ShowlPropertyShape> set = new HashSet<ShowlPropertyShape>();
        for (ShowlDirectPropertyShape p : this.getProperties()) {
            if (p.getValueShape() != null) {
                Set<ShowlPropertyShape> nested = p.getValueShape().joinProperties(otherNode);
                set.addAll(nested);
                continue;
            }
            ShowlMapping mapping = p.getSelectedMapping();
            if (mapping == null) {
                throw new ShowlProcessingException("Mapping not found for " + p.getPath());
            }
            ShowlPropertyShape otherProperty = mapping.findOther(p);
            if (otherNode != otherProperty.getDeclaringShape()) continue;
            this.addMappedProperty(set, otherProperty, p);
        }
        return set;
    }

    public Set<ShowlPropertyShape> joinProperties(ShowlJoinCondition join) throws ShowlProcessingException {
        HashSet<ShowlPropertyShape> set = new HashSet<ShowlPropertyShape>();
        if (join instanceof ShowlFromCondition) {
            ShowlFromCondition from = (ShowlFromCondition)join;
            join = from.getDerivedFrom();
        }
        for (ShowlDirectPropertyShape p : this.getProperties()) {
            ShowlMapping mapping = p.getSelectedMapping();
            if (mapping == null) {
                throw new ShowlProcessingException("Mapping not found for " + p.getPath());
            }
            if (mapping.getJoinCondition() != join) continue;
            ShowlPropertyShape other = mapping.findOther(p);
            this.addMappedProperty(set, other, p);
        }
        return set;
    }

    private void addMappedProperty(Set<ShowlPropertyShape> set, ShowlPropertyShape other, ShowlPropertyShape target) {
        if (other instanceof ShowlDirectPropertyShape || other instanceof ShowlStaticPropertyShape || other.getValueShape() != null) {
            set.add(other);
            return;
        }
        ShowlPropertyShape peer = other.getPeer();
        if (peer instanceof ShowlDirectPropertyShape) {
            set.add(other);
            return;
        }
        if (other instanceof ShowlTemplatePropertyShape) {
            this.addTemplateParameters(set, (ShowlTemplatePropertyShape)other, target);
            return;
        }
        throw new ShowlProcessingException("Mapping not supported for " + target.getPath());
    }

    public ShowlPropertyShape enumSourceKey() throws ShowlProcessingException {
        ShowlExpression accessorExpression;
        if (this.accessor != null && (accessorExpression = this.accessor.getSelectedExpression()) instanceof ShowlEnumNodeExpression) {
            ShowlPropertyShape key;
            ShowlNodeShape enumNode = ((ShowlEnumNodeExpression)accessorExpression).getEnumNode();
            ShowlChannel channel = ShowlUtil.channelFor(enumNode, this.getRoot().getChannels());
            ShowlStatement join = channel.getJoinStatement();
            if (join instanceof ShowlEqualStatement && (key = ShowlUtil.propertyOf((ShowlEqualStatement)join, enumNode)) != null) {
                return key;
            }
            throw new ShowlProcessingException("Failed to get enum source key: " + this.getPath());
        }
        return null;
    }

    private ShowlPropertyShape otherProperty(ShowlEqualStatement equals, ShowlNodeShape declaringShape) {
        if (equals != null) {
            ShowlPropertyShape p = this.propertyOf(declaringShape, equals.getLeft());
            if (p == null) {
                p = this.propertyOf(declaringShape, equals.getRight());
            }
            return p;
        }
        return null;
    }

    private ShowlPropertyShape propertyOf(ShowlNodeShape declaringShape, ShowlExpression e) {
        ShowlPropertyShape p;
        if (e instanceof ShowlPropertyExpression && (p = ((ShowlPropertyExpression)e).getSourceProperty()).getDeclaringShape() != declaringShape) {
            return p;
        }
        return null;
    }

    private void addTemplateParameters(Set<ShowlPropertyShape> set, ShowlTemplatePropertyShape other, ShowlPropertyShape target) {
        IriTemplate template = other.getTemplate();
        Context context = template.getContext();
        ShowlNodeShape node = other.getDeclaringShape();
        for (ValueFormat.Element element : template.toList()) {
            if (element.getType() != ValueFormat.ElementType.VARIABLE) continue;
            URIImpl varId = new URIImpl(context.expandIRI(element.getText()));
            List<ShowlPropertyShape> outSet = node.out((URI)varId);
            for (ShowlPropertyShape p : outSet) {
                this.addMappedProperty(set, p, target);
            }
        }
    }

    public void addInwardProperty(ShowlInwardPropertyShape p) {
        if (this.inProperties == null) {
            this.inProperties = new HashMap<URI, ShowlInwardPropertyShape>();
        }
        this.inProperties.put(p.getPredicate(), p);
    }

    public ShowlInwardPropertyShape getInwardProperty(URI predicate) {
        return this.inProperties == null ? null : this.inProperties.get(predicate);
    }

    public Collection<ShowlInwardPropertyShape> getInwardProperties() {
        return this.inProperties == null ? Collections.emptyList() : this.inProperties.values();
    }

    @Deprecated
    public boolean isNamedRoot() {
        return this.accessor == null && this.findProperty(Konig.id) != null && this.hasDataSource();
    }

    public Collection<ShowlDirectPropertyShape> getProperties() {
        return this.properties.values();
    }

    public Set<ShowlPropertyShape> allOutwardProperties() {
        HashSet<ShowlPropertyShape> set = new HashSet<ShowlPropertyShape>();
        set.addAll(this.getProperties());
        for (List list : this.getDerivedProperties()) {
            set.addAll(list);
        }
        return set;
    }

    public void addProperty(ShowlDirectPropertyShape p) {
        this.properties.put(p.getPredicate(), p);
    }

    public ShowlDirectPropertyShape getProperty(URI predicate) {
        return this.properties.get(predicate);
    }

    public ShowlDerivedPropertyList getDerivedProperty(URI predicate) {
        ShowlDerivedPropertyList list = this.derivedProperties.get(predicate);
        return list == null ? new ShowlDerivedPropertyList(predicate) : list;
    }

    public Resource getId() {
        return this.shape.getId();
    }

    public Shape getShape() {
        return this.shape;
    }

    public ShowlClass getOwlClass() {
        return this.owlClass;
    }

    public boolean hasDataSource() {
        return this.shape != null && !this.shape.getShapeDataSource().isEmpty();
    }

    public void setOwlClass(ShowlClass owlClass) {
        this.owlClass = owlClass;
    }

    public boolean hasAncestor(Resource shapeId) {
        if (this.shape.getId().equals(shapeId)) {
            return true;
        }
        if (this.accessor != null) {
            return this.accessor.getDeclaringShape().hasAncestor(shapeId);
        }
        return false;
    }

    public ShowlPropertyShape getAccessor() {
        return this.accessor;
    }

    public void addDerivedProperty(ShowlDerivedPropertyShape p) {
        ShowlDerivedPropertyList list = this.derivedProperties.get(p.getPredicate());
        if (list == null) {
            list = new ShowlDerivedPropertyList(p.getPredicate());
            this.derivedProperties.put(p.getPredicate(), list);
        }
        list.add(p);
    }

    public ShowlPropertyShape findOut(URI predicate) {
        ShowlPropertyShape p = this.properties.get(predicate);
        if (p != null) {
            return p;
        }
        ShowlDerivedPropertyList indirect = this.derivedProperties.get(predicate);
        if (indirect != null) {
            return indirect.unfiltered();
        }
        return null;
    }

    public List<ShowlPropertyShape> out(URI predicate) {
        ShowlDirectPropertyShape direct = this.properties.get(predicate);
        ShowlDerivedPropertyList indirect = this.derivedProperties.get(predicate);
        if (direct == null && indirect == null) {
            return Collections.emptyList();
        }
        ArrayList<ShowlPropertyShape> list = new ArrayList<ShowlPropertyShape>();
        if (direct != null) {
            list.add(direct);
        }
        if (indirect != null) {
            list.addAll(indirect);
        }
        return list;
    }

    @Deprecated
    public ShowlPropertyShape findProperty(URI predicate) {
        List list;
        ShowlPropertyShape p = this.getProperty(predicate);
        if (p == null && (list = (List)this.derivedProperties.get(predicate)) != null && list.size() == 1) {
            p = (ShowlPropertyShape)list.get(0);
        }
        return p;
    }

    public Collection<ShowlDerivedPropertyList> getDerivedProperties() {
        return this.derivedProperties.values();
    }

    @Override
    public String getPath() {
        if (this.accessor == null) {
            return "{" + RdfUtil.localName(this.shape.getId()) + "}";
        }
        return this.accessor.getPath();
    }

    public String toString() {
        return this.getPath();
    }

    public ShowlNodeShape getRoot() {
        if (this.accessor == null) {
            return this;
        }
        return this.accessor.getDeclaringShape().getRoot();
    }

    public void addSelectedJoin(ShowlJoinCondition join) {
        if (this.selectedJoins == null) {
            this.selectedJoins = new ArrayList<ShowlJoinCondition>();
        }
        this.selectedJoins.add(join);
    }

    public List<ShowlJoinCondition> getSelectedJoins() {
        return this.selectedJoins == null ? Collections.emptyList() : this.selectedJoins;
    }

    public NodeKind getNodeKind() {
        return this.shape == null ? null : this.shape.getNodeKind();
    }

    public ShowlStaticPropertyShape staticProperty(ShowlProperty property) {
        URI predicate = property.getPredicate();
        ShowlDerivedPropertyList list = this.derivedProperties.get(predicate);
        if (list != null) {
            for (ShowlDerivedPropertyShape p : list) {
                if (!(p instanceof ShowlStaticPropertyShape)) continue;
                return (ShowlStaticPropertyShape)p;
            }
        }
        if (list == null) {
            list = new ShowlDerivedPropertyList(predicate);
            this.derivedProperties.put(predicate, list);
        }
        ShowlStaticPropertyShape p = new ShowlStaticPropertyShape(this, property);
        list.add(p);
        return p;
    }

    public ShowlDataSource getShapeDataSource() {
        return this.shapeDataSource;
    }

    public void setShapeDataSource(ShowlDataSource shapeDataSource) {
        this.shapeDataSource = shapeDataSource;
    }

    public void addChannel(ShowlChannel channel) {
        if (this.channelList == null) {
            this.channelList = new ArrayList<ShowlChannel>();
        }
        this.channelList.add(channel);
    }

    public List<ShowlChannel> nonEnumChannels(OwlReasoner reasoner) {
        ArrayList<ShowlChannel> list = null;
        for (ShowlChannel c : this.getChannels()) {
            ShowlNodeShape sourceNode = c.getSourceNode();
            if (reasoner.isEnumerationClass((Resource)sourceNode.getOwlClass().getId())) continue;
            if (list == null) {
                list = new ArrayList<ShowlChannel>();
            }
            list.add(c);
        }
        return list == null ? Collections.emptyList() : list;
    }

    public List<ShowlChannel> getChannels() {
        return this.channelList == null ? Collections.emptyList() : this.channelList;
    }

    public List<ShowlPropertyShape> selectedPropertiesOf(ShowlNodeShape sourceNodeShape) {
        HashSet<ShowlPropertyShape> set = new HashSet<ShowlPropertyShape>();
        HashSet<ShowlStatement> statements = new HashSet<ShowlStatement>();
        sourceNodeShape = sourceNodeShape.getRoot();
        this.addSelectedProperties(statements, set, this, sourceNodeShape);
        this.addJoinProperties(set, sourceNodeShape);
        Iterator sequence = set.iterator();
        while (sequence.hasNext()) {
            ShowlPropertyShape p = (ShowlPropertyShape)sequence.next();
            if (p.getValueShape() == null) continue;
            sequence.remove();
        }
        ArrayList<ShowlPropertyShape> list = new ArrayList<ShowlPropertyShape>(set);
        Collections.sort(list, new Comparator<ShowlPropertyShape>(){

            @Override
            public int compare(ShowlPropertyShape a, ShowlPropertyShape b) {
                return a.getPredicate().getLocalName().compareTo(b.getPredicate().getLocalName());
            }
        });
        return list;
    }

    private void addJoinProperties(Set<ShowlPropertyShape> set, ShowlNodeShape sourceNodeShape) {
        for (ShowlChannel channel : this.getChannels()) {
            ShowlStatement statement = channel.getJoinStatement();
            if (statement == null) continue;
            statement.addDeclaredProperties(sourceNodeShape, set);
        }
    }

    private void addSelectedProperties(Set<ShowlStatement> statements, Set<ShowlPropertyShape> set, ShowlNodeShape targetNodeShape, ShowlNodeShape sourceNodeShape) {
        for (ShowlDirectPropertyShape direct : targetNodeShape.getProperties()) {
            ShowlExpression e = direct.getSelectedExpression();
            if (e != null) {
                ShowlPropertyShape p;
                ShowlStatement statement;
                e.addDeclaredProperties(sourceNodeShape, set);
                if (e instanceof ShowlPropertyExpression && (statement = (p = ((ShowlPropertyExpression)e).getSourceProperty()).getDeclaringShape().getJoinStatement()) != null && !statements.contains(statement)) {
                    statements.add(statement);
                    statement.addDeclaredProperties(sourceNodeShape, set);
                }
            }
            if (direct.getValueShape() == null) continue;
            this.addSelectedProperties(statements, set, direct.getValueShape(), sourceNodeShape);
        }
    }

    public ShowlPropertyShape getTargetProperty() {
        return this.targetProperty != null ? this.targetProperty : (this.targetNode != null ? this.targetNode.getAccessor() : null);
    }

    public void setTargetProperty(ShowlPropertyShape targetProperty) {
        this.targetProperty = targetProperty;
    }

    public ShowlNodeShape getLogicalNodeShape() {
        return this.logicalNodeShape;
    }

    public void setLogicalNodeShape(ShowlNodeShape logicalNodeShape) {
        this.logicalNodeShape = logicalNodeShape;
    }

    public ShowlStatement getJoinStatement() {
        return this.joinStatement;
    }

    public void setJoinStatement(ShowlStatement joinStatement) {
        this.joinStatement = joinStatement;
    }

    public ShowlNodeShape getTargetNode() {
        return this.targetNode;
    }

    public void setTargetNode(ShowlNodeShape targetNode) {
        this.targetNode = targetNode;
    }

    public boolean isTargetNode() {
        if (this.targetNode != null || this.targetProperty != null) {
            return false;
        }
        if (this.accessor != null) {
            return this.getRoot().isTargetNode();
        }
        return true;
    }

    public List<ShowlPropertyShape> path() {
        if (this.accessor == null) {
            return new ShowlPropertyPath();
        }
        return this.accessor.propertyPath();
    }

    public boolean encapsulates(ShowlPropertyShape p) {
        Resource thisId = this.getId();
        while (p != null) {
            if (p.getDeclaringShape().getId().equals(thisId)) {
                return true;
            }
            p = p.getDeclaringShape().getAccessor();
        }
        return false;
    }

    public ShowlChannel findChannelFor(ShowlNodeShape node) {
        if (this.channelList != null) {
            Resource nodeId = node.getId();
            for (ShowlChannel channel : this.channelList) {
                if (!channel.getSourceNode().getId().equals(nodeId)) continue;
                return channel;
            }
        }
        return null;
    }

    public ShowlUniqueKeyCollection getUniqueKeyCollection() {
        return this.uniqueKeyCollection;
    }

    public void setUniqueKeyCollection(ShowlUniqueKeyCollection uniqueKeyCollection) {
        this.uniqueKeyCollection = uniqueKeyCollection;
    }
}

