/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.impl.RdfUtil;
import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlDerivedPropertyExpression;
import io.konig.core.showl.ShowlDerivedPropertyShape;
import io.konig.core.showl.ShowlDirectPropertyExpression;
import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlFunctionExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlNodeShapeService;
import io.konig.core.showl.ShowlOutwardPropertyShape;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlProperty;
import io.konig.core.showl.ShowlPropertyExpression;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlSchemaService;
import io.konig.core.showl.ShowlTeleportExpression;
import io.konig.core.showl.expression.ShowlExpressionBuilder;
import io.konig.core.vocab.Konig;
import io.konig.formula.QuantifiedExpression;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PredicatePath;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.PropertyPath;
import io.konig.shacl.SequencePath;
import io.konig.shacl.Shape;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.XMLSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowlNodeShapeBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ShowlNodeShapeBuilder.class);
    private ShowlSchemaService schemaService;
    private ShowlNodeShapeService nodeService;
    private boolean recursive = true;

    public ShowlNodeShapeBuilder(ShowlSchemaService schemaService, ShowlNodeShapeService nodeService) {
        this.schemaService = schemaService;
        this.nodeService = nodeService;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public ShowlNodeShape buildNodeShape(ShowlPropertyShape accessor, Shape shape) throws ShowlProcessingException {
        if (logger.isTraceEnabled()) {
            if (accessor == null) {
                logger.trace("buildNodeShape({})", (Object)RdfUtil.localName(shape.getId()));
            } else {
                logger.trace("buildNodeShape(accessor={}, shape={}", (Object)accessor.getPath(), (Object)RdfUtil.localName(shape.getId()));
            }
        }
        ShowlClass owlClass = this.targetOwlClass(accessor, shape);
        ShowlNodeShape node = new ShowlNodeShape(accessor, shape, owlClass);
        this.addProperties(node);
        return node;
    }

    public boolean isEnumClass(Resource targetClass) {
        return targetClass == null ? false : this.schemaService.getOwlReasoner().isEnumerationClass(targetClass);
    }

    private void addProperties(ShowlNodeShape node) {
        if (logger.isTraceEnabled()) {
            logger.trace("addProperties({})", (Object)node.getPath());
        }
        for (PropertyConstraint c : node.getShape().getProperty()) {
            this.addDirectProperty(node, c.getPredicate(), c);
        }
        this.addDirectSequencePaths(node);
        this.processFormulas(node);
        for (PropertyConstraint c : node.getShape().getDerivedProperty()) {
            this.addDerivedProperty(node, c);
        }
        this.addIdProperty(node);
    }

    private void addDirectSequencePaths(ShowlNodeShape node) {
        for (PropertyConstraint c : node.getShape().getProperty()) {
            PropertyPath path = c.getPath();
            if (!(path instanceof SequencePath)) continue;
            this.addDirectSequencePath(node, c, (SequencePath)path);
        }
    }

    private void addDirectSequencePath(ShowlNodeShape node, PropertyConstraint c, SequencePath path) {
        ShowlNodeShape focusNode = node;
        String shapeIdValue = node.getShape().getId().stringValue();
        ShowlDirectPropertyShape last = null;
        int end = path.size() - 1;
        for (int i = 0; i <= end; ++i) {
            PropertyPath element = (PropertyPath)path.get(i);
            if (element instanceof PredicatePath) {
                URI predicate = ((PredicatePath)element).getPredicate();
                ShowlProperty property = this.schemaService.produceProperty(predicate);
                ShowlDirectPropertyShape p = node.getProperty(predicate);
                if (p == null) {
                    p = new ShowlDirectPropertyShape(node, property, null);
                    property.addPropertyShape(p);
                    node.addProperty(p);
                }
                last = p;
                if (logger.isTraceEnabled()) {
                    logger.trace("addDirectSequencePath: {}", (Object)p.getPath());
                }
                if (i >= end) continue;
                ShowlNodeShape valueShape = p.getValueShape();
                if (valueShape == null) {
                    shapeIdValue = shapeIdValue + '.' + predicate.getLocalName();
                    URIImpl shapeId = new URIImpl(shapeIdValue);
                    Shape shape = new Shape((Resource)shapeId);
                    valueShape = new ShowlNodeShape(p, shape, null);
                    p.setValueShape(valueShape);
                }
                node = valueShape;
                continue;
            }
            throw new ShowlProcessingException("Nested SequencePath not supported");
        }
        if (c.getFormula() != null) {
            QuantifiedExpression formula = c.getFormula();
            ShowlExpressionBuilder builder = new ShowlExpressionBuilder(this.schemaService, this.nodeService);
            ShowlExpression ex = builder.expression(node.getAccessor(), formula);
            last.setFormula(new ShowlTeleportExpression(focusNode, ex));
        }
    }

    private void processFormulas(ShowlNodeShape node) {
        for (ShowlDirectPropertyShape direct : node.getProperties()) {
            this.processFormula(direct);
            if (direct.getValueShape() == null) continue;
            this.processFormulas(direct.getValueShape());
        }
    }

    private void addIdProperty(ShowlNodeShape declaringShape) {
        if (declaringShape.getShape().getIriTemplate() != null) {
            ShowlProperty property = this.schemaService.produceProperty(Konig.id);
            ShowlOutwardPropertyShape out = new ShowlOutwardPropertyShape(declaringShape, property);
            out.setFormula(ShowlFunctionExpression.fromIriTemplate(this.schemaService, this.nodeService, out, declaringShape.getShape().getIriTemplate()));
            declaringShape.addDerivedProperty(out);
        } else if (declaringShape.getShape().getNodeKind() == NodeKind.IRI) {
            PropertyConstraint c = new PropertyConstraint(Konig.id);
            c.setMinCount(1);
            c.setMaxCount(1);
            c.setDatatype(XMLSchema.ANYURI);
            this.addDirectProperty(declaringShape, Konig.id, c);
        }
    }

    private void addDerivedProperty(ShowlNodeShape node, PropertyConstraint c) {
        URI predicate = c.getPredicate();
        if (predicate != null) {
            ShowlProperty property = this.schemaService.produceProperty(predicate);
            ShowlOutwardPropertyShape p = new ShowlOutwardPropertyShape(node, property, c);
            property.addPropertyShape(p);
            node.addDerivedProperty(p);
            if (logger.isTraceEnabled()) {
                logger.trace("addDerivedProperty: {}", (Object)p.getPath());
            }
            this.processFormula(p);
            if (this.recursive && c.getShape() != null) {
                this.buildNodeShape(p, c.getShape());
            }
        } else {
            PropertyPath path = c.getPath();
            if (path instanceof SequencePath) {
                this.addSequencePath(node, c, (SequencePath)path);
            }
        }
    }

    private void addSequencePath(ShowlNodeShape node, PropertyConstraint c, SequencePath path) {
        ShowlNodeShape focusNode = node;
        String shapeIdValue = node.getShape().getId().stringValue();
        ShowlPropertyShape last = null;
        int end = path.size() - 1;
        for (int i = 0; i <= end; ++i) {
            PropertyPath element = (PropertyPath)path.get(i);
            if (element instanceof PredicatePath) {
                URI predicate = ((PredicatePath)element).getPredicate();
                ShowlProperty property = this.schemaService.produceProperty(predicate);
                ShowlOutwardPropertyShape p = new ShowlOutwardPropertyShape(node, property, null);
                property.addPropertyShape(p);
                node.addDerivedProperty(p);
                last = p;
                if (logger.isTraceEnabled()) {
                    logger.trace("addSequencePath: {}", (Object)p.getPath());
                }
                if (i >= end) continue;
                shapeIdValue = shapeIdValue + '.' + predicate.getLocalName();
                URIImpl shapeId = new URIImpl(shapeIdValue);
                Shape shape = new Shape((Resource)shapeId);
                node = new ShowlNodeShape(p, shape, null);
                p.setValueShape(node);
                continue;
            }
            throw new ShowlProcessingException("Nested SequencePath not supported");
        }
        if (c.getFormula() != null) {
            QuantifiedExpression formula = c.getFormula();
            ShowlExpressionBuilder builder = new ShowlExpressionBuilder(this.schemaService, this.nodeService);
            ShowlExpression ex = builder.expression(node.getAccessor(), formula);
            last.setFormula(new ShowlTeleportExpression(focusNode, ex));
        }
    }

    private void addDirectProperty(ShowlNodeShape node, URI predicate, PropertyConstraint c) {
        if (predicate != null) {
            ShowlProperty property = this.schemaService.produceProperty(predicate);
            ShowlDirectPropertyShape direct = new ShowlDirectPropertyShape(node, property, c);
            property.addPropertyShape(direct);
            node.addProperty(direct);
            if (logger.isTraceEnabled()) {
                logger.trace("addDirectProperty: {}", (Object)direct.getPath());
            }
            if (this.recursive && c != null && c.getShape() != null) {
                this.buildNodeShape(direct, c.getShape());
            }
        }
    }

    private void processFormula(ShowlPropertyShape p) {
        PropertyConstraint c = p.getPropertyConstraint();
        if (c != null && c.getFormula() != null) {
            QuantifiedExpression formula = c.getFormula();
            ShowlExpressionBuilder builder = new ShowlExpressionBuilder(this.schemaService, this.nodeService);
            ShowlExpression ex = builder.expression(p, formula);
            p.setFormula(ex);
            if (ex instanceof ShowlPropertyExpression) {
                ShowlPropertyShape synonym = ((ShowlPropertyExpression)ex).getSourceProperty();
                synonym.addExpression(this.propertyExpression(p));
            }
        }
    }

    private ShowlExpression propertyExpression(ShowlPropertyShape p) {
        if (p instanceof ShowlDirectPropertyShape) {
            return new ShowlDirectPropertyExpression((ShowlDirectPropertyShape)p);
        }
        return new ShowlDerivedPropertyExpression((ShowlDerivedPropertyShape)p);
    }

    private ShowlClass targetOwlClass(ShowlPropertyShape accessor, Shape shape) {
        URI targetClass;
        PropertyConstraint p;
        if (accessor != null && (p = accessor.getPropertyConstraint()) != null) {
            if (p.getValueClass() instanceof URI) {
                return this.schemaService.produceShowlClass(RdfUtil.uri((Value)p.getValueClass()));
            }
            if (p.getShape() != null && p.getShape().getTargetClass() != null) {
                return this.schemaService.produceShowlClass(p.getShape().getTargetClass());
            }
        }
        if ((targetClass = shape.getTargetClass()) == null) {
            targetClass = Konig.Undefined;
        }
        return this.schemaService.produceShowlClass(targetClass);
    }
}

