/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.OwlReasoner;
import io.konig.core.showl.ShowlDelegationExpression;
import io.konig.core.showl.ShowlEnumPropertyExpression;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlStatement;
import java.util.ArrayList;
import java.util.Set;
import org.openrdf.model.URI;

public class ShowlOverlayExpression
extends ArrayList<ShowlExpression>
implements ShowlExpression,
ShowlStatement {
    @Override
    public ShowlExpression transform() {
        ShowlOverlayExpression copy = new ShowlOverlayExpression();
        for (ShowlExpression e : this) {
            copy.add(e.transform());
        }
        return copy;
    }

    @Override
    public boolean add(ShowlExpression e) {
        if (e instanceof ShowlDelegationExpression) {
            return false;
        }
        if (e instanceof ShowlEnumPropertyExpression) {
            throw new IllegalArgumentException("Enum property expressions are forbidden in an overlay expression: " + e.displayValue());
        }
        return super.add(e);
    }

    @Override
    public String displayValue() {
        StringBuilder builder = new StringBuilder();
        builder.append("Overlay(");
        String comma = "";
        for (ShowlExpression e : this) {
            builder.append(comma);
            comma = ", ";
            builder.append(e.displayValue());
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public void addDeclaredProperties(ShowlNodeShape sourceNodeShape, Set<ShowlPropertyShape> set) throws ShowlProcessingException {
        for (ShowlExpression e : this) {
            e.addDeclaredProperties(sourceNodeShape, set);
        }
    }

    @Override
    public void addProperties(Set<ShowlPropertyShape> set) {
        for (ShowlExpression e : this) {
            e.addProperties(set);
        }
    }

    @Override
    public URI valueType(OwlReasoner reasoner) {
        return ((ShowlExpression)this.get(0)).valueType(reasoner);
    }
}

