/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlPropertyShape;
import java.util.ArrayList;
import java.util.Collections;
import org.openrdf.model.URI;

public class ShowlPredicatePath
extends ArrayList<URI> {
    private ShowlNodeShape root;

    public ShowlPredicatePath(ShowlNodeShape root) {
        this.root = root;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.root.getPath());
        for (URI predicate : this) {
            builder.append('.');
            builder.append(predicate.getLocalName());
        }
        return builder.toString();
    }

    @Override
    public URI getLast() {
        return (URI)this.get(this.size() - 1);
    }

    public static ShowlPredicatePath forProperty(ShowlPropertyShape p) {
        ShowlPredicatePath result = new ShowlPredicatePath(p.getRootNode());
        while (p != null) {
            result.add(p.getPredicate());
            p = p.getDeclaringShape().getAccessor();
        }
        Collections.reverse(result);
        return result;
    }
}

