/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.KonigException;
import io.konig.core.OwlReasoner;
import io.konig.core.impl.RdfUtil;
import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlSchemaService;
import io.konig.core.vocab.Konig;
import io.konig.formula.Direction;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowlProperty {
    private static final Logger logger = LoggerFactory.getLogger(ShowlProperty.class);
    private URI predicate;
    private ShowlClass domain;
    private ShowlClass range;
    private Set<ShowlProperty> inverses;
    private Set<ShowlPropertyShape> propertyShapes = new HashSet<ShowlPropertyShape>();

    public ShowlProperty(URI predicate) {
        this.predicate = predicate;
    }

    public URI getPredicate() {
        return this.predicate;
    }

    public void addPropertyShape(ShowlPropertyShape p) {
        if (p.getDirection() == Direction.IN) {
            throw new KonigException("addPropertyShape: Inward property not allowed: " + p.getPath());
        }
        this.propertyShapes.add(p);
    }

    public Set<ShowlPropertyShape> getPropertyShapes() {
        return this.propertyShapes;
    }

    public Set<URI> domainIncludes(ShowlSchemaService service) {
        HashSet<URI> result = new HashSet<URI>();
        if (this.domain != null && !Konig.Undefined.equals((Object)this.domain.getId())) {
            result.add(this.domain.getId());
        }
        HashSet<URI> equivalent = new HashSet<URI>();
        equivalent.add(this.predicate);
        this.addDomain(equivalent, result, service, this.propertyShapes);
        return result;
    }

    public Set<URI> rangeIncludes(OwlReasoner reasoner) {
        HashSet<URI> result = new HashSet<URI>();
        if (this.range != null && !Konig.Undefined.equals((Object)this.range.getId())) {
            result.add(this.range.getId());
        }
        this.addRange(result, reasoner, this.propertyShapes);
        return result;
    }

    private void addRange(Set<URI> result, OwlReasoner reasoner, Set<ShowlPropertyShape> set) {
        block0: for (ShowlPropertyShape p : set) {
            Shape valueShape;
            PropertyConstraint constraint = p.getPropertyConstraint();
            if (constraint == null) continue;
            URI datatype = constraint.getDatatype();
            if (datatype != null) {
                result.add(datatype);
                continue;
            }
            URI valueClass = RdfUtil.uri((Value)constraint.getValueClass());
            if (valueClass == null && (valueShape = constraint.getShape()) != null) {
                valueClass = valueShape.getTargetClass();
            }
            if (valueClass == null || Konig.Undefined.equals((Object)valueClass)) continue;
            Iterator<URI> sequence = result.iterator();
            while (sequence.hasNext()) {
                URI other = sequence.next();
                if (reasoner.isSubClassOf((Resource)valueClass, (Resource)other)) continue block0;
                if (!reasoner.isSubClassOf((Resource)other, (Resource)valueClass)) continue;
                sequence.remove();
                break;
            }
            result.add(valueClass);
        }
    }

    private void addDomain(Set<URI> equivalentProperty, Set<URI> result, ShowlSchemaService service, Set<ShowlPropertyShape> set) {
        OwlReasoner reasoner = service.getOwlReasoner();
        block0: for (ShowlPropertyShape p : set) {
            URI owlClass = p.getDeclaringShape().getOwlClass().getId();
            Iterator<URI> sequence = result.iterator();
            while (sequence.hasNext()) {
                URI other = sequence.next();
                if (reasoner.isSubClassOf((Resource)owlClass, (Resource)other)) continue block0;
                if (!reasoner.isSubClassOf((Resource)other, (Resource)owlClass)) continue;
                sequence.remove();
                break;
            }
            if (Konig.Undefined.equals((Object)owlClass)) continue;
            result.add(owlClass);
        }
    }

    public ShowlClass inferDomain(ShowlSchemaService service) {
        if (this.domain != null) {
            return this.domain;
        }
        Set<URI> domainIncludes = this.domainIncludes(service);
        return domainIncludes.size() == 1 ? service.produceShowlClass(domainIncludes.iterator().next()) : service.produceShowlClass(Konig.Undefined);
    }

    public URI inferRange(OwlReasoner reasoner) {
        if (this.range != null) {
            return this.range.getId();
        }
        Set<URI> rangeIncludes = this.rangeIncludes(reasoner);
        return rangeIncludes.size() == 1 ? rangeIncludes.iterator().next() : null;
    }

    public ShowlClass inferRange(ShowlSchemaService service) {
        if (this.range != null) {
            return this.range;
        }
        Set<URI> rangeIncludes = this.rangeIncludes(service.getOwlReasoner());
        return rangeIncludes.size() == 1 ? service.produceShowlClass(rangeIncludes.iterator().next()) : service.produceShowlClass(Konig.Undefined);
    }

    public ShowlClass getDomain() {
        return this.domain;
    }

    public void setDomain(ShowlClass domain) {
        this.domain = domain;
        if (domain != null) {
            domain.addDomainOf(this);
        }
    }

    public ShowlClass getRange() {
        return this.range;
    }

    public void setRange(ShowlClass range) {
        this.range = range;
        if (range != null) {
            range.addRangeOf(this);
        }
    }

    public Set<ShowlProperty> getConnectedProperties() {
        HashSet<ShowlProperty> result = new HashSet<ShowlProperty>();
        this.addConnectedProperties(this, result);
        return result;
    }

    public Set<ShowlProperty> getInverses() {
        return this.inverses == null ? Collections.emptySet() : this.inverses;
    }

    public void addInverse(ShowlProperty inverseProperty) {
        if (!(inverseProperty == null || this.inverses != null && this.inverses.contains(inverseProperty))) {
            if (this.inverses == null) {
                this.inverses = new HashSet<ShowlProperty>();
            }
            this.inverses.add(inverseProperty);
            inverseProperty.addInverse(this);
            logger.trace("addInverse: {}...{}", (Object)this.predicate.getLocalName(), (Object)inverseProperty.getPredicate().getLocalName());
        }
    }

    private void addConnectedProperties(ShowlProperty p, Set<ShowlProperty> result) {
        if (!result.contains(p)) {
            result.add(p);
            for (ShowlPropertyShape q : p.getPropertyShapes()) {
                ShowlPropertyShape peer = q.getPeer();
                ShowlProperty peerProperty = peer.getProperty();
                this.addConnectedProperties(peerProperty, result);
            }
        }
    }

    public String toString() {
        return "ShowlProperty(" + this.predicate.toString() + ")";
    }
}

