/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.OwlReasoner;
import io.konig.core.showl.ShowlDerivedPropertyExpression;
import io.konig.core.showl.ShowlDerivedPropertyShape;
import io.konig.core.showl.ShowlDirectPropertyExpression;
import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlPropertyShape;
import java.util.Set;
import org.openrdf.model.URI;

public abstract class ShowlPropertyExpression
implements ShowlExpression {
    private ShowlPropertyShape sourceProperty;

    protected ShowlPropertyExpression(ShowlPropertyShape sourceProperty) {
        this.sourceProperty = sourceProperty;
    }

    public static ShowlPropertyExpression from(ShowlPropertyShape p) {
        if (p instanceof ShowlDirectPropertyShape) {
            return new ShowlDirectPropertyExpression((ShowlDirectPropertyShape)p);
        }
        return new ShowlDerivedPropertyExpression((ShowlDerivedPropertyShape)p);
    }

    public ShowlPropertyShape getSourceProperty() {
        return this.sourceProperty;
    }

    @Override
    public String displayValue() {
        return this.sourceProperty.getPath();
    }

    public String toString() {
        return "ShowlPropertyExpression(" + this.sourceProperty.getPath() + ")";
    }

    @Override
    public void addDeclaredProperties(ShowlNodeShape sourceNodeShape, Set<ShowlPropertyShape> set) throws ShowlProcessingException {
        if (sourceNodeShape.getRoot().equals(this.sourceProperty.getRootNode())) {
            set.add(this.sourceProperty);
        }
    }

    @Override
    public void addProperties(Set<ShowlPropertyShape> set) {
        ShowlPropertyShape p = this.getSourceProperty();
        set.add(p);
    }

    @Override
    public ShowlExpression transform() {
        if (this.sourceProperty.getSelectedExpression() != null) {
            return this.sourceProperty.getSelectedExpression();
        }
        return this;
    }

    @Override
    public URI valueType(OwlReasoner reasoner) {
        ShowlPropertyShape p = this.sourceProperty.maybeDirect();
        return p.getValueType(reasoner);
    }

    public static ShowlPropertyExpression of(ShowlPropertyShape p) {
        if (p.isDirect()) {
            return new ShowlDirectPropertyExpression((ShowlDirectPropertyShape)p);
        }
        return new ShowlDerivedPropertyExpression((ShowlDerivedPropertyShape)p);
    }
}

