/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.Graph;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.core.showl.ShowlManager;
import io.konig.shacl.ShapeManager;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;

public class ShowlPropertyManager
extends ShowlManager {
    public ShowlPropertyManager(ShapeManager shapeManager, OwlReasoner reasoner) {
        super(shapeManager, reasoner);
    }

    public void build() {
        this.buildClasses();
        this.buildProperties();
        this.loadShapes();
        this.inferTargetClasses();
        this.inferInverses();
    }

    private void buildProperties() {
        Graph graph = this.getReasoner().getGraph();
        for (Vertex property : graph.vertex((Resource)RDF.PROPERTY).asTraversal().in(RDF.TYPE).toVertexList()) {
            if (!(property.getId() instanceof URI)) continue;
            this.produceShowlProperty((URI)property.getId());
        }
    }

    private void buildClasses() {
        Graph graph = this.getReasoner().getGraph();
        for (Vertex owlClass : graph.vertex((Resource)OWL.CLASS).asTraversal().in(RDF.TYPE).toVertexList()) {
            if (!(owlClass.getId() instanceof URI)) continue;
            this.produceOwlClass((URI)owlClass.getId());
        }
    }
}

