/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.OwlReasoner;
import io.konig.core.impl.RdfUtil;
import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlDerivedPropertyShape;
import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlEffectiveNodeShape;
import io.konig.core.showl.ShowlEnumNodeExpression;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlJoinCondition;
import io.konig.core.showl.ShowlMapping;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlProperty;
import io.konig.core.showl.ShowlPropertyExpression;
import io.konig.core.showl.ShowlPropertyShapeGroup;
import io.konig.core.showl.ShowlSchemaService;
import io.konig.core.showl.ShowlUtil;
import io.konig.core.showl.SynsetNode;
import io.konig.core.showl.SynsetProperty;
import io.konig.core.showl.Traversable;
import io.konig.core.vocab.Konig;
import io.konig.formula.Direction;
import io.konig.formula.DirectionStep;
import io.konig.formula.PathExpression;
import io.konig.formula.PathStep;
import io.konig.formula.PrimaryExpression;
import io.konig.formula.QuantifiedExpression;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShowlPropertyShape
implements Traversable {
    private static final Logger logger = LoggerFactory.getLogger(ShowlPropertyShape.class);
    private ShowlNodeShape declaringShape;
    protected ShowlProperty property;
    private PropertyConstraint propertyConstraint;
    private ShowlNodeShape valueShape;
    private Map<ShowlJoinCondition, ShowlMapping> mappings;
    private Map<ShowlPropertyShape, ShowlJoinCondition> joinConditions;
    private ShowlMapping selectedMapping;
    private Set<Value> hasValueDeprecated;
    private ShowlExpression selectedExpression;
    private Set<ShowlPropertyShape> peerGroup = new HashSet<ShowlPropertyShape>();
    private Set<ShowlExpression> hasValue;
    private ShowlExpression formula;
    private Set<ShowlExpression> usedIn;
    private List<ShowlExpression> expressionList = new ArrayList<ShowlExpression>();
    private ShowlPropertyShapeGroup targetProperty;

    public ShowlPropertyShape(ShowlNodeShape declaringShape, ShowlProperty property, PropertyConstraint propertyConstraint) {
        this.declaringShape = declaringShape;
        this.property = property;
        this.propertyConstraint = propertyConstraint;
    }

    public NodeKind getNodeKind() {
        return this.propertyConstraint == null ? null : this.propertyConstraint.getNodeKind();
    }

    public void addMapping(ShowlMapping mapping) {
        if (this.mappings == null) {
            this.mappings = new HashMap<ShowlJoinCondition, ShowlMapping>();
        }
        this.mappings.put(mapping.getJoinCondition(), mapping);
    }

    public boolean isRequired() {
        ShowlPropertyShape delegate = this.maybeDirect();
        PropertyConstraint constraint = delegate.getPropertyConstraint();
        if (constraint != null) {
            Integer minCount = constraint.getMinCount();
            return minCount != null && minCount > 0;
        }
        return Konig.id.equals((Object)this.getPredicate());
    }

    public Collection<ShowlMapping> getMappings() {
        return this.mappings == null ? Collections.emptySet() : this.mappings.values();
    }

    public Collection<ShowlJoinCondition> listJoinConditions() {
        HashSet<ShowlJoinCondition> set = new HashSet<ShowlJoinCondition>();
        for (ShowlMapping m : this.getMappings()) {
            set.add(m.getJoinCondition());
        }
        return set;
    }

    public ShowlMapping getMapping(ShowlJoinCondition joinCondition) {
        return this.mappings == null ? null : this.mappings.get(joinCondition);
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isLeaf() {
        return this.valueShape == null;
    }

    public boolean isEnumIndividual(OwlReasoner reasoner) {
        URI owlClassId = null;
        owlClassId = Konig.id.equals((Object)this.getPredicate()) ? this.getDeclaringShape().getOwlClass().getId() : this.getOwlClassId();
        return owlClassId == null ? false : reasoner.isEnumerationClass((Resource)owlClassId);
    }

    public URI getOwlClassId() {
        URI valueClass;
        URI uRI = valueClass = this.propertyConstraint == null ? null : RdfUtil.uri((Value)this.propertyConstraint.getValueClass());
        if (valueClass != null) {
            return valueClass;
        }
        if (this.valueShape != null) {
            return this.valueShape.getOwlClass().getId();
        }
        ShowlClass range = this.property.getRange();
        return range == null ? null : range.getId();
    }

    public ShowlDerivedPropertyShape asDerivedPropertyShape() {
        return null;
    }

    public ShowlNodeShape getDeclaringShape() {
        return this.declaringShape;
    }

    public ShowlProperty getProperty() {
        return this.property;
    }

    public URI getPredicate() {
        return this.property.getPredicate();
    }

    public PropertyConstraint getPropertyConstraint() {
        return this.propertyConstraint;
    }

    public boolean isNestedAccordingToFormula() {
        PrimaryExpression primary;
        QuantifiedExpression formula;
        if (this.propertyConstraint != null && (formula = this.propertyConstraint.getFormula()) != null && (primary = formula.asPrimaryExpression()) instanceof PathExpression) {
            PathExpression path = (PathExpression)primary;
            int count = 0;
            for (PathStep step : path.getStepList()) {
                if (!(step instanceof DirectionStep) || ++count != 2) continue;
                return true;
            }
        }
        return false;
    }

    public String fullPath() {
        ArrayList<String> stepList = new ArrayList<String>();
        ShowlPropertyShape p = this;
        while (p != null) {
            stepList.add(p.getPredicate().getLocalName());
            ShowlNodeShape node = p.getDeclaringShape();
            if ((p = node.getAccessor()) != null) continue;
            p = node.getTargetProperty();
            if (p != null) {
                p = p.getDeclaringShape().getAccessor();
                continue;
            }
            if ((node = node.getTargetNode()) == null || (p = node.getAccessor()) == null) continue;
            p = p.getDeclaringShape().getAccessor();
        }
        Collections.reverse(stepList);
        StringBuilder builder = new StringBuilder();
        String dot = "";
        for (String fieldName : stepList) {
            builder.append(dot);
            builder.append(fieldName);
            dot = ".";
        }
        return builder.toString();
    }

    @Override
    public String getPath() {
        ArrayList<ShowlPropertyShape> elements = new ArrayList<ShowlPropertyShape>();
        ShowlNodeShape node = null;
        ShowlPropertyShape p = this;
        while (p != null) {
            elements.add(p);
            node = p.getDeclaringShape();
            p = node.getAccessor();
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        builder.append(RdfUtil.localName(node.getShape().getId()));
        builder.append('}');
        for (int i = elements.size() - 1; i >= 0; --i) {
            ShowlPropertyShape p2 = (ShowlPropertyShape)elements.get(i);
            builder.append(p2.pathSeparator());
            builder.append(p2.getPredicate().getLocalName());
        }
        return builder.toString();
    }

    public String toString() {
        return this.getPath();
    }

    public ShowlNodeShape getValueShape() {
        return this.valueShape;
    }

    public void setValueShape(ShowlNodeShape valueShape) {
        this.valueShape = valueShape;
    }

    public ShowlNodeShape getRootNode() {
        ShowlNodeShape root = this.declaringShape;
        while (root.getAccessor() != null) {
            root = root.getAccessor().getDeclaringShape();
        }
        return root;
    }

    public URI getValueType(OwlReasoner reasoner) {
        if (Konig.id.equals((Object)this.getPredicate())) {
            return this.getDeclaringShape().getOwlClass().getId();
        }
        if (this.propertyConstraint != null) {
            Shape shape;
            if (this.propertyConstraint.getDatatype() != null) {
                return this.propertyConstraint.getDatatype();
            }
            URI valueClass = RdfUtil.uri((Value)this.propertyConstraint.getValueClass());
            if (valueClass == null && (shape = this.propertyConstraint.getShape()) != null) {
                valueClass = shape.getTargetClass();
            }
            if (valueClass != null) {
                return valueClass;
            }
        }
        return this.property.inferRange(reasoner);
    }

    public ShowlClass getValueType(ShowlSchemaService schemaService) {
        if (this.propertyConstraint != null) {
            Shape shape;
            URI valueClass = RdfUtil.uri((Value)this.propertyConstraint.getValueClass());
            if (valueClass == null && (shape = this.propertyConstraint.getShape()) != null) {
                valueClass = shape.getTargetClass();
            }
            if (valueClass != null) {
                return schemaService.produceShowlClass(valueClass);
            }
        }
        return this.property.inferRange(schemaService);
    }

    public ShowlPropertyShape getPeer() {
        return this.peerGroup.size() == 1 ? this.peerGroup.iterator().next() : null;
    }

    void addPeer(ShowlPropertyShape peer) {
        if (logger.isDebugEnabled()) {
            logger.debug("addPeer: {} <=> {}", (Object)this.getPath(), (Object)peer.getPath());
        }
        this.peerGroup.add(peer);
        peer.peerGroup.add(this);
    }

    public Set<ShowlPropertyShape> getPeerGroup() {
        return this.peerGroup;
    }

    public void addJoinCondition(ShowlJoinCondition join) {
        ShowlPropertyShape other;
        if (this.joinConditions == null) {
            this.joinConditions = new HashMap<ShowlPropertyShape, ShowlJoinCondition>();
        }
        if ((other = join.otherProperty(this)) == null) {
            throw new IllegalArgumentException();
        }
        this.joinConditions.put(other, join);
    }

    public ShowlJoinCondition findJoinCondition(ShowlPropertyShape otherProperty) {
        return this.joinConditions == null ? null : this.joinConditions.get(otherProperty);
    }

    public char pathSeparator() {
        return '.';
    }

    public Direction getDirection() {
        return Direction.OUT;
    }

    public ShowlMapping getSelectedMapping() {
        return this.selectedMapping;
    }

    public void setSelectedMapping(ShowlMapping selectedMapping) {
        this.selectedMapping = selectedMapping;
    }

    public Set<Value> getHasValueDeprecated() {
        return this.hasValueDeprecated == null ? Collections.emptySet() : this.hasValueDeprecated;
    }

    public void addHasValueDeprecated(Value value) {
        if (this.hasValueDeprecated == null) {
            this.hasValueDeprecated = new LinkedHashSet<Value>();
        }
        this.hasValueDeprecated.add(value);
    }

    public List<ShowlExpression> getExpressionList() {
        return this.expressionList;
    }

    public void addExpression(ShowlExpression expression) {
        if (logger.isTraceEnabled()) {
            logger.trace("{}.addExpression({})", (Object)this.getPath(), (Object)expression.displayValue());
        }
        this.expressionList.add(expression);
    }

    public boolean isDeclaredWithin(ShowlNodeShape node) {
        ShowlNodeShape parent = this.declaringShape;
        while (parent != null) {
            if (parent == node) {
                return true;
            }
            parent = parent.getAccessor() == null ? null : parent.getAccessor().getDeclaringShape();
        }
        return false;
    }

    public boolean inSameNodeShape(ShowlPropertyShape other) {
        return other.isDeclaredWithin(this.declaringShape) || this.isDeclaredWithin(other.getDeclaringShape());
    }

    public ShowlPropertyShape getSynonym() {
        for (ShowlExpression e : this.expressionList) {
            ShowlPropertyShape other;
            if (!(e instanceof ShowlPropertyExpression) || !this.inSameNodeShape(other = ((ShowlPropertyExpression)e).getSourceProperty())) continue;
            return other;
        }
        return null;
    }

    public Set<ShowlPropertyShape> synonyms() {
        HashSet<ShowlPropertyShape> set = new HashSet<ShowlPropertyShape>();
        this.addSynonym(set, this);
        return set;
    }

    private void addSynonym(Set<ShowlPropertyShape> set, ShowlPropertyShape p) {
        if (!set.contains(p)) {
            set.add(p);
            ShowlExpression formula = p.getFormula();
            if (formula instanceof ShowlPropertyExpression) {
                ShowlPropertyShape q = ((ShowlPropertyExpression)formula).getSourceProperty();
                set.add(q);
            }
            for (ShowlExpression e : p.getExpressionList()) {
                ShowlPropertyShape other;
                if (!(e instanceof ShowlPropertyExpression) || !this.inSameNodeShape(other = ((ShowlPropertyExpression)e).getSourceProperty())) continue;
                this.addSynonym(set, other);
            }
        }
    }

    public List<ShowlPropertyShape> propertyPath() {
        ArrayList<ShowlPropertyShape> list = new ArrayList<ShowlPropertyShape>();
        ShowlPropertyShape p = this;
        while (p != null) {
            list.add(p);
            p = p.getDeclaringShape().getAccessor();
        }
        Collections.reverse(list);
        return list;
    }

    public ShowlDirectPropertyShape direct() {
        ShowlPropertyShape maybe = this.maybeDirect();
        return maybe instanceof ShowlDirectPropertyShape ? (ShowlDirectPropertyShape)maybe : null;
    }

    public ShowlPropertyShape maybeDirect() {
        if (this instanceof ShowlDirectPropertyShape) {
            return this;
        }
        ShowlPropertyShape synonym = this.getSynonym();
        if (synonym instanceof ShowlDirectPropertyShape) {
            return synonym;
        }
        return this;
    }

    public ShowlExpression getFormula() {
        return this.formula;
    }

    public void setFormula(ShowlExpression formula) {
        this.formula = formula;
    }

    public ShowlExpression getSelectedExpression() {
        return this.selectedExpression;
    }

    public void setSelectedExpression(ShowlExpression selectedExpression) {
        if (selectedExpression != null && logger.isTraceEnabled()) {
            logger.trace("setSelectedExpression {} = {}", (Object)this.getPath(), (Object)selectedExpression.displayValue());
            System.out.print("");
        }
        this.selectedExpression = selectedExpression;
    }

    public Set<ShowlExpression> getUsedIn() {
        return this.usedIn == null ? Collections.emptySet() : this.usedIn;
    }

    public void usedIn(ShowlExpression e) {
        if (this.usedIn == null) {
            this.usedIn = new LinkedHashSet<ShowlExpression>();
        }
        this.usedIn.add(e);
    }

    public void addHasValue(ShowlExpression e) {
        if (this.hasValue == null) {
            this.hasValue = new LinkedHashSet<ShowlExpression>();
        }
        this.hasValue.add(e);
    }

    public Set<ShowlExpression> getHasValue() {
        return this.hasValue == null ? Collections.emptySet() : this.hasValue;
    }

    public boolean isEnumIndividual() {
        return this.getSelectedExpression() instanceof ShowlEnumNodeExpression;
    }

    public boolean isEnumProperty(OwlReasoner reasoner) {
        return ShowlUtil.isEnumSourceNode(this.getDeclaringShape(), reasoner);
    }

    public boolean isTargetProperty() {
        ShowlNodeShape node = this.getDeclaringShape();
        if (node.getTargetNode() != null || node.getTargetProperty() != null) {
            return false;
        }
        ShowlNodeShape root = this.getRootNode();
        return root.getTargetNode() == null && node.getTargetProperty() == null;
    }

    public boolean isUniqueKey() {
        ShowlPropertyShape peer = this.maybeDirect();
        PropertyConstraint constraint = peer.getPropertyConstraint();
        if (constraint != null) {
            return Konig.uniqueKey.equals((Object)constraint.getStereotype());
        }
        return false;
    }

    public ShowlPropertyShapeGroup asGroup() {
        ShowlEffectiveNodeShape node = this.getDeclaringShape().effectiveNode();
        return node.findPropertyByPredicate(this.getPredicate());
    }

    public SynsetProperty asSynsetProperty() {
        SynsetNode node = this.getDeclaringShape().synsetNode();
        return node.findPropertyByPredicate(this.getPredicate());
    }

    public ShowlPropertyShapeGroup getTargetProperty() {
        return this.targetProperty;
    }

    public void setTargetProperty(ShowlPropertyShapeGroup targetProperty) {
        this.targetProperty = targetProperty;
    }

    public boolean isRepeated() {
        return this.propertyConstraint != null && this.propertyConstraint.getMaxCount() == null;
    }
}

