/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.OwlReasoner;
import io.konig.core.impl.RdfUtil;
import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlEffectiveNodeShape;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlManager;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlProperty;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlPropertyShapeSynSet;
import io.konig.core.showl.ShowlUtil;
import io.konig.shacl.PropertyConstraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class ShowlPropertyShapeGroup
extends ArrayList<ShowlPropertyShape>
implements Comparable<ShowlPropertyShapeGroup> {
    private ShowlEffectiveNodeShape declaringShape;
    private URI predicate;
    private ShowlEffectiveNodeShape valueShape;
    private ShowlExpression selectedExpression;

    public ShowlPropertyShapeGroup(ShowlEffectiveNodeShape declaringShape, URI predicate) {
        this.declaringShape = declaringShape;
        this.predicate = predicate;
    }

    public ShowlEffectiveNodeShape getValueShape() {
        return this.valueShape;
    }

    public void setValueShape(ShowlEffectiveNodeShape valueShape) {
        this.valueShape = valueShape;
    }

    public ShowlPropertyShapeSynSet synonyms() {
        ShowlPropertyShapeSynSet set = new ShowlPropertyShapeSynSet();
        for (ShowlPropertyShape p : this) {
            Set<ShowlPropertyShape> synset = p.synonyms();
            for (ShowlPropertyShape q : synset) {
                set.add(q.asGroup());
            }
        }
        return set;
    }

    public ShowlEffectiveNodeShape getDeclaringShape() {
        return this.declaringShape;
    }

    public URI getPredicate() {
        return this.predicate;
    }

    public ShowlPropertyShape bestTarget() {
        ShowlPropertyShape result = this.direct();
        if (result != null) {
            return result;
        }
        result = this.withSelectedExpression();
        if (result != null) {
            return result;
        }
        return this.withFormula();
    }

    private ShowlPropertyShape withFormula() {
        for (ShowlPropertyShape p : this) {
            if (p.getFormula() == null) continue;
            return p;
        }
        return null;
    }

    public ShowlPropertyShape withSelectedExpression() {
        for (ShowlPropertyShape p : this) {
            if (p.getSelectedExpression() == null) continue;
            return p;
        }
        return null;
    }

    public ShowlManager getShowlManager() {
        return this.isEmpty() ? null : ((ShowlPropertyShape)this.get(0)).getDeclaringShape().getShowlManager();
    }

    public ShowlClass range() {
        ShowlClass result = null;
        ShowlDirectPropertyShape direct = this.direct();
        if (direct != null) {
            result = this.rangeClass(direct);
        }
        if (result == null) {
            for (ShowlPropertyShape p : this) {
                ShowlClass range = this.rangeClass(p);
                if (range == null) continue;
                if (result == null) {
                    result = range;
                    continue;
                }
                result = this.mostGeneralType(result, range);
            }
        }
        if (result == null) {
            ShowlManager manager = this.getShowlManager();
            ShowlProperty property = manager.produceShowlProperty(this.predicate);
            result = property.inferRange(manager.getShowlFactory());
        }
        return result;
    }

    private ShowlClass mostGeneralType(ShowlClass a, ShowlClass b) {
        OwlReasoner reasoner = this.getShowlManager().getReasoner();
        return reasoner.isSubClassOf((Resource)a.getId(), (Resource)b.getId()) ? b : a;
    }

    private ShowlClass rangeClass(ShowlPropertyShape p) {
        PropertyConstraint c = p.getPropertyConstraint();
        if (c != null) {
            URI rangeId = c.getDatatype();
            if (rangeId == null) {
                rangeId = RdfUtil.uri((Value)c.getValueClass());
            }
            if (rangeId == null && c.getShape() != null) {
                rangeId = c.getShape().getTargetClass();
            }
            if (rangeId != null) {
                return this.getShowlManager().produceOwlClass(rangeId);
            }
        }
        return null;
    }

    public ShowlDirectPropertyShape direct() {
        for (ShowlPropertyShape p : this) {
            if (!(p instanceof ShowlDirectPropertyShape)) continue;
            return (ShowlDirectPropertyShape)p;
        }
        return null;
    }

    public ShowlDirectPropertyShape synonymDirect() {
        for (ShowlPropertyShape p : this) {
            if (!(p instanceof ShowlDirectPropertyShape)) continue;
            return (ShowlDirectPropertyShape)p;
        }
        for (ShowlPropertyShape p : this) {
            ShowlPropertyShape synonym = p.getSynonym();
            if (!(synonym instanceof ShowlDirectPropertyShape)) continue;
            return (ShowlDirectPropertyShape)synonym;
        }
        return null;
    }

    public List<ShowlPropertyShapeGroup> path() {
        ArrayList<ShowlPropertyShapeGroup> result = new ArrayList<ShowlPropertyShapeGroup>();
        ShowlPropertyShapeGroup p = this;
        while (p != null) {
            result.add(p);
            p = p.getDeclaringShape().getAccessor();
        }
        Collections.reverse(result);
        return result;
    }

    public List<ShowlPropertyShapeGroup> relativePath(ShowlEffectiveNodeShape root) {
        ArrayList<ShowlPropertyShapeGroup> result = new ArrayList<ShowlPropertyShapeGroup>();
        ShowlPropertyShapeGroup p = this;
        while (p != null) {
            result.add(p);
            if (p.getDeclaringShape() == root) break;
            p = p.getDeclaringShape().getAccessor();
        }
        Collections.reverse(result);
        return result;
    }

    public String pathString() {
        List<ShowlPropertyShapeGroup> path = this.path();
        StringBuilder builder = new StringBuilder();
        builder.append(path.get(0).getDeclaringShape().toString());
        for (ShowlPropertyShapeGroup p : path) {
            builder.append('.');
            builder.append(p.getPredicate().getLocalName());
        }
        return builder.toString();
    }

    @Override
    public String toString() {
        return this.pathString();
    }

    public ShowlEffectiveNodeShape getRootNode() {
        return this.declaringShape.getRoot();
    }

    public ShowlExpression getSelectedExpression() {
        return this.selectedExpression;
    }

    public void setSelectedExpression(ShowlExpression selectedExpression) {
        this.selectedExpression = selectedExpression;
    }

    public boolean isWellDefined() {
        for (ShowlPropertyShape p : this) {
            if (!ShowlUtil.isWellDefined(p)) continue;
            return true;
        }
        return false;
    }

    public ShowlPropertyShape first() {
        return this.isEmpty() ? null : (ShowlPropertyShape)this.get(0);
    }

    public boolean isUniqueKey() {
        for (ShowlPropertyShape p : this) {
            if (!p.isUniqueKey()) continue;
            return true;
        }
        return false;
    }

    public ShowlNodeShape rootNode() {
        return this.isEmpty() ? null : ((ShowlPropertyShape)this.get(0)).getRootNode();
    }

    @Override
    public int compareTo(ShowlPropertyShapeGroup other) {
        int result = this.getPredicate().getLocalName().compareTo(other.getPredicate().getLocalName());
        return result == 0 ? this.getPredicate().getNamespace().compareTo(other.getPredicate().getNamespace()) : result;
    }
}

