/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.Edge;
import io.konig.core.Graph;
import io.konig.core.NamespaceManager;
import io.konig.core.OwlReasoner;
import io.konig.core.Vertex;
import io.konig.core.impl.RdfUtil;
import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlDataSource;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlNodeShapeBuilder;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlProperty;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlService;
import io.konig.core.vocab.Konig;
import io.konig.datasource.DataSource;
import io.konig.shacl.NodeKind;
import io.konig.shacl.PropertyConstraint;
import io.konig.shacl.Shape;
import io.konig.shacl.ShapeManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowlServiceImpl
implements ShowlService {
    private static Logger logger = LoggerFactory.getLogger(ShowlServiceImpl.class);
    private Map<URI, ShowlClass> classMap = new HashMap<URI, ShowlClass>();
    private Map<URI, ShowlProperty> propertyMap = new HashMap<URI, ShowlProperty>();
    private Map<URI, Shape> enumNodeShapes = new HashMap<URI, Shape>();
    private OwlReasoner reasoner;
    private ShowlNodeShapeBuilder nodeBuilder;

    public ShowlServiceImpl(OwlReasoner reasoner) {
        this.reasoner = reasoner;
        this.nodeBuilder = new ShowlNodeShapeBuilder(this, this);
    }

    @Override
    public ShowlClass produceShowlClass(URI id) {
        ShowlClass owlClass = this.classMap.get(id);
        if (owlClass == null) {
            owlClass = new ShowlClass(this.reasoner, id);
            this.classMap.put(id, owlClass);
        }
        return owlClass;
    }

    @Override
    public ShowlProperty produceProperty(URI predicate) {
        ShowlProperty property = this.propertyMap.get(predicate);
        if (property == null) {
            property = new ShowlProperty(predicate);
            this.propertyMap.put(predicate, property);
            URI domain = RdfUtil.uri((Value)this.reasoner.getDomain(predicate));
            URI range = RdfUtil.uri((Value)this.reasoner.getRange(predicate));
            if (domain != null) {
                property.setDomain(this.produceShowlClass(domain));
            }
            if (range != null) {
                property.setRange(this.produceShowlClass(range));
            }
        }
        return property;
    }

    @Override
    public ShowlNodeShape logicalNodeShape(URI owlClass) throws ShowlProcessingException {
        throw new ShowlProcessingException("not implemented yet");
    }

    @Override
    public ShowlNodeShape createNodeShape(Shape shape) throws ShowlProcessingException {
        return this.createShowlNodeShape(null, shape, this.produceShowlClass(shape.getTargetClass()));
    }

    @Override
    public ShowlNodeShape createNodeShape(Shape shape, DataSource ds) throws ShowlProcessingException {
        ShowlNodeShape node = this.createNodeShape(shape);
        ShowlDataSource dataSource = new ShowlDataSource(node, ds);
        node.setShapeDataSource(dataSource);
        return node;
    }

    @Override
    public ShowlClass inferDomain(ShowlProperty p) {
        return p.inferDomain(this);
    }

    @Override
    public ShowlClass inferRange(ShowlProperty p) {
        return p.inferRange(this);
    }

    @Override
    public ShowlClass mostSpecificClass(ShowlClass a, ShowlClass b) {
        ShowlClass result = a == null ? b : (b == null ? a : (this.reasoner.isSubClassOf((Resource)a.getId(), (Resource)b.getId()) ? a : b));
        return result == null ? this.produceShowlClass(Konig.Undefined) : result;
    }

    @Override
    public ShowlNodeShape createShowlNodeShape(ShowlPropertyShape accessor, Shape shape, ShowlClass owlClass) {
        return this.nodeBuilder.buildNodeShape(accessor, shape);
    }

    @Override
    public Set<ShowlNodeShape> selectCandidateSources(ShowlNodeShape targetShape) {
        throw new ShowlProcessingException("not implemented yet");
    }

    @Override
    public ShapeManager getShapeManager() {
        throw new ShowlProcessingException("not implemented yet");
    }

    @Override
    public Graph getGraph() {
        return this.reasoner.getGraph();
    }

    @Override
    public OwlReasoner getOwlReasoner() {
        return this.reasoner;
    }

    @Override
    public Shape enumNodeShape(ShowlClass enumClass) throws ShowlProcessingException {
        Shape result = this.enumNodeShapes.get(enumClass.getId());
        if (result == null) {
            result = this.enumShape(enumClass.getId());
            this.enumNodeShapes.put(enumClass.getId(), result);
        }
        return result;
    }

    private Shape enumShape(URI classId) throws ShowlProcessingException {
        Graph graph = this.reasoner.getGraph();
        NamespaceManager nsManager = graph.getNamespaceManager();
        Namespace ns = nsManager.findByName(classId.getNamespace());
        if (ns == null) {
            throw new ShowlProcessingException("Prefix not found for namespace <" + classId.getNamespace() + ">");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("urn:konig:enumShape/");
        builder.append(ns.getPrefix());
        builder.append('/');
        builder.append(classId.getLocalName());
        URIImpl shapeId = new URIImpl(builder.toString());
        Shape shape = new Shape((Resource)shapeId);
        shape.setNodeKind(NodeKind.IRI);
        shape.setTargetClass(classId);
        ShowlClass owlClass = this.classMap.get(classId);
        if (owlClass == null) {
            throw new ShowlProcessingException("ShowlClass not defined: " + classId);
        }
        this.addProperties(shape, owlClass);
        return shape;
    }

    private void addProperties(Shape shape, ShowlClass owlClass) throws ShowlProcessingException {
        URI classId = owlClass.getId();
        List<Vertex> individualList = this.reasoner.getGraph().v((Resource)classId).in(RDF.TYPE).toVertexList();
        if (individualList.isEmpty()) {
            throw new ShowlProcessingException("No members found in enumeration " + classId.getLocalName());
        }
        for (Vertex member : individualList) {
            for (Map.Entry<URI, Set<Edge>> entry : member.outEdges()) {
                URI range;
                Set<Edge> edgeSet = entry.getValue();
                URI predicate = entry.getKey();
                if (predicate.equals((Object)RDF.TYPE)) continue;
                if (edgeSet.size() > 1) {
                    logger.warn("Ignoring property {}.{} because multi-valued properties are not supported yet.", (Object)classId.getLocalName(), (Object)predicate.getLocalName());
                    continue;
                }
                ShowlProperty property = this.propertyMap.get(predicate);
                URI uRI = range = property == null ? RdfUtil.uri((Value)this.reasoner.getRange(predicate)) : property.inferRange(this.reasoner);
                if (range == null) {
                    logger.warn("Ignoring property {}.{} because the range is not known.", (Object)classId.getLocalName(), (Object)predicate.getLocalName());
                    continue;
                }
                PropertyConstraint constraint = shape.getPropertyConstraint(predicate);
                if (constraint != null) continue;
                constraint = new PropertyConstraint(predicate);
                shape.add(constraint);
                if (this.reasoner.isDatatype((Resource)range)) {
                    constraint.setDatatype(range);
                } else {
                    constraint.setValueClass((Resource)range);
                    constraint.setNodeKind(NodeKind.IRI);
                }
                constraint.setMinCount(0);
                constraint.setMaxCount(1);
            }
        }
        if (shape.getProperty().isEmpty()) {
            throw new ShowlProcessingException("No properties found in enumeration class " + classId.getLocalName());
        }
    }
}

