/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.OwlReasoner;
import io.konig.core.showl.ShowlDirectPropertyShape;
import io.konig.core.showl.ShowlExpression;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlProcessingException;
import io.konig.core.showl.ShowlPropertyShape;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShowlStructExpression
extends LinkedHashMap<URI, ShowlExpression>
implements ShowlExpression {
    private static final Logger logger = LoggerFactory.getLogger(ShowlStructExpression.class);
    private ShowlDirectPropertyShape propertyShape;

    protected ShowlStructExpression(ShowlDirectPropertyShape propertyShape) {
        this.propertyShape = propertyShape;
    }

    @Override
    public String displayValue() {
        return this.propertyShape.getPath();
    }

    public ShowlDirectPropertyShape getPropertyShape() {
        return this.propertyShape;
    }

    @Override
    public void addDeclaredProperties(ShowlNodeShape sourceNodeShape, Set<ShowlPropertyShape> set) throws ShowlProcessingException {
        for (ShowlExpression e : this.values()) {
            e.addDeclaredProperties(sourceNodeShape, set);
        }
    }

    @Override
    public ShowlExpression put(URI key, ShowlExpression value) {
        if (logger.isTraceEnabled()) {
            logger.trace("put({}, {})", (Object)key.getLocalName(), (Object)value.displayValue());
        }
        return super.put(key, value);
    }

    @Override
    public void addProperties(Set<ShowlPropertyShape> set) {
        for (ShowlExpression e : this.values()) {
            e.addProperties(set);
        }
    }

    @Override
    public URI valueType(OwlReasoner reasoner) {
        return this.propertyShape.maybeDirect().getValueType(reasoner);
    }

    protected abstract ShowlStructExpression copy();

    public ShowlStructExpression shallowClone() {
        ShowlStructExpression clone = this.copy();
        for (Map.Entry entry : this.entrySet()) {
            clone.put((URI)entry.getKey(), (ShowlExpression)entry.getValue());
        }
        return clone;
    }

    @Override
    public ShowlStructExpression transform() {
        ShowlStructExpression copy = this.copy();
        for (Map.Entry entry : this.entrySet()) {
            copy.put((URI)entry.getKey(), ((ShowlExpression)entry.getValue()).transform());
        }
        return copy;
    }
}

