/*
 * Decompiled with CFR 0.152.
 */
package io.konig.core.showl;

import io.konig.core.OwlReasoner;
import io.konig.core.showl.ShowlClass;
import io.konig.core.showl.ShowlNodeShape;
import io.konig.core.showl.ShowlProperty;
import io.konig.core.showl.ShowlPropertyShape;
import io.konig.core.showl.ShowlService;
import io.konig.core.vocab.Konig;
import io.konig.formula.Direction;
import io.konig.formula.DirectionStep;
import io.konig.formula.PathExpression;
import io.konig.formula.PathStep;
import io.konig.formula.PrimaryExpression;
import io.konig.formula.QuantifiedExpression;
import io.konig.shacl.PropertyConstraint;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowlTargetClassReasoner {
    private static final Logger logger = LoggerFactory.getLogger(ShowlTargetClassReasoner.class);
    private ShowlService service;

    public ShowlTargetClassReasoner(ShowlService service) {
        this.service = service;
    }

    public void inferTargetClass() {
        ShowlClass undefined = this.service.produceShowlClass(Konig.Undefined);
        for (ShowlNodeShape node : undefined.getTargetClassOf()) {
            this.inferTargetClassOf(node);
        }
    }

    private void inferTargetClassOf(ShowlNodeShape node) {
        DomainReasoner domainReasoner = new DomainReasoner(this.service.getOwlReasoner());
        Set<ShowlPropertyShape> allProperties = node.allOutwardProperties();
        for (ShowlPropertyShape p : allProperties) {
            ShowlProperty property;
            if (p.isNestedAccordingToFormula() || (property = p.getProperty()) == null) continue;
            if (property.getDomain() != null) {
                domainReasoner.require(property.getDomain().getId());
                continue;
            }
            domainReasoner.domainIncludes(property.domainIncludes(this.service));
        }
        Set<URI> candidates = domainReasoner.getRequiredClasses();
        if (candidates.isEmpty()) {
            candidates = this.inferTargetClassFromFormula(node, domainReasoner);
        }
        if (candidates.size() == 1) {
            URI owlClass = candidates.iterator().next();
            this.replaceOwlClass(node, owlClass);
            if (logger.isTraceEnabled()) {
                logger.trace("inferTargetClass: Set {} as target class of {}", (Object)owlClass.getLocalName(), (Object)node.getPath());
            }
        } else if (logger.isWarnEnabled()) {
            if (candidates.isEmpty()) {
                candidates = domainReasoner.getAllClasses();
            }
            if (candidates.isEmpty()) {
                logger.warn("No candidates found for target class of " + node.getPath());
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append("Target class at " + node.getPath() + " is ambiguous.  Candidates include\n");
                for (URI c : candidates) {
                    builder.append("  ");
                    builder.append(c.getLocalName());
                    builder.append('\n');
                }
                logger.warn(builder.toString());
            }
        }
    }

    private <T> Set<T> setOf(T ... elements) {
        HashSet<T> result = new HashSet<T>();
        for (T e : elements) {
            result.add(e);
        }
        return result;
    }

    private Set<URI> inferTargetClassFromFormula(ShowlNodeShape node, DomainReasoner domainReasoner) {
        ShowlPropertyShape accessor = node.getAccessor();
        if (accessor != null) {
            ShowlClass owlClass = accessor.getProperty().getRange();
            if (owlClass != null) {
                return this.setOf(owlClass.getId());
            }
            ShowlPropertyShape peer = accessor.getPeer();
            if (peer != null && (owlClass = peer.getProperty().getRange()) != null) {
                return this.setOf(owlClass.getId());
            }
        }
        boolean updated = false;
        for (ShowlPropertyShape showlPropertyShape : node.getProperties()) {
            URI predicate;
            ShowlProperty property;
            DirectionStep dirStep;
            PathStep step;
            PathExpression path;
            List<PathStep> stepList;
            PrimaryExpression primary;
            QuantifiedExpression formula;
            PropertyConstraint constraint = showlPropertyShape.getPropertyConstraint();
            if (constraint == null || (formula = constraint.getFormula()) == null || !((primary = formula.asPrimaryExpression()) instanceof PathExpression) || (stepList = (path = (PathExpression)primary).getStepList()).size() != 1 || !((step = stepList.get(0)) instanceof DirectionStep) || (dirStep = (DirectionStep)step).getDirection() != Direction.OUT || (property = this.service.produceProperty(predicate = dirStep.getTerm().getIri())) == null) continue;
            Set<URI> domainIncludes = property.domainIncludes(this.service);
            domainReasoner.domainIncludes(domainIncludes);
            updated = true;
        }
        return updated ? domainReasoner.getRequiredClasses() : Collections.emptySet();
    }

    private void replaceOwlClass(ShowlNodeShape node, URI owlClassId) {
        node.getOwlClass().getTargetClassOf().remove(node);
        ShowlClass newClass = this.service.produceShowlClass(owlClassId);
        node.setOwlClass(newClass);
        newClass.addTargetClassOf(node);
        if (logger.isDebugEnabled()) {
            logger.debug("Set OWL Class of " + node.getPath() + " as <" + owlClassId.stringValue() + ">");
        }
    }

    private class ModalClass {
        private boolean required;
        private URI owlClass;

        public ModalClass(URI owlClass, boolean required) {
            this.required = required;
            this.owlClass = owlClass;
        }

        public boolean isRequired() {
            return this.required;
        }

        public URI getOwlClass() {
            return this.owlClass;
        }

        public void update(URI owlClass, boolean required) {
            this.owlClass = owlClass;
            if (required) {
                this.required = true;
            }
        }
    }

    private class DomainReasoner {
        private OwlReasoner reasoner;
        private Set<ModalClass> candidates = new HashSet<ModalClass>();

        public DomainReasoner(OwlReasoner reasoner) {
            this.reasoner = reasoner;
        }

        public void require(URI owlClass) {
            this.candidates.add(new ModalClass(owlClass, true));
        }

        public void domainIncludes(Set<URI> domainIncludes) {
            boolean required = domainIncludes.size() == 1;
            for (URI domain : domainIncludes) {
                URI matched = null;
                for (ModalClass modal : this.candidates) {
                    URI candidate = modal.getOwlClass();
                    if (this.reasoner.isSubClassOf((Resource)domain, (Resource)candidate)) {
                        modal.update(domain, required);
                        matched = domain;
                        continue;
                    }
                    if (!this.reasoner.isSubClassOf((Resource)candidate, (Resource)domain)) continue;
                    modal.update(candidate, required);
                    matched = candidate;
                }
                if (matched != null) continue;
                this.candidates.add(new ModalClass(domain, required));
            }
        }

        public Set<URI> getRequiredClasses() {
            HashSet<URI> result = new HashSet<URI>();
            for (ModalClass modal : this.candidates) {
                if (!modal.isRequired()) continue;
                result.add(modal.getOwlClass());
            }
            return result;
        }

        public Set<URI> getAllClasses() {
            HashSet<URI> result = new HashSet<URI>();
            for (ModalClass modal : this.candidates) {
                result.add(modal.getOwlClass());
            }
            return result;
        }
    }
}

